/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.mount;

import java.util.HashMap;
import java.util.Map;

public final class Mount {
    public static final int ProgramId = 100005;
    public static final int VersionId1 = 1;
    public static final int VersionId3 = 3;
    public static final int FileHandleSize1 = 32;
    public static final int FileHandleSize3 = 32;

    public static enum StatusCode {
        Success(0),
        Perm(1),
        NoEnt(2),
        IO(5),
        Access(13),
        NotDir(20),
        InVal(22),
        NameTooLong(63),
        NotSupp(10004),
        ServerFault(10006),
        Invalid(65535);

        private final int stsCode;
        private static Map<Integer, StatusCode> _stsMap;

        private StatusCode(int id) {
            this.stsCode = id;
        }

        public final int intValue() {
            return this.stsCode;
        }

        public static final StatusCode fromInt(int sts) {
            if (_stsMap.containsKey(sts)) {
                return _stsMap.get(sts);
            }
            return Invalid;
        }

        static {
            _stsMap = new HashMap<Integer, StatusCode>();
            for (StatusCode sts : StatusCode.values()) {
                _stsMap.put(sts.intValue(), sts);
            }
        }
    }

    public static enum ProcedureId3 {
        Null(0),
        Mnt(1),
        Dump(2),
        UMnt(3),
        UMntAll(4),
        Export(5),
        Invalid(65535);

        private final int procId;
        private static Map<Integer, ProcedureId3> _idMap;

        private ProcedureId3(int id) {
            this.procId = id;
        }

        public final int intValue() {
            return this.procId;
        }

        public static final ProcedureId3 fromInt(int typ) {
            if (_idMap.containsKey(typ)) {
                return _idMap.get(typ);
            }
            return Invalid;
        }

        static {
            _idMap = new HashMap<Integer, ProcedureId3>();
            for (ProcedureId3 id : ProcedureId3.values()) {
                _idMap.put(id.intValue(), id);
            }
        }
    }

    public static enum ProcedureId1 {
        Null(0),
        Mnt(1),
        Dump(2),
        UMnt(3),
        UMntAll(4),
        Export(5),
        ExportAll(6),
        Invalid(65535);

        private final int procId;
        private static Map<Integer, ProcedureId1> _idMap;

        private ProcedureId1(int id) {
            this.procId = id;
        }

        public final int intValue() {
            return this.procId;
        }

        public static final ProcedureId1 fromInt(int typ) {
            if (_idMap.containsKey(typ)) {
                return _idMap.get(typ);
            }
            return Invalid;
        }

        static {
            _idMap = new HashMap<Integer, ProcedureId1>();
            for (ProcedureId1 id : ProcedureId1.values()) {
                _idMap.put(id.intValue(), id);
            }
        }
    }
}

