/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.mount;

import java.util.ArrayList;
import java.util.List;
import org.filesys.oncrpc.mount.MountEntry;

public class MountEntryList {
    private List<MountEntry> m_mounts = new ArrayList<MountEntry>();

    public final synchronized void addEntry(MountEntry entry) {
        this.m_mounts.add(entry);
    }

    public final synchronized int numberOfEntries() {
        return this.m_mounts.size();
    }

    public final synchronized MountEntry getEntryAt(int idx) {
        if (idx < 0 || idx >= this.m_mounts.size()) {
            return null;
        }
        return this.m_mounts.get(idx);
    }

    public final synchronized MountEntry findEntry(String path, String host) {
        for (int i = 0; i < this.m_mounts.size(); ++i) {
            MountEntry entry = this.m_mounts.get(i);
            if (host.compareTo(entry.getHost()) != 0 || path.compareTo(entry.getPath()) != 0) continue;
            return entry;
        }
        return null;
    }

    public final synchronized MountEntry removeEntry(String path, String host) {
        for (int i = 0; i < this.m_mounts.size(); ++i) {
            MountEntry entry = this.m_mounts.get(i);
            if (host.compareTo(entry.getHost()) != 0 || path.compareTo(entry.getPath()) != 0) continue;
            this.m_mounts.remove(i);
            return entry;
        }
        return null;
    }

    public final synchronized void removeHostEntries(String host) {
        for (int i = 0; i < this.m_mounts.size(); ++i) {
            MountEntry entry = this.m_mounts.get(i);
            if (host.compareTo(entry.getHost()) != 0) continue;
            this.m_mounts.remove(i);
        }
    }

    public final synchronized MountEntryList findSessionEntries(String host) {
        MountEntryList list = new MountEntryList();
        for (int i = 0; i < this.m_mounts.size(); ++i) {
            MountEntry entry = this.m_mounts.get(i);
            if (host.compareTo(entry.getHost()) != 0) continue;
            list.addEntry(entry);
        }
        if (list.numberOfEntries() == 0) {
            list = null;
        }
        return list;
    }

    public final synchronized void removeAllItems() {
        this.m_mounts.clear();
    }
}

