/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

import java.util.EnumSet;
import org.filesys.oncrpc.RpcAuthenticator;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.server.config.ConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class NFSConfigSection
extends ConfigSection {
    public static final String SectionName = "NFS";
    private boolean m_nfsPortMapper;
    private int m_portMapperPort = 111;
    private int m_mountServerPort;
    private int m_nfsServerPort = 2049;
    private int m_rpcRegisterPort;
    private EnumSet<NFSSrvSession.Dbg> m_nfsDebug;
    private boolean m_portMapDebug;
    private boolean m_mountServerDebug;
    private RpcAuthenticator m_rpcAuthenticator;
    private ConfigElement m_rpcAuthParams;
    private long m_nfsFileCacheIOTimer;
    private long m_nfsFileCacheCloseTimer;
    private boolean m_nfsFileCacheDebug;
    private boolean m_disableNIO;

    public NFSConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final boolean hasPortMapperDebug() {
        return this.m_portMapDebug;
    }

    public final boolean hasMountServerDebug() {
        return this.m_mountServerDebug;
    }

    public final boolean hasNFSPortMapper() {
        return this.m_nfsPortMapper;
    }

    public final int getPortMapperPort() {
        return this.m_portMapperPort;
    }

    public final int getMountServerPort() {
        return this.m_mountServerPort;
    }

    public final int getNFSServerPort() {
        return this.m_nfsServerPort;
    }

    public final int getRPCRegistrationPort() {
        return this.m_rpcRegisterPort;
    }

    public final EnumSet<NFSSrvSession.Dbg> getNFSDebug() {
        return this.m_nfsDebug;
    }

    public final RpcAuthenticator getRpcAuthenticator() {
        return this.m_rpcAuthenticator;
    }

    public final ConfigElement getRPCAuthenticatorParameters() {
        return this.m_rpcAuthParams;
    }

    public final long getNFSFileCacheIOTimer() {
        return this.m_nfsFileCacheIOTimer;
    }

    public final long getNFSFileCacheCloseTimer() {
        return this.m_nfsFileCacheCloseTimer;
    }

    public final boolean hasNFSFileCacheDebug() {
        return this.m_nfsFileCacheDebug;
    }

    public final boolean hasDisableNIOCode() {
        return this.m_disableNIO;
    }

    public final int setNFSPortMapper(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_nfsPortMapper != ena) {
            sts = this.fireConfigurationChange(262145, new Boolean(ena));
            this.m_nfsPortMapper = ena;
        }
        return sts;
    }

    public final int setNFSDebug(EnumSet<NFSSrvSession.Dbg> dbg) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262146, dbg);
        this.m_nfsDebug = dbg;
        return sts;
    }

    public final int setPortMapperPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262148, new Integer(port));
        this.m_portMapperPort = port;
        return sts;
    }

    public final int setMountServerPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262149, new Integer(port));
        this.m_mountServerPort = port;
        return sts;
    }

    public final int setNFSServerPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262150, new Integer(port));
        this.m_nfsServerPort = port;
        return sts;
    }

    public final int setRPCRegistrationPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262158, new Integer(port));
        this.m_rpcRegisterPort = port;
        return sts;
    }

    public final int setPortMapperDebug(boolean dbg) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_portMapDebug != dbg) {
            sts = this.fireConfigurationChange(262152, new Boolean(dbg));
            this.m_portMapDebug = dbg;
        }
        return sts;
    }

    public final int setMountServerDebug(boolean dbg) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_portMapDebug != dbg) {
            sts = this.fireConfigurationChange(262153, new Boolean(dbg));
            this.m_mountServerDebug = dbg;
        }
        return sts;
    }

    public final int setRpcAuthenticator(String authClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        RpcAuthenticator auth = null;
        try {
            Object authObj = Class.forName(authClass).newInstance();
            if (!(authObj instanceof RpcAuthenticator)) {
                throw new InvalidConfigurationException("RPC Authenticator is not derived from required base class");
            }
            auth = (RpcAuthenticator)authObj;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("RPC Authenticator class " + authClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("RPC Authenticator class error");
        }
        auth.initialize(this.getServerConfiguration(), params);
        sts = this.setRpcAuthenticator(auth);
        this.m_rpcAuthParams = params;
        return sts;
    }

    public final int setRpcAuthenticator(RpcAuthenticator auth) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262154, auth);
        this.m_rpcAuthenticator = auth;
        return sts;
    }

    public final int setNFSFileCacheIOTimer(long ioTimer) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262155, new Long(ioTimer));
        this.m_nfsFileCacheIOTimer = ioTimer;
        return sts;
    }

    public final int setNFSFileCacheCloseTimer(long closeTimer) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262156, new Long(closeTimer));
        this.m_nfsFileCacheCloseTimer = closeTimer;
        return sts;
    }

    public final int setNFSFileCacheDebug(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_nfsFileCacheDebug != ena) {
            sts = this.fireConfigurationChange(262157, new Boolean(ena));
            this.m_nfsFileCacheDebug = ena;
        }
        return sts;
    }

    public final int setDisableNIOCode(boolean disableNIO) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(262159, new Boolean(disableNIO));
        this.m_disableNIO = disableNIO;
        return sts;
    }
}

