/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.nio;

import java.nio.channels.SelectionKey;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.server.thread.ThreadRequest;

public class NIORpcThreadRequest
implements ThreadRequest {
    private static final int MaxPacketsPerRun = 4;
    private NFSSrvSession m_sess;
    private SelectionKey m_selectionKey;

    public NIORpcThreadRequest(NFSSrvSession sess, SelectionKey selKey) {
        this.m_sess = sess;
        this.m_selectionKey = selKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            int pktCount = 0;
            boolean morePkts = true;
            boolean pktError = false;
            RpcPacket rpcPkt = null;
            RpcPacket rpcResponse = null;
            while (pktCount < 4 && morePkts && !pktError) {
                try {
                    RpcPacketHandler pktHandler = this.m_sess.getPacketHandler();
                    if (pktHandler == null) {
                        rpcPkt = null;
                        morePkts = false;
                        continue;
                    }
                    rpcPkt = pktHandler.receiveRpc();
                    if (rpcPkt == null) {
                        if (pktCount == 0) {
                            if (this.m_sess.hasDebug(NFSSrvSession.Dbg.SOCKET)) {
                                Debug.println("Received null packet, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
                            }
                            this.m_sess.closeSession();
                            this.m_selectionKey.cancel();
                            this.m_selectionKey.selector().wakeup();
                            pktError = true;
                        }
                        morePkts = false;
                        continue;
                    }
                    if (++pktCount == 4) {
                        this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                        this.m_selectionKey.selector().wakeup();
                    }
                    rpcPkt.setClientDetails(this.m_sess.getRemoteAddress(), this.m_sess.getRemotePort(), Rpc.ProtocolId.TCP);
                    rpcResponse = this.m_sess.getNFSServer().processRpc(rpcPkt);
                    if (rpcResponse != null) {
                        this.m_sess.getPacketHandler().sendRpcResponse(rpcResponse);
                    }
                    this.m_sess.getNFSServer().getPacketPool().releasePacket(rpcPkt);
                    if (rpcPkt.hasAssociatedPacket() && rpcPkt.getAssociatedPacket().isAllocatedFromPool()) {
                        this.m_sess.getNFSServer().getPacketPool().releasePacket(rpcPkt.getAssociatedPacket());
                    }
                    rpcPkt = null;
                    rpcResponse = null;
                }
                catch (Throwable ex) {
                    if (this.m_sess.hasDebug(NFSSrvSession.Dbg.SOCKET)) {
                        Debug.println("Error during packet receive, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress() + "/" + this.m_sess.getRemotePort() + " ex=" + ex.getMessage());
                        Debug.println(ex);
                    }
                    this.m_sess.closeSession();
                    this.m_selectionKey.cancel();
                    this.m_selectionKey.selector().wakeup();
                    pktError = true;
                }
                finally {
                    if (rpcPkt != null && rpcPkt.isAllocatedFromPool()) {
                        this.m_sess.getNFSServer().getPacketPool().releasePacket(rpcPkt);
                    }
                    if (rpcPkt == null || !rpcPkt.hasAssociatedPacket() || !rpcPkt.getAssociatedPacket().isAllocatedFromPool()) continue;
                    this.m_sess.getNFSServer().getPacketPool().releasePacket(rpcPkt.getAssociatedPacket());
                }
            }
            if (!pktError && pktCount < 4) {
                this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                this.m_selectionKey.selector().wakeup();
            }
            if (this.m_sess.hasDebug(NFSSrvSession.Dbg.THREADPOOL) && pktCount > 1) {
                Debug.println("Processed " + pktCount + " packets for addr=" + this.m_sess.getRemoteAddress().getHostAddress() + " in one thread run (max=" + 4 + ")");
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NIO NFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("]");
        return str.toString();
    }
}

