/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.nfs.nio.RpcChannelPacketHandler;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.util.DataPacker;
import org.filesys.util.MemorySize;

public class TcpRpcChannelPacketHandler
extends RpcChannelPacketHandler {
    private byte[] m_fragBuf = new byte[4];

    public TcpRpcChannelPacketHandler(SocketChannel sockChannel, RpcPacketPool packetPool, ThreadRequestPool threadPool) throws IOException {
        super(sockChannel, packetPool, threadPool);
    }

    @Override
    public final RpcPacket receiveRpc() throws IOException {
        int rxLen = 0;
        int totLen = 0;
        int rxOffset = 4;
        int fragLen = 0;
        boolean lastFrag = false;
        RpcPacket rpcPkt = null;
        while (!lastFrag) {
            rxLen = this.readBytes(this.m_fragBuf, 0, 4);
            if (rxLen == 0) {
                return null;
            }
            if (rxLen == -1) {
                throw new IOException("Socket closed by client (read header)");
            }
            fragLen = DataPacker.getInt(this.m_fragBuf, 0);
            if ((fragLen & Integer.MIN_VALUE) != 0) {
                lastFrag = true;
                fragLen &= Integer.MAX_VALUE;
            }
            if (rpcPkt == null) {
                int allocLen = fragLen + 4;
                if (!lastFrag) {
                    allocLen *= 2;
                }
                try {
                    rpcPkt = this.getPacketPool().allocatePacket(allocLen);
                }
                catch (NoPooledMemoryException ex) {
                    return null;
                }
            } else if (fragLen > rpcPkt.getAvailableLength()) {
                int bufLen = rpcPkt.getBuffer().length;
                if (bufLen < this.getPacketPool().getMaximumOverSizedAllocation()) {
                    if ((bufLen *= 2) > this.getPacketPool().getMaximumOverSizedAllocation()) {
                        bufLen = this.getPacketPool().getMaximumOverSizedAllocation();
                    }
                    RpcPacket newPkt = this.getPacketPool().allocatePacket(bufLen);
                    System.arraycopy(rpcPkt.getBuffer(), 0, newPkt.getBuffer(), 0, rpcPkt.getLength());
                    RpcPacket oldPkt = rpcPkt;
                    rpcPkt = newPkt;
                    this.getPacketPool().releasePacket(oldPkt);
                } else {
                    throw new IOException("RPC buffer size has reached maximum size (" + MemorySize.asScaledString(this.getPacketPool().getMaximumOverSizedAllocation()) + ")");
                }
            }
            while (fragLen > 0) {
                rxLen = this.readBytes(rpcPkt.getBuffer(), rxOffset, fragLen);
                if (rxLen == -1) {
                    throw new IOException("Socket closed by client (read fragment)");
                }
                totLen += rxLen;
                fragLen -= rxLen;
                rxOffset += rxLen;
            }
        }
        return rpcPkt;
    }

    @Override
    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(rpc.getBuffer(), 0, rpc.getTxLength());
        while (buf.hasRemaining()) {
            this.getChannel().write(buf);
        }
    }

    protected int readBytes(byte[] pkt, int offset, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(pkt, offset, len);
        return this.getChannel().read(buf);
    }
}

