/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.sample;

import java.util.Enumeration;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.InvalidUserException;
import org.filesys.server.auth.UserAccount;
import org.filesys.server.config.ConfigurationListener;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.SecurityConfigSection;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.ShareMapper;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskSharedDevice;
import org.filesys.server.filesys.FilesystemsConfigSection;
import org.filesys.smb.server.disk.JavaNIODiskDriver;
import org.springframework.extensions.config.ConfigElement;

public class HomeShareMapper
implements ShareMapper,
ConfigurationListener {
    public static final String HOME_DIRECTORY_SHARE = "HOME";
    private ServerConfiguration m_config;
    private SecurityConfigSection m_securityConfig;
    private FilesystemsConfigSection m_filesysConfig;
    private boolean m_debug;

    @Override
    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        this.m_securityConfig = (SecurityConfigSection)this.m_config.getConfigSection("Security");
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        if (this.m_filesysConfig == null) {
            this.m_config.addListener(this);
        }
        if (params.getChild("debug") != null) {
            this.m_debug = true;
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SharedDevice findShare(String host, String name, ShareType typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDevice share = null;
        if ((typ == ShareType.DISK || typ == ShareType.UNKNOWN) && name.compareTo(HOME_DIRECTORY_SHARE) == 0 && sess.getClientInformation() != null) {
            UserAccount acc;
            ClientInfo client = sess.getClientInformation();
            if (this.hasDebug()) {
                Debug.println("Map share " + name + ", type=" + ShareType.TypeAsString(typ) + ", client=" + client);
            }
            if ((acc = this.m_securityConfig.getUserAccounts().findUser(client.getUserName())) == null) throw new InvalidUserException("No home directory");
            if (!acc.hasHomeDirectory()) throw new InvalidUserException("No home directory");
            if (sess.hasDynamicShares()) {
                share = sess.getDynamicShareList().findShare(name, typ, false);
                if (this.hasDebug() && share != null) {
                    Debug.println("  Reusing existing dynamic share for " + name);
                }
            }
            if (share == null && create) {
                JavaNIODiskDriver diskDrv = new JavaNIODiskDriver();
                DiskDeviceContext diskCtx = new DiskDeviceContext(acc.getHomeDirectory());
                DiskSharedDevice diskShare = new DiskSharedDevice(HOME_DIRECTORY_SHARE, diskDrv, diskCtx, 8);
                sess.addDynamicShare(diskShare);
                share = diskShare;
                if (this.hasDebug()) {
                    Debug.println("  Mapped share " + name + " to " + acc.getHomeDirectory());
                }
            }
        } else {
            share = this.m_filesysConfig.getShares().findShare(name, typ, false);
            if (share == null) {
                share = this.m_filesysConfig.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    @Override
    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = enm.nextElement();
            shr.getContext().CloseContext();
            if (!this.hasDebug()) continue;
            Debug.println("Deleted dynamic share " + shr);
        }
    }

    @Override
    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (this.m_filesysConfig == null) {
            return null;
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    @Override
    public void closeMapper() {
    }

    @Override
    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        if (id == 0x10000001) {
            if (newVal instanceof FilesystemsConfigSection) {
                this.m_filesysConfig = (FilesystemsConfigSection)newVal;
            }
            return 1;
        }
        return 0;
    }
}

