/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import org.filesys.server.auth.ntlm.NTLM;

public class SecurityBlob {
    private byte[] m_secBlob;
    private int m_secOffset;
    private int m_secLen;
    private SecurityBlobType m_secType;
    private boolean m_secUnicode;
    private byte[] m_respBlob;

    public SecurityBlob(SecurityBlobType secType, byte[] secBuf, boolean unicode) {
        this.m_secType = secType;
        this.m_secUnicode = unicode;
        this.m_secBlob = secBuf;
        this.m_secOffset = 0;
        this.m_secLen = this.m_secBlob.length;
    }

    public SecurityBlob(SecurityBlobType secType, byte[] secBuf, int offset, int len, boolean unicode) {
        this.m_secType = secType;
        this.m_secUnicode = unicode;
        this.m_secBlob = secBuf;
        this.m_secOffset = offset;
        this.m_secLen = len;
    }

    public final SecurityBlobType isType() {
        return this.m_secType;
    }

    public final boolean isNTLMSSP() {
        return this.isType() == SecurityBlobType.NTLMSSP;
    }

    public final boolean isSPNEGO() {
        return this.isType() == SecurityBlobType.SPNEGO;
    }

    public final boolean isUnicode() {
        return this.m_secUnicode;
    }

    public final byte[] getSecurityBlob() {
        return this.m_secBlob;
    }

    public final int getSecurityOffset() {
        return this.m_secOffset;
    }

    public final int getSecurityLength() {
        return this.m_secLen;
    }

    public final boolean hasResponseBlob() {
        return this.m_respBlob != null;
    }

    public final byte[] getResponseBlob() {
        return this.m_respBlob;
    }

    public final int getResponseLength() {
        return this.m_respBlob != null ? this.m_respBlob.length : 0;
    }

    public final void setResponseBlob(byte[] respBlob) {
        this.m_respBlob = respBlob;
    }

    public static final boolean checkForNTLMSSP(byte[] secBuf, int offset) {
        for (int idx = 0; idx < NTLM.Signature.length; ++idx) {
            if (secBuf[idx + offset] == NTLM.Signature[idx]) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.isType().name());
        str.append(" secBlob=[offset=");
        str.append(this.getSecurityOffset());
        str.append(",len=");
        str.append(this.getSecurityLength());
        str.append("]");
        if (this.isUnicode()) {
            str.append(" Unicode");
        }
        str.append(", respBlob=");
        if (this.hasResponseBlob()) {
            str.append(this.getResponseBlob().length);
            str.append("bytes");
        } else {
            str.append("null");
        }
        str.append("]");
        return str.toString();
    }

    public static enum SecurityBlobType {
        NTLMSSP,
        SPNEGO;

    }
}

