/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.auth.acl.ACLParseException;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlParser;
import org.filesys.server.auth.acl.UserAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class UserAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "user";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("name");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("User name not specified");
        }
        String userName = val.trim();
        if (userName.length() == 0) {
            throw new ACLParseException("User name not valid");
        }
        return new UserAccessControl(userName, this.getType(), access);
    }
}

