/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.kerberos;

import java.io.IOException;
import org.filesys.server.auth.asn.DERApplicationSpecific;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DERInteger;
import org.filesys.server.auth.asn.DERObject;
import org.filesys.server.auth.asn.DEROctetString;
import org.filesys.server.auth.asn.DERSequence;

public class KerberosApRep {
    private int m_encType;
    private byte[] m_encData;
    private int m_encKvno = -1;

    public KerberosApRep() {
    }

    public KerberosApRep(byte[] blob) throws IOException {
        this.parseApRep(blob);
    }

    public final int getEncryptionType() {
        return this.m_encType;
    }

    public final byte[] getEncryptedPart() {
        return this.m_encData;
    }

    public final int getKeyVersion() {
        return this.m_encKvno;
    }

    public final void setEncryptedPart(int encType, byte[] encData, int encVno) {
        this.m_encType = encType;
        this.m_encData = encData;
        this.m_encKvno = encVno;
    }

    private final void parseApRep(byte[] blob) throws IOException {
        DERBuffer derBuf = new DERBuffer(blob);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            block10: for (int idx = 0; idx < derSeq.numberOfObjects(); ++idx) {
                derObj = derSeq.getObjectAt(idx);
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        DERInteger derInt;
                        if (!(derObj instanceof DERInteger) || (derInt = (DERInteger)derObj).getValue() == 5L) continue block10;
                        throw new IOException("Unexpected PVNO value in AP-REP");
                    }
                    case 1: {
                        DERInteger derInt;
                        if (!(derObj instanceof DERInteger) || (derInt = (DERInteger)derObj).getValue() == 15L) continue block10;
                        throw new IOException("Unexpected msg-type value in AP-REP");
                    }
                    case 2: {
                        if (!(derObj instanceof DERSequence)) continue block10;
                        DERSequence derAuthSeq = (DERSequence)derObj;
                        block11: for (int i = 0; i < derAuthSeq.numberOfObjects(); ++i) {
                            derObj = derAuthSeq.getObjectAt(i);
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) continue block11;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_encType = derInt.intValue();
                                    continue block11;
                                }
                                case 1: {
                                    if (!(derObj instanceof DERInteger)) continue block11;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_encKvno = derInt.intValue();
                                    continue block11;
                                }
                                case 2: {
                                    if (!(derObj instanceof DEROctetString)) continue block11;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_encData = derOct.getValue();
                                }
                            }
                        }
                        continue block10;
                    }
                }
            }
        }
    }

    public final void parseResponseToken(byte[] respToken) throws IOException {
        DERBuffer derBuf = new DERBuffer(respToken);
        byte[] aprepBlob = null;
        byte[] appByts = derBuf.unpackApplicationSpecificBytes();
        if (appByts != null) {
            DERBuffer appBuf = new DERBuffer(appByts);
            DERObject derObj = appBuf.unpackObject();
            appBuf.unpackByte();
            appBuf.unpackByte();
            derObj = appBuf.unpackObject();
            if (derObj instanceof DERApplicationSpecific) {
                DERApplicationSpecific derApp = (DERApplicationSpecific)derObj;
                aprepBlob = derApp.getValue();
            }
        }
        if (aprepBlob == null) {
            throw new IOException("AP-REP blob not found in responseToken");
        }
        this.parseApRep(aprepBlob);
    }

    public final byte[] encodeApRep() throws IOException {
        DERSequence derList = new DERSequence();
        DERObject derObj = new DERInteger(5);
        derObj.setTagNo(0);
        derList.addObject(derObj);
        derObj = new DERInteger(15);
        derObj.setTagNo(1);
        derList.addObject(derObj);
        DERSequence aprepSeq = new DERSequence(2);
        derObj = new DERInteger(this.m_encType);
        derObj.setTagNo(0);
        aprepSeq.addObject(derObj);
        if (this.m_encKvno != -1) {
            derObj = new DERInteger(this.m_encKvno);
            derObj.setTagNo(1);
            aprepSeq.addObject(derObj);
        }
        derObj = new DEROctetString(this.m_encData);
        derObj.setTagNo(2);
        aprepSeq.addObject(derObj);
        derList.addObject(aprepSeq);
        DERBuffer derBuf = new DERBuffer();
        derBuf.packApplicationSpecific(15, derList);
        return derBuf.getBytes();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[AP-REP EncPart=Type=");
        str.append(this.getEncryptionType());
        str.append(",Kvno=");
        str.append(this.getKeyVersion());
        str.append(",Len=");
        str.append(this.m_encData != null ? this.m_encData.length : 0);
        str.append("]");
        return str.toString();
    }
}

