/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.ntlm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.filesys.server.auth.ntlm.FlagsTargetInfo;
import org.filesys.server.auth.ntlm.NTLMMessage;
import org.filesys.server.auth.ntlm.StringTargetInfo;
import org.filesys.server.auth.ntlm.TargetInfo;
import org.filesys.server.auth.ntlm.TimestampTargetInfo;
import org.filesys.smb.NTTime;
import org.filesys.util.DataBuffer;
import org.filesys.util.HexDump;

public class Type2NTLMMessage
extends NTLMMessage
implements Serializable {
    public static final int MinimalMessageLength = 32;
    public static final int OffsetTarget = 12;
    public static final int OffsetFlags = 20;
    public static final int OffsetChallenge = 24;
    public static final int OffsetContext = 32;
    public static final int OffsetTargetInfo = 40;
    public static final int OffsetOSVersionInfo = 48;

    public Type2NTLMMessage() {
    }

    public Type2NTLMMessage(byte[] buf) {
        super(buf, 0, buf.length);
    }

    public Type2NTLMMessage(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    @Override
    public int getFlags() {
        return this.getIntValue(20);
    }

    public final boolean hasTarget() {
        return this.hasFlag(4);
    }

    public final String getTarget() {
        return this.getStringValue(12, this.hasFlag(1));
    }

    public final byte[] getChallenge() {
        return this.getRawBytes(24, 8);
    }

    public final boolean hasContext() {
        return this.hasFlag(16384);
    }

    public final int[] getContext() {
        if (!this.hasContext()) {
            return null;
        }
        int[] ctx = new int[]{this.getIntValue(32), this.getIntValue(36)};
        return ctx;
    }

    public final boolean hasTargetInformation() {
        return this.hasFlag(0x800000);
    }

    public final List getTargetInformation() {
        if (!this.hasTargetInformation()) {
            return null;
        }
        int tLen = this.getStringLength(40);
        int tOff = this.getStringOffset(40);
        ArrayList<TimestampTargetInfo> tList = new ArrayList<TimestampTargetInfo>();
        if (tLen == 0) {
            return tList;
        }
        DataBuffer tBuf = new DataBuffer(this.getBuffer(), tOff, tLen);
        boolean endOfList = false;
        while (!endOfList) {
            TargetInfo.Type tTyp = TargetInfo.Type.fromInt(tBuf.getShort());
            tLen = tBuf.getShort();
            if (tTyp == TargetInfo.Type.END_OF_LIST) {
                endOfList = true;
                continue;
            }
            TargetInfo tInfo = null;
            switch (tTyp) {
                case SERVER: 
                case DOMAIN: 
                case FULL_DNS: 
                case DNS_DOMAIN: 
                case DNS_TREE: 
                case SPN: {
                    String sVal = tBuf.getString(tLen / 2, true);
                    tInfo = new StringTargetInfo(tTyp, sVal);
                    break;
                }
                case TIMESTAMP: {
                    long lVal = tBuf.getLong();
                    tInfo = new TimestampTargetInfo(lVal);
                    break;
                }
                case FLAGS: {
                    int iVal = tBuf.getInt();
                    tInfo = new FlagsTargetInfo(iVal);
                }
            }
            if (tInfo == null) continue;
            tList.add((TimestampTargetInfo)tInfo);
        }
        return tList;
    }

    public final void buildType2(int flags, String target, byte[] challenge, int[] ctx, List tList) {
        this.initializeHeader(NTLMMessage.Type.Challenge, flags);
        boolean isUni = this.hasFlag(1);
        int strOff = 40;
        int targOff = 40;
        if ((flags & 0x2000000) != 0) {
            strOff = 48;
        }
        if (tList != null) {
            strOff += 8;
        }
        strOff = this.setStringValue(12, target, strOff, isUni);
        if (challenge != null) {
            this.setRawBytes(24, challenge);
        } else {
            this.zeroBytes(24, 8);
        }
        if (ctx != null) {
            this.setRawInts(32, ctx);
        } else {
            this.zeroBytes(32, 8);
        }
        this.setByteValue(48, 6);
        this.setByteValue(49, 1);
        this.setShortValue(50, 0);
        this.setByteValue(55, 15);
        if (tList != null) {
            this.setIntValue(targOff, 0);
            this.setIntValue(targOff + 4, strOff);
            int startOff = strOff;
            for (int i = 0; i < tList.size(); ++i) {
                TargetInfo tInfo = (TargetInfo)tList.get(i);
                this.setShortValue(strOff, tInfo.isType().intValue());
                if (tInfo instanceof StringTargetInfo) {
                    StringTargetInfo strInfo = (StringTargetInfo)tInfo;
                    int tLen = strInfo.getValue().length();
                    if (isUni) {
                        tLen *= 2;
                    }
                    this.setShortValue(strOff + 2, tLen);
                    strOff = this.setRawString(strOff + 4, strInfo.getValue(), isUni);
                    continue;
                }
                if (!(tInfo instanceof TimestampTargetInfo)) continue;
                TimestampTargetInfo tsInfo = (TimestampTargetInfo)tInfo;
                this.setShortValue(strOff + 2, 8);
                this.setLongValue(strOff + 4, NTTime.toNTTime(tsInfo.getValue()));
                strOff += 12;
            }
            this.zeroBytes(strOff, 4);
            this.setShortValue(targOff, (strOff += 4) - startOff);
            this.setShortValue(targOff + 2, strOff - startOff);
        }
        this.setLength(strOff);
    }

    @Override
    protected void setFlags(int flags) {
        this.setIntValue(20, flags);
    }

    public final Type2NTLMMessage clone() {
        Type2NTLMMessage newType2 = new Type2NTLMMessage();
        newType2.copyFrom(this.getBuffer(), this.getOffset(), this.getLength());
        return newType2;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Type2:0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append(",Target:");
        str.append(this.getTarget());
        str.append(",Ch:");
        str.append(HexDump.hexString(this.getChallenge()));
        if (this.hasTargetInformation()) {
            List targets = this.getTargetInformation();
            str.append(",TargInf:");
            for (int i = 0; i < targets.size(); ++i) {
                TargetInfo target = (TargetInfo)targets.get(i);
                str.append(target);
            }
        }
        str.append("]");
        return str.toString();
    }
}

