/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.passthru;

import java.io.IOException;
import org.filesys.netbios.NetBIOSSession;
import org.filesys.netbios.NetworkSession;
import org.filesys.server.auth.passthru.AuthenticateSession;
import org.filesys.smb.SMBException;
import org.filesys.util.DataPacker;

public class SMBPacket {
    public static final int SIGNATURE = 4;
    public static final int COMMAND = 8;
    public static final int ERRORCODE = 9;
    public static final int ERRORCLASS = 9;
    public static final int ERROR = 11;
    public static final int FLAGS = 13;
    public static final int FLAGS2 = 14;
    public static final int PIDHIGH = 16;
    public static final int SID = 22;
    public static final int SEQNO = 24;
    public static final int TID = 28;
    public static final int PID = 30;
    public static final int UID = 32;
    public static final int MID = 34;
    public static final int WORDCNT = 36;
    public static final int ANDXCOMMAND = 37;
    public static final int ANDXRESERVED = 38;
    public static final int PARAMWORDS = 37;
    public static final int TRANS_HEADERLEN = 70;
    public static final int MIN_RXLEN = 32;
    public static final int DEFAULT_BUFSIZE = 4096;
    public static final int FLG_SUBDIALECT = 1;
    public static final int FLG_CASELESS = 8;
    public static final int FLG_CANONICAL = 16;
    public static final int FLG_OPLOCK = 32;
    public static final int FLG_NOTIFY = 64;
    public static final int FLG_RESPONSE = 128;
    public static final int FLG2_LONGFILENAMES = 1;
    public static final int FLG2_EXTENDEDATTRIB = 2;
    public static final int FLG2_SECURITYSIG = 4;
    public static final int FLG2_EXTENDEDSECURITY = 2048;
    public static final int FLG2_READIFEXE = 8192;
    public static final int FLG2_LONGERRORCODE = 16384;
    public static final int FLG2_UNICODE = 32768;
    public static final int SEC_USER = 1;
    public static final int SEC_ENCRYPT = 2;
    public static final int RAW_READ = 1;
    public static final int RAW_WRITE = 2;
    private byte[] m_smbbuf;
    private int m_pkttype;
    protected int m_pos;
    protected int m_endpos;
    protected long m_lastTxTime;

    public SMBPacket() {
        this.m_smbbuf = new byte[4096];
        this.InitializeBuffer();
    }

    public SMBPacket(byte[] buf) {
        this.m_smbbuf = buf;
    }

    public SMBPacket(int siz) {
        this.m_smbbuf = new byte[siz];
        this.InitializeBuffer();
    }

    public final void checkForError() throws SMBException {
        if (!this.isValidResponse()) {
            if (this.isLongErrorCode()) {
                throw new SMBException(6, this.getLongErrorCode());
            }
            throw new SMBException(this.getErrorClass(), this.getErrorCode());
        }
    }

    public final void clearBytes() {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(0, this.m_smbbuf, offset);
    }

    public final boolean equalsError(int errClass, int errCode) {
        return this.getErrorClass() == errClass && this.getErrorCode() == errCode;
    }

    protected final synchronized void ExchangeLowLevelSMB(NetworkSession sess, SMBPacket rxPkt, boolean throwerr) throws IOException, SMBException {
        if (this.getMultiplexId() == 0) {
            this.setMultiplexId(1);
        }
        sess.Send(this.m_smbbuf, this.getLength());
        if (sess.Receive(rxPkt.getBuffer()) >= 32 && rxPkt.getCommand() == this.m_pkttype) {
            if (throwerr) {
                this.checkForError();
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final synchronized void ExchangeSMB(AuthenticateSession sess, SMBPacket rxPkt) throws SMBException, IOException {
        this.ExchangeSMB(sess, rxPkt, false);
    }

    public final synchronized void ExchangeSMB(AuthenticateSession sess, SMBPacket rxPkt, boolean throwerr) throws SMBException, IOException {
        this.setProcessId(sess.getProcessId());
        this.setUserId(sess.getUserId());
        if (this.getMultiplexId() == 0) {
            this.setMultiplexId(1);
        }
        NetworkSession netSess = sess.getSession();
        netSess.Send(this.m_smbbuf, this.getLength());
        boolean rxValid = false;
        while (!rxValid) {
            if (netSess.Receive(rxPkt.getBuffer()) < 32 || rxPkt.getCommand() != this.m_pkttype) continue;
            if (throwerr) {
                this.checkForError();
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final int getAndXCommand() {
        return this.m_smbbuf[37] & 0xFF;
    }

    public final byte[] getBuffer() {
        return this.m_smbbuf;
    }

    public final int getBufferLength() {
        return this.m_smbbuf.length - 4;
    }

    public final int getAvailableLength() {
        return this.m_smbbuf.length - DataPacker.longwordAlign(this.getByteOffset());
    }

    public final int getByteCount() {
        int pos = 37 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this.m_smbbuf, pos);
    }

    public final int getByteOffset() {
        int pCnt = this.getParameterCount();
        int pos = 36 + 2 * pCnt + 3;
        return pos;
    }

    public final int getCommand() {
        return this.m_smbbuf[8] & 0xFF;
    }

    public final boolean hasLongErrorCode() {
        return (this.getFlags2() & 0x4000) != 0;
    }

    public final int isType() {
        return this.m_pkttype;
    }

    public final boolean isUnicode() {
        return (this.getFlags2() & 0x8000) != 0;
    }

    public final boolean isCaseless() {
        return (this.getFlags() & 8) != 0;
    }

    public final boolean isLongFileNames() {
        return (this.getFlags2() & 1) != 0;
    }

    public final boolean isLongErrorCode() {
        return (this.getFlags2() & 0x4000) != 0;
    }

    public final int getErrorClass() {
        return this.m_smbbuf[9] & 0xFF;
    }

    public final int getErrorCode() {
        return this.m_smbbuf[11] & 0xFF;
    }

    public final int getFlags() {
        return this.m_smbbuf[13] & 0xFF;
    }

    public final int getFlags2() {
        return DataPacker.getIntelShort(this.m_smbbuf, 14);
    }

    public final int getLength() {
        return this.getByteOffset() + this.getByteCount() - 4;
    }

    public final int getLongErrorCode() {
        return DataPacker.getIntelInt(this.m_smbbuf, 9);
    }

    public final int getMultiplexId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 34);
    }

    public final int getParameter(int idx) throws IndexOutOfBoundsException {
        if (idx > this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int pos = 36 + 2 * idx + 1;
        return DataPacker.getIntelShort(this.m_smbbuf, pos) & 0xFFFF;
    }

    public final int getParameterLong(int idx) {
        int pos = 36 + 2 * idx + 1;
        return DataPacker.getIntelInt(this.m_smbbuf, pos);
    }

    public final int getParameterCount() {
        return this.m_smbbuf[36];
    }

    public final int getProcessId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 30);
    }

    public final int getTreeId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 28);
    }

    public final int getUserId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 32);
    }

    public final long getLastPacketSendTime() {
        return this.m_lastTxTime;
    }

    private final void InitializeBuffer() {
        this.m_smbbuf[4] = -1;
        this.m_smbbuf[5] = 83;
        this.m_smbbuf[6] = 77;
        this.m_smbbuf[7] = 66;
    }

    public final boolean isResponse() {
        int resp = this.getFlags();
        return (resp & 0x80) != 0;
    }

    public final boolean isValidResponse() {
        return this.isResponse() && this.getCommand() == this.m_pkttype && ((this.getFlags2() & 0x4000) == 0 ? this.getErrorCode() == 0 : this.getLongErrorCode() == 0);
    }

    public final void packByte(byte val) {
        this.m_smbbuf[this.m_pos++] = val;
    }

    public final void packByte(int val) {
        this.m_smbbuf[this.m_pos++] = (byte)val;
    }

    public final void packBytes(byte[] byts, int len) {
        System.arraycopy(byts, 0, this.m_smbbuf, this.m_pos, len);
        this.m_pos += len;
    }

    public final void packString(String str, boolean uni) {
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            DataPacker.putUnicodeString(str, this.m_smbbuf, this.m_pos, true);
            this.m_pos += str.length() * 2 + 2;
        } else {
            DataPacker.putString(str, this.m_smbbuf, this.m_pos, true);
            this.m_pos += str.length() + 1;
        }
    }

    public final void packWord(int val) {
        DataPacker.putIntelShort(val, this.m_smbbuf, this.m_pos);
        this.m_pos += 2;
    }

    public final void packInt(int val) {
        DataPacker.putIntelInt(val, this.m_smbbuf, this.m_pos);
        this.m_pos += 4;
    }

    public final void packLong(long val) {
        DataPacker.putIntelLong(val, this.m_smbbuf, this.m_pos);
        this.m_pos += 8;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final void setPosition(int pos) {
        this.m_pos = pos;
    }

    public final int unpackByte() {
        return this.m_smbbuf[this.m_pos++];
    }

    public final byte[] unpackBytes(int len) {
        if (len <= 0) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(this.m_smbbuf, this.m_pos, buf, 0, len);
        this.m_pos += len;
        return buf;
    }

    public final int unpackWord() {
        int val = DataPacker.getIntelShort(this.m_smbbuf, this.m_pos);
        this.m_pos += 2;
        return val;
    }

    public final int unpackInt() {
        int val = DataPacker.getIntelInt(this.m_smbbuf, this.m_pos);
        this.m_pos += 4;
        return val;
    }

    public final long unpackLong() {
        long val = DataPacker.getIntelLong(this.m_smbbuf, this.m_pos);
        this.m_pos += 8;
        return val;
    }

    public final String unpackString(boolean uni) {
        String ret = null;
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            ret = DataPacker.getUnicodeString(this.m_smbbuf, this.m_pos, 255);
            if (ret != null) {
                this.m_pos += ret.length() * 2 + 2;
            }
        } else {
            ret = DataPacker.getString(this.m_smbbuf, this.m_pos, 255);
            if (ret != null) {
                this.m_pos += ret.length() + 1;
            }
        }
        return ret;
    }

    public final String unpackString(int len, boolean uni) {
        String ret = null;
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            ret = DataPacker.getUnicodeString(this.m_smbbuf, this.m_pos, len);
            if (ret != null) {
                this.m_pos += ret.length() * 2;
            }
        } else {
            ret = DataPacker.getString(this.m_smbbuf, this.m_pos, len);
            if (ret != null) {
                this.m_pos += ret.length();
            }
        }
        return ret;
    }

    public final boolean hasMoreData() {
        return this.m_pos < this.m_endpos;
    }

    private final void ReceiveSMB(NetBIOSSession sess) throws IOException {
        if (sess.Receive(this.m_smbbuf) >= 32) {
            return;
        }
        throw new IOException("Short NetBIOS receive");
    }

    protected final void ReceiveSMB(AuthenticateSession sess) throws IOException, SMBException {
        this.ReceiveSMB(sess, true);
    }

    protected final void ReceiveSMB(AuthenticateSession sess, boolean throwErr) throws IOException, SMBException {
        NetworkSession netSess = sess.getSession();
        boolean rxValid = false;
        while (!rxValid) {
            if (netSess.Receive(this.getBuffer()) >= 32) {
                if (this.getCommand() == this.m_pkttype) {
                    if (throwErr) {
                        this.checkForError();
                    }
                    return;
                }
                sess.processAsynchResponse(this);
                continue;
            }
            throw new IOException("Short NetBIOS receive");
        }
    }

    protected final void ReceiveAsynchSMB(AuthenticateSession sess, int waitTime) throws IOException, SMBException {
        NetworkSession netSess = sess.getSession();
        netSess.setTimeout(waitTime);
        if (netSess.Receive(this.getBuffer()) < 32) {
            throw new IOException("Short NetBIOS receive");
        }
        sess.processAsynchResponse(this);
    }

    protected final void SendSMB(AuthenticateSession sess) throws IOException {
        this.m_lastTxTime = System.currentTimeMillis();
        sess.getSession().Send(this.m_smbbuf, this.getLength());
    }

    public final void setAndXCommand(int cmd) {
        this.m_smbbuf[37] = (byte)cmd;
        this.m_smbbuf[38] = 0;
        if (cmd == 255) {
            this.setParameter(1, 0);
        }
    }

    public final void setByteCount(int cnt) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(cnt, this.m_smbbuf, offset);
    }

    public final void setByteCount() {
        int offset = this.getByteOffset() - 2;
        int len = this.m_pos - this.getByteOffset();
        DataPacker.putIntelShort(len, this.m_smbbuf, offset);
    }

    public final void setBytes(byte[] byts) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(byts.length, this.m_smbbuf, offset);
        offset += 2;
        int idx = 0;
        while (idx < byts.length) {
            this.m_smbbuf[offset + idx] = byts[idx++];
        }
    }

    public final void setCommand(int cmd) {
        this.m_pkttype = cmd;
        this.m_smbbuf[8] = (byte)cmd;
    }

    public final void setErrorClass(int cl) {
        this.m_smbbuf[9] = (byte)(cl & 0xFF);
    }

    public final void setErrorCode(int sts) {
        this.m_smbbuf[11] = (byte)(sts & 0xFF);
    }

    public final void setFlags(int flg) {
        this.m_smbbuf[13] = (byte)flg;
    }

    public final void setFlags2(int flg) {
        DataPacker.putIntelShort(flg, this.m_smbbuf, 14);
    }

    public final void setMultiplexId(int mid) {
        DataPacker.putIntelShort(mid, this.m_smbbuf, 34);
    }

    public final void setParameter(int idx, int val) {
        int pos = 36 + 2 * idx + 1;
        DataPacker.putIntelShort(val, this.m_smbbuf, pos);
    }

    public final void setParameterLong(int idx, int val) {
        int pos = 36 + 2 * idx + 1;
        DataPacker.putIntelInt(val, this.m_smbbuf, pos);
    }

    public final void setParameterCount(int cnt) {
        this.m_smbbuf[36] = (byte)cnt;
    }

    public final void setProcessId(int pid) {
        DataPacker.putIntelShort(pid, this.m_smbbuf, 30);
    }

    public final void setSeqNo(int seq) {
        DataPacker.putIntelShort(seq, this.m_smbbuf, 24);
    }

    public final void setSID(int sid) {
        DataPacker.putIntelShort(sid, this.m_smbbuf, 22);
    }

    public final void setTreeId(int tid) {
        DataPacker.putIntelShort(tid, this.m_smbbuf, 28);
    }

    public final void setUserId(int uid) {
        DataPacker.putIntelShort(uid, this.m_smbbuf, 32);
    }

    public final void alignBytePointer() {
        this.m_pos = DataPacker.longwordAlign(this.m_pos);
    }

    public final void resetBytePointer() {
        this.m_pos = this.getByteOffset();
        this.m_endpos = this.m_pos + this.getByteCount();
    }

    public final void resetBytePointerAlign() {
        this.m_pos = DataPacker.longwordAlign(this.getByteOffset());
        this.m_endpos = this.m_pos + this.getByteCount();
    }

    public final void resetParameterPointer() {
        this.m_pos = 37;
    }

    public final void setBytePointer(int off, int len) {
        this.m_pos = off;
        this.m_endpos = this.m_pos + len;
    }

    public final void skipBytes(int cnt) {
        this.m_pos += cnt;
    }

    protected final String getFlagsAsString() {
        int flags = this.getFlags();
        if (flags == 0) {
            return "<None>";
        }
        StringBuffer str = new StringBuffer();
        if ((flags & 1) != 0) {
            str.append("SubDialect,");
        }
        if ((flags & 8) != 0) {
            str.append("Caseless,");
        }
        if ((flags & 0x10) != 0) {
            str.append("Canonical,");
        }
        if ((flags & 0x20) != 0) {
            str.append("Oplock,");
        }
        if ((flags & 0x40) != 0) {
            str.append("Notify,");
        }
        if ((flags & 0x80) != 0) {
            str.append("Response,");
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    protected final String getFlags2AsString() {
        int flags2 = this.getFlags2();
        if (flags2 == 0) {
            return "<None>";
        }
        StringBuffer str = new StringBuffer();
        if ((flags2 & 1) != 0) {
            str.append("LongFilenames,");
        }
        if ((flags2 & 2) != 0) {
            str.append("ExtAttributes,");
        }
        if ((flags2 & 0x2000) != 0) {
            str.append("ReadIfEXE,");
        }
        if ((flags2 & 0x4000) != 0) {
            str.append("LongErrorCode,");
        }
        if ((flags2 & 0x8000) != 0) {
            str.append("Unicode,");
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }
}

