/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.HashMap;
import java.util.Map;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SearchMap;
import org.filesys.server.filesys.TooManySearchesException;

public class HashedSearchMap
extends SearchMap {
    private Map<Integer, SearchContext> m_search;

    public HashedSearchMap() {
    }

    public HashedSearchMap(int maxSearches) {
        this.setMaximumNumberOfSearches(maxSearches >= 8 ? maxSearches : 8);
    }

    @Override
    public int allocateSearchSlot() throws TooManySearchesException {
        return -1;
    }

    @Override
    public synchronized boolean allocateSearchSlotWithId(int searchId) throws TooManySearchesException {
        if (this.m_search == null) {
            this.m_search = new HashMap<Integer, SearchContext>(8);
        } else {
            if (this.m_search.size() >= this.maximumNumberOfSearches()) {
                return false;
            }
            if (this.m_search.containsKey(searchId)) {
                return false;
            }
        }
        this.m_search.put(searchId, SearchSlotMarker);
        return true;
    }

    @Override
    public synchronized SearchContext deallocateSearchSlot(int ctxId) {
        if (this.m_search == null) {
            return null;
        }
        SearchContext searchCtx = this.m_search.remove(ctxId);
        if (searchCtx != null && !searchCtx.isClosed()) {
            searchCtx.closeSearch();
            searchCtx.setClosed();
        }
        return searchCtx;
    }

    @Override
    public synchronized SearchContext findSearchContext(int srchId) {
        if (this.m_search == null) {
            return null;
        }
        return this.m_search.get(srchId);
    }

    @Override
    public synchronized void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search == null) {
            return;
        }
        this.m_search.put(slot, srch);
    }

    @Override
    public synchronized int numberOfSearches() {
        if (this.m_search == null) {
            return 0;
        }
        return this.m_search.size();
    }

    @Override
    public synchronized void closeAllSearches() {
        for (Integer searchKey : this.m_search.keySet()) {
            SearchContext searchCtx = this.m_search.get(searchKey);
            if (searchCtx == null || searchCtx.isClosed()) continue;
            searchCtx.closeSearch();
            searchCtx.isClosed();
        }
        this.m_search.clear();
    }
}

