/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import org.filesys.debug.Debug;
import org.filesys.server.RequestPostProcessor;
import org.filesys.server.filesys.ExistingOpLockException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileStateCache;
import org.filesys.server.filesys.cache.hazelcast.HazelCastClusterFileStateCache;
import org.filesys.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.filesys.server.filesys.cache.hazelcast.StateUpdateMessage;
import org.filesys.server.filesys.cache.hazelcast.StateUpdatePostProcessor;
import org.filesys.server.locking.OpLockDetails;

public class HazelCastClusterFileState
extends ClusterFileState {
    private static final long serialVersionUID = 1L;
    private transient long m_nearCacheTime;
    private transient long m_nearLastAccess;
    private transient long m_nearUpdateTime;
    private transient long m_nearCacheHits;
    private transient boolean m_nearCacheValid;

    public HazelCastClusterFileState() {
    }

    public HazelCastClusterFileState(String fname, boolean caseSensitive) {
        super(fname, caseSensitive);
    }

    @Override
    public boolean isCopyState() {
        return true;
    }

    public final long getNearCacheTime() {
        return this.m_nearCacheTime;
    }

    public final long getNearCacheHitCount() {
        return this.m_nearCacheHits;
    }

    public final long getNearCacheLastAccessTime() {
        return this.m_nearLastAccess;
    }

    public final long getNearRemoteUpdateTime() {
        return this.m_nearUpdateTime;
    }

    public final boolean isStateValid() {
        return this.m_nearCacheValid;
    }

    @Override
    public void setStateCache(ClusterFileStateCache stateCache) {
        super.setStateCache(stateCache);
        if (this.hasOpLock() && this.getOpLock() instanceof RemoteOpLockDetails) {
            RemoteOpLockDetails remoteOplock = (RemoteOpLockDetails)this.getOpLock();
            remoteOplock.setStateCache(stateCache);
        }
    }

    @Override
    public synchronized void setOpLock(OpLockDetails oplock) throws ExistingOpLockException {
        super.setOpLock(oplock);
        if (oplock instanceof RemoteOpLockDetails) {
            RemoteOpLockDetails remoteOplock = (RemoteOpLockDetails)this.getOpLock();
            remoteOplock.setStateCache(this.getStateCache());
        }
    }

    @Override
    public void setFileStatus(FileStatus status, FileState.ChangeReason reason) {
        if (this.getFileStatus() != status || reason != FileState.ChangeReason.None) {
            super.setFileStatusInternal(status, reason);
            this.runHighPriorityUpdate(8);
        }
    }

    @Override
    public void setFileSize(long fileSize) {
        if (this.getFileSize() != fileSize) {
            super.setFileSize(fileSize);
            this.queueLowPriorityUpdate(64);
        }
    }

    @Override
    public void setAllocationSize(long allocSize) {
        if (this.getAllocationSize() != allocSize) {
            super.setAllocationSize(allocSize);
            this.queueLowPriorityUpdate(128);
        }
    }

    @Override
    public void updateModifyDateTime(long modTime) {
        if (this.getModifyDateTime() != modTime) {
            super.updateModifyDateTime(modTime);
            this.queueLowPriorityUpdate(32);
        }
    }

    @Override
    public void updateChangeDateTime(long changeTime) {
        if (this.getChangeDateTime() != changeTime) {
            super.updateChangeDateTime(changeTime);
            this.queueLowPriorityUpdate(16);
        }
    }

    @Override
    public void setRetentionExpiryDateTime(long expires) {
        if (this.getRetentionExpiryDateTime() != expires) {
            super.setRetentionExpiryDateTime(expires);
            this.queueLowPriorityUpdate(512);
        }
    }

    public final void setNearCacheTime() {
        this.m_nearCacheTime = System.currentTimeMillis();
        this.setStateValid(true);
    }

    public final void setNearRemoteUpdateTime() {
        this.m_nearUpdateTime = System.currentTimeMillis();
    }

    public final void setNearRemoteUpdateTime(long updateTime) {
        this.m_nearUpdateTime = updateTime;
    }

    public final long incrementNearCacheHitCount() {
        this.m_nearLastAccess = System.currentTimeMillis();
        return ++this.m_nearCacheHits;
    }

    public final void setStateValid(boolean nearValid) {
        this.m_nearCacheValid = nearValid;
    }

    protected final void copyNearCacheDetails(HazelCastClusterFileState hcState) {
        this.m_nearCacheTime = hcState.getNearCacheTime();
        this.m_nearLastAccess = hcState.getNearCacheLastAccessTime();
        this.m_nearCacheHits = hcState.getNearCacheHitCount();
    }

    protected synchronized void queueLowPriorityUpdate(int updateMask) {
        StateUpdatePostProcessor updatePostProc = (StateUpdatePostProcessor)RequestPostProcessor.findPostProcessor(StateUpdatePostProcessor.class);
        if (updatePostProc == null) {
            updatePostProc = new StateUpdatePostProcessor(this.getStateCache(), this, updateMask);
            RequestPostProcessor.queuePostProcessor(updatePostProc);
        } else {
            updatePostProc.addToUpdateMask(updateMask);
        }
    }

    protected void runHighPriorityUpdate(int updateMask) {
        if (this.getStateCache() != null) {
            HazelCastClusterFileStateCache hcStateCache = (HazelCastClusterFileStateCache)this.getStateCache();
            hcStateCache.remoteUpdateState(this, updateMask);
        }
    }

    protected final void updateState(StateUpdateMessage updateMsg) {
        if (updateMsg.hasUpdate(8)) {
            super.setFileStatus(updateMsg.getFileStatus());
            if (this.getFileStatus() == FileStatus.NotExist && this.getOpenCount() > 0) {
                Debug.println("Setting status to NotExist when openCount>0, fid=" + this.getFileId() + ", name=" + this.getPath());
            }
            if (this.getFileStatus() == FileStatus.NotExist) {
                this.setFileId(-1);
                this.removeAllAttributes();
            }
        }
        if (updateMsg.hasUpdate(64)) {
            super.setFileSize(updateMsg.getFileSize());
        }
        if (updateMsg.hasUpdate(128)) {
            super.setAllocationSize(updateMsg.getAllocationSize());
        }
        if (updateMsg.hasUpdate(16)) {
            super.updateChangeDateTime(updateMsg.getChangeDateTime());
        }
        if (updateMsg.hasUpdate(32)) {
            super.updateModifyDateTime(updateMsg.getModificationDateTime());
        }
        if (updateMsg.hasUpdate(512)) {
            super.setRetentionExpiryDateTime(updateMsg.getRetentionDateTime());
        }
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(this.getFileStatus().name());
        str.append(":Opn=");
        str.append(super.getOpenCount());
        if (this.getOpenCount() > 0) {
            str.append("(shr=");
            str.append(this.getSharedAccess().name());
            str.append(",pid=");
            str.append(this.getProcessId());
            str.append(",primary=");
            str.append(this.getPrimaryOwner());
            str.append(")");
        }
        str.append(",Fid=");
        str.append(this.getFileId());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Sts=");
        str.append(this.getDataStatus().name());
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        if (this.hasOpLock()) {
            str.append(",OpLock=");
            str.append(this.getOpLock());
        }
        if (this.getNearCacheTime() != 0L) {
            str.append(" - Near at=");
            str.append(System.currentTimeMillis() - this.getNearCacheTime());
            str.append("ms,");
            if (this.getNearCacheLastAccessTime() > 0L) {
                str.append("acc=");
                str.append(System.currentTimeMillis() - this.getNearCacheLastAccessTime());
                str.append("ms,");
            }
            if (this.getNearRemoteUpdateTime() > 0L) {
                str.append("upd=");
                str.append(System.currentTimeMillis() - this.getNearRemoteUpdateTime());
                str.append("ms,");
            }
            str.append("hits=");
            str.append(this.getNearCacheHitCount());
            if (!this.isStateValid()) {
                str.append(",NotValid");
            }
        }
        str.append("]");
        return str.toString();
    }
}

