/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MessageListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.cluster.ClusterFileLock;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.AddFileByteLockTask;
import org.filesys.server.filesys.cache.hazelcast.AddOpLockTask;
import org.filesys.server.filesys.cache.hazelcast.ChangeOpLockTypeTask;
import org.filesys.server.filesys.cache.hazelcast.CheckFileByteLockTask;
import org.filesys.server.filesys.cache.hazelcast.ClusterMessage;
import org.filesys.server.filesys.cache.hazelcast.FileDataUpdateTask;
import org.filesys.server.filesys.cache.hazelcast.GrantAccessParams;
import org.filesys.server.filesys.cache.hazelcast.GrantFileAccessTask;
import org.filesys.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.filesys.server.filesys.cache.hazelcast.HazelCastClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.HazelCastClusterFileStateCache;
import org.filesys.server.filesys.cache.hazelcast.ReleaseFileAccessTask;
import org.filesys.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.filesys.server.filesys.cache.hazelcast.RemoveFileByteLockTask;
import org.filesys.server.filesys.cache.hazelcast.RemoveOpLockTask;
import org.filesys.server.filesys.cache.hazelcast.RenameStateTask;
import org.filesys.server.filesys.cache.hazelcast.UpdateStateTask;
import org.filesys.smb.OpLockType;

public class HazelCastClusterFileStateCacheV3
extends HazelCastClusterFileStateCache
implements EntryAddedListener<String, HazelCastClusterFileState>,
EntryUpdatedListener<String, HazelCastClusterFileState>,
EntryRemovedListener<String, HazelCastClusterFileState>,
EntryEvictedListener<String, HazelCastClusterFileState>,
MessageListener<ClusterMessage> {
    @Override
    public void startCluster() throws Exception {
        super.startCluster();
        if (this.m_stateCache != null && this.m_clusterTopic != null) {
            this.m_stateCache.addEntryListener((MapListener)this, false);
            this.m_clusterTopic.addMessageListener((MessageListener)this);
            this.getStateCache().clusterRunning();
        }
    }

    @Override
    public boolean executeRenameFileState(String oldPath, String newPath, boolean isDir) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        RenameStateTask callable = new RenameStateTask(this.getClusterName(), oldPath, newPath, isDir, this.hasTaskDebug(), this.hasTaskTiming());
        Future renameStateTask = execService.submitToKeyOwner((Callable)callable, (Object)oldPath);
        return (Boolean)renameStateTask.get();
    }

    @Override
    public boolean executeAddOpLock(String path, RemoteOpLockDetails remoteOpLock) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        AddOpLockTask callable = new AddOpLockTask(this.getClusterName(), path, remoteOpLock, this.hasTaskDebug(), this.hasTaskTiming());
        Future addOpLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (Boolean)addOpLockTask.get();
    }

    @Override
    public void executeClearOpLock(String path) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        RemoveOpLockTask callable = new RemoveOpLockTask(this.getClusterName(), path, this.hasTaskDebug(), this.hasTaskTiming());
        Future removeOpLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        removeOpLockTask.get();
    }

    @Override
    public ClusterFileState executeAddLock(String path, ClusterFileLock lock) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        AddFileByteLockTask callable = new AddFileByteLockTask(this.getClusterName(), path, lock, this.hasDebugLevel(16), this.hasTaskTiming());
        Future addLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (ClusterFileState)addLockTask.get();
    }

    @Override
    public ClusterFileState executeRemoveLock(String path, ClusterFileLock lock) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        RemoveFileByteLockTask callable = new RemoveFileByteLockTask(this.getClusterName(), path, lock, this.hasDebugLevel(16), this.hasTaskTiming());
        Future removeLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (ClusterFileState)removeLockTask.get();
    }

    @Override
    public OpLockType executeChangeOpLockType(String path, OpLockType newTyp) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        ChangeOpLockTypeTask callable = new ChangeOpLockTypeTask(this.getClusterName(), path, newTyp, this.hasTaskDebug(), this.hasTaskTiming());
        Future changeOpLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return OpLockType.fromInt((Integer)changeOpLockTask.get());
    }

    @Override
    public HazelCastAccessToken executeGrantFileAccess(String path, GrantAccessParams params) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        GrantFileAccessTask callable = new GrantFileAccessTask(this.getClusterName(), path, params, this.hasTaskDebug(), this.hasTaskTiming());
        Future grantAccessTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (HazelCastAccessToken)grantAccessTask.get();
    }

    @Override
    public int executeReleaseFileAccess(String path, HazelCastAccessToken token) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        ReleaseFileAccessTask callable = new ReleaseFileAccessTask(this.getClusterName(), path, token, this.m_topicName, this.hasDebugLevel(32), this.hasTaskTiming());
        Future releaseAccessTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (Integer)releaseAccessTask.get();
    }

    @Override
    public boolean executeCheckFileAccess(String path, ClusterFileLock chkLock, boolean writeChk) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        CheckFileByteLockTask callable = new CheckFileByteLockTask(this.getClusterName(), path, chkLock, writeChk, this.hasDebugLevel(32), this.hasTaskTiming());
        Future checkLockTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (Boolean)checkLockTask.get();
    }

    @Override
    public boolean executeRemoteUpdateState(String path, FileStatus fileSts) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        UpdateStateTask callable = new UpdateStateTask(this.getClusterName(), path, fileSts, this.hasDebugLevel(34816), this.hasTaskTiming());
        Future updateStateTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (Boolean)updateStateTask.get();
    }

    @Override
    public boolean executeUpdateFileDataStatus(String path, boolean startUpdate) throws InterruptedException, ExecutionException {
        IExecutorService execService = this.m_hazelCastInstance.getExecutorService("Executor");
        FileDataUpdateTask callable = new FileDataUpdateTask(this.getClusterName(), path, this.getLocalNode(), startUpdate, this.hasDebugLevel(16384), this.hasTaskTiming());
        Future fileDataUpdateTask = execService.submitToKeyOwner((Callable)callable, (Object)path);
        return (Boolean)fileDataUpdateTask.get();
    }
}

