/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.util.ArrayList;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.db.DBException;
import org.filesys.server.filesys.db.DBQueueInterface;
import org.filesys.server.filesys.loader.BackgroundFileLoader;
import org.filesys.server.filesys.loader.CachedFileInfo;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileRequestQueue;
import org.filesys.server.filesys.loader.FileSegment;
import org.filesys.server.filesys.loader.FileSegmentInfo;
import org.filesys.server.filesys.loader.MultipleFileRequest;
import org.filesys.server.filesys.loader.SegmentInfo;
import org.filesys.server.filesys.loader.SingleFileRequest;

public class BackgroundLoadSave {
    public static final int DefaultWorkerThreads = 4;
    public static final int MinimumWorkerThreads = 1;
    public static final int MaximumWorkerThreads = 50;
    public static final int RequestQueueMaxSize = 5000;
    public static final int RequestQueueMinSize = 50;
    public static final int RequestQueueDefaultSize = 200;
    public static final int RequestQueueLowWaterMark = 50;
    public static final int RequeueMinSize = 20;
    public static final long RequeueWaitTime = 500L;
    private static final String DefaultThreadName = "LoadSave_";
    public static final String DBFileSegmentInfo = "DBFileSegmentInfo";
    public static final long SequentialFileExpire = 3000L;
    public static final long RequestProcessedExpire = 3000L;
    public static final long RequestQueuedExpire = 10000L;
    public static final long DefaultTransactionTimeout = 5000L;
    public static final long MinimumTransactionTimeout = 2000L;
    public static final long MaximumTransactionTimeout = 60000L;
    private String m_name;
    private FileRequestQueue m_readQueue;
    private FileRequestQueue m_writeQueue;
    private QueueLoader m_writeLoader;
    private Object m_writeLoaderLock = new Object();
    private QueueLoader m_readLoader;
    private Object m_readLoaderLock = new Object();
    private TransactionQueueLoader m_tranLoader;
    private int m_maxQueueSize;
    private int m_lowQueueSize;
    private ThreadWorker[] m_readThreads;
    private ThreadWorker[] m_writeThreads;
    private int m_readWorkers;
    private int m_writeWorkers;
    private boolean m_debug;
    private DBQueueInterface m_dbQueueInterface;
    private FileStateCache m_stateCache;
    private long m_stateTimeout;
    private BackgroundFileLoader m_fileLoader;

    public BackgroundLoadSave(DBQueueInterface dbQueue, FileStateCache stateCache, BackgroundFileLoader bgLoader) {
        this.m_dbQueueInterface = dbQueue;
        this.m_stateCache = stateCache;
        this.m_fileLoader = bgLoader;
        this.m_readQueue = new FileRequestQueue();
        this.m_writeQueue = new FileRequestQueue();
        this.m_maxQueueSize = 200;
        this.m_lowQueueSize = 50;
        this.setName(DefaultThreadName);
    }

    public BackgroundLoadSave(String name, DBQueueInterface dbQueue, FileStateCache stateCache, BackgroundFileLoader bgLoader) {
        this.m_dbQueueInterface = dbQueue;
        this.m_stateCache = stateCache;
        this.m_fileLoader = bgLoader;
        this.m_readQueue = new FileRequestQueue();
        this.m_writeQueue = new FileRequestQueue();
        this.m_maxQueueSize = 200;
        this.m_lowQueueSize = 50;
        this.setName(name);
    }

    public final void startThreads(int recCnt) {
        int i;
        this.m_readLoader = new QueueLoader("ReadQueueLoader", FileRequest.RequestType.Load, this.m_readQueue, this.m_readLoaderLock);
        this.m_writeLoader = new QueueLoader("WriteQueueLoader", FileRequest.RequestType.Save, this.m_writeQueue, this.m_writeLoaderLock);
        this.m_readThreads = new ThreadWorker[this.m_readWorkers];
        for (i = 0; i < this.m_readWorkers; ++i) {
            this.m_readThreads[i] = new ThreadWorker(this.getName() + "_RD_" + (i + 1), i, this.m_readQueue, this.m_readLoader);
        }
        this.m_writeThreads = new ThreadWorker[this.m_writeWorkers];
        for (i = 0; i < this.m_writeWorkers; ++i) {
            this.m_writeThreads[i] = new ThreadWorker(this.getName() + "_WR_" + (i + 1), i, this.m_writeQueue, this.m_writeLoader);
        }
        if (this.hasDebug()) {
            Debug.println("FileLoader threadPool read=" + this.m_readWorkers + ", write=" + this.m_writeWorkers);
        }
        if (recCnt > 0) {
            this.m_writeLoader.notifyNewRecord(1);
        }
    }

    public final void enableTransactions() {
        if (this.m_tranLoader == null) {
            this.m_tranLoader = new TransactionQueueLoader(this.getName() + "_TranLdr", this.m_writeQueue);
        }
    }

    public final void shutdownThreads() {
        int i;
        if (this.m_readThreads != null) {
            for (i = 0; i < this.m_readThreads.length; ++i) {
                this.m_readThreads[i].shutdownRequest();
            }
        }
        if (this.m_writeThreads != null) {
            for (i = 0; i < this.m_writeThreads.length; ++i) {
                this.m_writeThreads[i].shutdownRequest();
            }
        }
        this.m_readLoader.shutdownRequest();
        this.m_readLoader = null;
        this.m_writeLoader.shutdownRequest();
        this.m_writeLoader = null;
        if (this.m_tranLoader != null) {
            this.m_tranLoader.shutdownRequest();
            this.m_tranLoader = null;
        }
    }

    public void queueFileRequest(FileRequest req) {
        block9: {
            if (req instanceof SingleFileRequest) {
                SingleFileRequest fileReq = (SingleFileRequest)req;
                if (fileReq.hasFileState()) {
                    fileReq.getFileState().setExpiryTime(-1L);
                }
                try {
                    this.getDBQueueInterface().queueFileRequest(fileReq);
                    if (!fileReq.isTransaction()) {
                        if (fileReq.isType() == FileRequest.RequestType.Load) {
                            this.m_readLoader.notifyNewRecord(fileReq.getSequenceNumber());
                        } else {
                            this.m_writeLoader.notifyNewRecord(fileReq.getSequenceNumber());
                        }
                    } else if (fileReq.isLastTransactionFile()) {
                        this.m_tranLoader.addTransaction("" + fileReq.getTransactionId());
                    }
                }
                catch (DBException ex) {
                    if (!this.hasDebug()) break block9;
                    Debug.println(ex);
                }
            }
        }
    }

    public final void flushTransaction(int tranId) {
        this.m_tranLoader.addTransaction("" + tranId);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final DBQueueInterface getDBQueueInterface() {
        return this.m_dbQueueInterface;
    }

    public final BackgroundFileLoader getFileLoader() {
        return this.m_fileLoader;
    }

    public final long getFileStateTimeout() {
        return this.m_stateTimeout;
    }

    public final int getMaximumQueueSize() {
        return this.m_maxQueueSize;
    }

    public final int getLowQueueSize() {
        return this.m_lowQueueSize;
    }

    public final String getName() {
        return this.m_name;
    }

    protected final FileRequestQueue getReadQueue() {
        return this.m_readQueue;
    }

    public final QueueLoader getReadLoader() {
        return this.m_readLoader;
    }

    protected final FileRequestQueue getWriteQueue() {
        return this.m_writeQueue;
    }

    public final QueueLoader getWriteLoader() {
        return this.m_writeLoader;
    }

    public final int getReadWorkers() {
        return this.m_readWorkers;
    }

    public final int getWriteWorkers() {
        return this.m_writeWorkers;
    }

    protected final FileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    public final void setMaximumQueueSize(int qsize) {
        this.m_maxQueueSize = qsize;
    }

    public final void setLowQueueSize(int lowqSize) {
        this.m_lowQueueSize = lowqSize;
    }

    public final void setReadWorkers(int rdWorkers) {
        this.m_readWorkers = rdWorkers;
    }

    public final void setWriteWorkers(int wrWorkers) {
        this.m_writeWorkers = wrWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileState createFileStateForRequest(int fid, String tempPath, String virtPath, SegmentInfo.State sts) {
        FileState state = this.m_stateCache.findFileState(virtPath, false);
        if (state == null) {
            FileState fileState = state = this.m_stateCache.findFileState(virtPath, true);
            synchronized (fileState) {
                state.setExpiryTime(-1L);
                state.setFileStatus(FileStatus.FileExists);
                state.setFileId(fid);
                FileSegmentInfo fileSegInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
                FileSegment fileSeg = null;
                if (fileSegInfo == null) {
                    fileSegInfo = new FileSegmentInfo();
                    fileSegInfo.setTemporaryFile(tempPath);
                    fileSeg = new FileSegment(fileSegInfo, true);
                    fileSeg.setStatus(sts, true);
                    state.addAttribute(DBFileSegmentInfo, fileSegInfo);
                } else {
                    fileSeg = new FileSegment(fileSegInfo, true);
                    fileSeg.setStatus(sts, true);
                }
            }
        }
        return state;
    }

    protected class TransactionQueueLoader
    implements Runnable {
        private Thread mi_thread;
        private boolean mi_shutdown = false;
        private boolean mi_loading;
        private List mi_transList;
        private FileRequestQueue mi_queue;

        public TransactionQueueLoader(String name, FileRequestQueue queue) {
            this.mi_queue = queue;
            this.mi_transList = new ArrayList();
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addTransaction(String name) {
            List list = this.mi_transList;
            synchronized (list) {
                this.mi_transList.add(name);
                if (this.mi_transList.size() == 1) {
                    this.mi_transList.notify();
                }
            }
        }

        public final boolean isLoading() {
            return this.mi_loading;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: while (!this.mi_shutdown) {
                try {
                    List list = this.mi_transList;
                    synchronized (list) {
                        if (this.mi_transList.size() == 0) {
                            this.mi_transList.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) break;
                }
                while (this.mi_transList.size() > 0) {
                    block24: {
                        String tranName = null;
                        int tranId = -1;
                        List list = this.mi_transList;
                        synchronized (list) {
                            tranName = (String)this.mi_transList.remove(0);
                        }
                        if (this.mi_transList.size() > 0) {
                            Debug.println("TransQueueLoader Processing tranName=" + tranName + ", queued=" + this.mi_transList.size());
                        }
                        try {
                            tranId = Integer.parseInt(tranName);
                        }
                        catch (NumberFormatException ex) {
                            Debug.println(ex);
                            continue block14;
                        }
                        if (BackgroundLoadSave.this.hasDebug()) {
                            Debug.println("BackgroundLoadSave Transaction load requested, tran=" + tranId);
                        }
                        try {
                            this.mi_loading = true;
                            MultipleFileRequest fileReq = new MultipleFileRequest(FileRequest.RequestType.TransSave, tranId);
                            CachedFileInfo finfo = null;
                            if (BackgroundLoadSave.this.getDBQueueInterface().loadTransactionRequest(fileReq) != null) {
                                FileState fstate = null;
                                for (int i = 0; i < fileReq.getNumberOfFiles(); ++i) {
                                    finfo = fileReq.getFileInfo(i);
                                    try {
                                        fstate = BackgroundLoadSave.this.createFileStateForRequest(finfo.getFileId(), finfo.getTemporaryPath(), finfo.getVirtualPath(), SegmentInfo.State.SaveWait);
                                        finfo.setFileState(fstate);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        Debug.println(ex);
                                    }
                                }
                                this.mi_queue.addRequest(fileReq);
                                if (BackgroundLoadSave.this.hasDebug()) {
                                    Debug.println("BackgroundLoadSave Loaded transaction " + fileReq);
                                }
                            }
                        }
                        catch (DBException ex) {
                            if (!BackgroundLoadSave.this.hasDebug()) break block24;
                            Debug.println(ex);
                        }
                    }
                    this.mi_loading = false;
                }
            }
            if (BackgroundLoadSave.this.hasDebug()) {
                Debug.println("BackgroundLoadSave Transaction queue loader shutdown");
            }
        }
    }

    protected class QueueLoader
    implements Runnable {
        private Thread mi_thread;
        private FileRequest.RequestType mi_loadType;
        private boolean mi_shutdown = false;
        private int mi_lastSeqNo;
        private boolean mi_loading;
        private FileRequestQueue mi_queue;
        private Object mi_lockObj;
        private boolean mi_newRecords = true;
        private int mi_lastQueuedSeq;

        public QueueLoader(String name, FileRequest.RequestType type, FileRequestQueue queue, Object lock) {
            this.mi_loadType = type;
            this.mi_queue = queue;
            this.mi_lockObj = lock;
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final boolean isLoading() {
            return this.mi_loading;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void notifyNewRecord(int seqNo) {
            this.mi_newRecords = true;
            if (seqNo > this.mi_lastQueuedSeq) {
                this.mi_lastQueuedSeq = seqNo;
            }
            Object object = this.mi_lockObj;
            synchronized (object) {
                this.mi_lockObj.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void checkRequestQueue() {
            int qSize = this.mi_queue.numberOfRequests();
            if (!this.isLoading() && qSize < BackgroundLoadSave.this.getLowQueueSize() && (this.mi_newRecords || qSize == 0)) {
                Object object = this.mi_lockObj;
                synchronized (object) {
                    this.mi_lockObj.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileRequestQueue tempQueue = new FileRequestQueue();
            while (!this.mi_shutdown) {
                block17: {
                    block16: {
                        try {
                            if (this.mi_queue.numberOfRequests() <= 0 && this.mi_lastQueuedSeq != 0 && this.mi_lastSeqNo < this.mi_lastQueuedSeq) break block16;
                            Object object = this.mi_lockObj;
                            synchronized (object) {
                                this.mi_lockObj.wait();
                            }
                        }
                        catch (InterruptedException ex) {
                            if (this.mi_shutdown) break;
                        }
                    }
                    if (BackgroundLoadSave.this.hasDebug()) {
                        Debug.println("BackgroundLoadSave Queue load requested, seqNo=" + this.mi_lastSeqNo);
                    }
                    int loadCnt = 0;
                    try {
                        this.mi_loading = true;
                        tempQueue.removeAllRequests();
                        int recCnt = BackgroundLoadSave.this.getMaximumQueueSize() - this.mi_queue.numberOfRequests();
                        loadCnt = BackgroundLoadSave.this.getDBQueueInterface().loadFileRequests(this.mi_lastSeqNo, this.mi_loadType, tempQueue, recCnt);
                        if (loadCnt <= 0) break block17;
                        while (tempQueue.numberOfRequests() > 0) {
                            SingleFileRequest fileReq = (SingleFileRequest)tempQueue.removeRequestNoWait();
                            this.mi_lastSeqNo = fileReq.getSequenceNumber();
                            SegmentInfo.State fsts = fileReq.isType() == FileRequest.RequestType.Load ? SegmentInfo.State.LoadWait : SegmentInfo.State.SaveWait;
                            FileState fstate = null;
                            try {
                                fstate = BackgroundLoadSave.this.createFileStateForRequest(fileReq.getFileId(), fileReq.getTemporaryFile(), fileReq.getVirtualPath(), fsts);
                                fileReq.setFileState(fstate);
                            }
                            catch (Exception ex) {
                                Debug.println(ex);
                            }
                            this.mi_queue.addRequest(fileReq);
                        }
                        if (loadCnt < recCnt) {
                            this.mi_newRecords = false;
                        }
                        if (BackgroundLoadSave.this.hasDebug()) {
                            Debug.println("BackgroundLoadSave Loaded " + loadCnt + " records from queue db, type " + (this.mi_loadType == FileRequest.RequestType.Load ? "Read" : "Write"));
                        }
                    }
                    catch (DBException ex) {
                        if (BackgroundLoadSave.this.hasDebug()) {
                            Debug.println("BackgroundLoadSave Error " + ex.toString());
                            Debug.println("  Last SeqNo=" + this.mi_lastSeqNo);
                        }
                        this.mi_lastSeqNo = 0;
                    }
                }
                this.mi_loading = false;
            }
            if (BackgroundLoadSave.this.hasDebug()) {
                Debug.println("BackgroundLoadSave Queue loader shutdown");
            }
        }
    }

    protected class ThreadWorker
    implements Runnable {
        private Thread mi_thread;
        private int mi_id;
        private FileRequestQueue mi_queue;
        private QueueLoader mi_loader;
        private boolean mi_shutdown = false;

        public ThreadWorker(String name, int id, FileRequestQueue queue, QueueLoader loader) {
            this.mi_id = id;
            this.mi_queue = queue;
            this.mi_loader = loader;
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            FileRequest fileReq = null;
            while (!this.mi_shutdown) {
                Status reqSts;
                block21: {
                    try {
                        fileReq = this.mi_queue.removeRequest();
                    }
                    catch (InterruptedException ex) {
                        if (this.mi_shutdown) break;
                    }
                    if (fileReq == null) continue;
                    if (BackgroundLoadSave.this.hasDebug()) {
                        Debug.println("BackgroundLoadSave loader=" + BackgroundLoadSave.this.getName() + ", fileReq=" + fileReq + ", queued=" + this.mi_queue.numberOfRequests());
                    }
                    this.mi_loader.checkRequestQueue();
                    reqSts = Status.Requeue;
                    try {
                        fileReq.setThreadId(this.mi_id);
                        if (fileReq.isType() == FileRequest.RequestType.Load) {
                            reqSts = BackgroundLoadSave.this.getFileLoader().loadFile(fileReq);
                        } else if (fileReq.isType() == FileRequest.RequestType.Save || fileReq.isType() == FileRequest.RequestType.TransSave) {
                            reqSts = BackgroundLoadSave.this.getFileLoader().storeFile(fileReq);
                        }
                    }
                    catch (Exception ex) {
                        if (!BackgroundLoadSave.this.hasDebug()) break block21;
                        Debug.println("BackgroundLoadSave exception=" + ex.toString());
                        Debug.println(ex);
                    }
                }
                if (reqSts == Status.Success || reqSts == Status.Error) {
                    block22: {
                        try {
                            BackgroundLoadSave.this.getDBQueueInterface().deleteFileRequest(fileReq);
                        }
                        catch (DBException ex) {
                            if (!BackgroundLoadSave.this.hasDebug()) break block22;
                            Debug.println("BackgroundLoadSave Error: " + ex.toString());
                        }
                    }
                    if (fileReq instanceof MultipleFileRequest) {
                        MultipleFileRequest multiReq = (MultipleFileRequest)fileReq;
                        long expireAt = System.currentTimeMillis() + 3000L;
                        for (int i = 0; i < multiReq.getNumberOfFiles(); ++i) {
                            CachedFileInfo finfo = multiReq.getFileInfo(i);
                            if (!finfo.hasFileState()) continue;
                            finfo.getFileState().setExpiryTime(expireAt);
                        }
                    } else {
                        SingleFileRequest singleReq = (SingleFileRequest)fileReq;
                        if (singleReq.hasFileState()) {
                            singleReq.getFileState().setExpiryTime(System.currentTimeMillis() + 3000L);
                        }
                    }
                    if (reqSts != Status.Error || !BackgroundLoadSave.this.hasDebug()) continue;
                    Debug.println("BackgroundLoadSave Error request=" + fileReq);
                    continue;
                }
                if (reqSts != Status.Requeue) continue;
                if (BackgroundLoadSave.this.hasDebug()) {
                    Debug.println("BackgroundLoadSave ReQueue request=" + fileReq);
                }
                if (this.mi_queue.numberOfRequests() < 20) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.mi_queue.addRequest(fileReq);
            }
            if (BackgroundLoadSave.this.hasDebug()) {
                Debug.println("BackgroundLoadSave thread=" + this.mi_thread.getName() + " shutdown");
            }
        }
    }

    public static enum Status {
        Success,
        Requeue,
        Error;

    }
}

