/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.db.DBNetworkFile;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileRequest;

public abstract class CachedNetworkFile
extends DBNetworkFile {
    protected static final long DataLoadWaitTime = 20000L;
    protected static final long DataPollSleepTime = 250L;
    protected static final boolean DEBUG = false;
    protected long m_lastReadPos = -1L;
    protected int m_lastReadLen = -1;
    protected int m_seqReads;
    protected boolean m_seqOnly;

    public CachedNetworkFile(String name, int fid, int stid, int did, FileStateProxy state, FileLoader loader) {
        super(name, fid, stid, did);
        this.setFileState(state);
        this.setLoader(loader);
    }

    public final boolean isSequentialOnly() {
        return this.m_seqOnly;
    }

    public final void setSequentialOnly(boolean seq) {
        this.m_seqOnly = seq;
    }

    protected final void updateFileSize(long siz, long alloc) {
        FileInfo finfo;
        if (this.hasFileState() && (finfo = (FileInfo)this.getFileState().findAttribute("FileInfo")) != null && finfo.getSize() != siz) {
            finfo.setSize(siz);
            if (alloc != -1L || finfo.getSize() > finfo.getAllocationSize()) {
                finfo.setAllocationSize(alloc);
            }
        }
        this.setFileSize(siz);
    }

    protected abstract FileRequest createFileRequest(FileRequest.RequestType var1, long var2, int var4, boolean var5);

    protected final boolean hasDebug() {
        return false;
    }
}

