/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.SearchContext;
import org.filesys.util.WildCard;

public abstract class DBSearchContext
extends SearchContext {
    protected ResultSet m_rs;
    protected Statement m_stmt;
    protected WildCard m_filter;
    protected boolean m_offlineFiles;
    protected long m_offlineFileSize;

    public DBSearchContext(ResultSet rs) {
        this.m_rs = rs;
    }

    public DBSearchContext(ResultSet rs, WildCard filter) {
        this.m_rs = rs;
        this.m_filter = filter;
    }

    public DBSearchContext(ResultSet rs, Statement stmt, WildCard filter) {
        this.m_rs = rs;
        this.m_stmt = stmt;
        this.m_filter = filter;
    }

    @Override
    public int getResumeId() {
        int resumeId = -1;
        try {
            resumeId = this.m_rs.getRow();
        }
        catch (SQLException ex) {
            Debug.println(ex);
        }
        return resumeId;
    }

    @Override
    public boolean hasMoreFiles() {
        if (this.m_rs == null) {
            return false;
        }
        boolean moreFiles = true;
        try {
            moreFiles = !this.m_rs.isAfterLast();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return moreFiles;
    }

    @Override
    public abstract boolean nextFileInfo(FileInfo var1);

    @Override
    public abstract String nextFileName();

    @Override
    public boolean restartAt(int resumeId) {
        boolean result = true;
        try {
            this.m_rs.beforeFirst();
            this.m_rs.absolute(resumeId);
        }
        catch (SQLException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean restartAt(FileInfo info) {
        try {
            this.m_rs.previous();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int numberOfEntries() {
        int rows = -1;
        try {
            this.m_rs.last();
            rows = this.m_rs.getRow();
            this.m_rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rows;
    }

    @Override
    public void closeSearch() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
                if (this.m_stmt != null) {
                    this.m_stmt.close();
                }
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
            this.m_rs = null;
            this.m_stmt = null;
        }
        super.closeSearch();
    }

    public final boolean hasMarkAsOffline() {
        return this.m_offlineFiles;
    }

    public final long getOfflineFileSize() {
        return this.m_offlineFileSize;
    }

    public final void setMarkAsOffline(boolean offline) {
        this.m_offlineFiles = offline;
    }

    public final void setOfflineFileSize(long fsize) {
        this.m_offlineFileSize = fsize;
    }
}

