/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.db.CachedNetworkFile;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileSegment;
import org.filesys.server.filesys.loader.SegmentInfo;
import org.filesys.server.filesys.loader.SingleFileRequest;

public class FileCachedNetworkFile
extends CachedNetworkFile {
    protected FileSegment m_cacheFile;

    public FileCachedNetworkFile(String name, int fid, int stid, int did, FileStateProxy state, FileSegment segment, FileLoader loader) {
        super(name, fid, stid, did, state, loader);
        this.m_cacheFile = segment;
    }

    public final FileSegment getFileSegment() {
        return this.m_cacheFile;
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
        if (!this.m_cacheFile.fileExists()) {
            this.m_cacheFile.createTemporaryFile();
        }
        this.m_cacheFile.openFile();
        this.setClosed(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        boolean seqRead = false;
        if (this.m_lastReadPos != -1L && fileOff == this.m_lastReadPos + (long)this.m_lastReadLen) {
            seqRead = true;
            ++this.m_seqReads;
        }
        if (this.m_cacheFile.hasStatus() == SegmentInfo.State.Error) {
            throw new IOException("Load file error - " + this.getFullName());
        }
        this.m_lastReadPos = fileOff;
        this.m_lastReadLen = len;
        if (this.m_cacheFile.hasStatus() == SegmentInfo.State.Initial && !this.m_cacheFile.isQueued()) {
            if (!this.m_cacheFile.fileExists()) {
                this.m_cacheFile.createTemporaryFile();
            }
            FileState fileState = this.getFileState();
            synchronized (fileState) {
                if (!this.m_cacheFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Load, 0L, 0, false));
                }
            }
        }
        int rdlen = 0;
        if (this.m_cacheFile.isDataAvailable()) {
            rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            if (rdlen <= 0) {
                this.m_cacheFile.closeFile();
                this.m_cacheFile.openFile();
                rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            }
            return rdlen;
        }
        long waitTime = 0L;
        boolean readDone = false;
        boolean dataAvailable = false;
        while (!readDone && waitTime < 20000L && (this.m_cacheFile.isDataLoading() || this.m_cacheFile.isDataAvailable())) {
            dataAvailable = this.m_cacheFile.isDataAvailable();
            if (!dataAvailable) {
                long fileLen = this.m_cacheFile.getReadableLength();
                if (fileLen != -1L && fileLen + 65535L > fileOff + (long)len) {
                    rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
                }
            } else {
                rdlen = this.m_cacheFile.readBytes(buf, len, pos, fileOff);
            }
            if (rdlen > 0) {
                if (!dataAvailable && rdlen < len) {
                    readDone = false;
                    continue;
                }
                readDone = true;
                continue;
            }
            if (dataAvailable) {
                readDone = true;
                continue;
            }
            try {
                this.setIOPending(true);
                long startTime = System.currentTimeMillis();
                this.m_cacheFile.waitForData(250L, fileOff, len);
                long endTime = System.currentTimeMillis();
                waitTime += endTime - startTime;
                this.setIOPending(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.m_cacheFile.hasLoadError()) continue;
            throw new IOException("Load file error - " + this.getFullName());
        }
        if (this.m_cacheFile.hasLoadError()) {
            throw new IOException("Load file error - " + this.getFullName());
        }
        if (readDone) {
            return rdlen;
        }
        throw new FileOfflineException("File data not available");
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_cacheFile.writeBytes(buf, len, pos, offset);
        this.incrementWriteCount();
        long fileLen = this.m_cacheFile.getFileLength();
        if (fileLen != -1L) {
            this.updateFileSize(fileLen, -1L);
        }
    }

    @Override
    public void flushFile() throws IOException {
        if (this.m_cacheFile != null && this.m_cacheFile.isOpen()) {
            this.m_cacheFile.flush();
        }
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        return 0L;
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_cacheFile.truncate(siz);
        this.updateFileSize(siz, siz);
        this.incrementWriteCount();
    }

    @Override
    public void closeFile() {
        if (this.m_cacheFile != null) {
            try {
                long fileSize;
                if (this.m_cacheFile.isDataAvailable() && this.m_cacheFile.isOpen() && (fileSize = this.m_cacheFile.getFileLength()) != -1L) {
                    this.setFileSize(fileSize);
                }
                this.m_cacheFile.closeFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected FileRequest createFileRequest(FileRequest.RequestType typ, long fileOff, int len, boolean outOfSeq) {
        return new SingleFileRequest(typ, this.getFileId(), this.getStreamId(), this.m_cacheFile.getFileInfo(), this.getFullName(), this.getFileState());
    }

    protected void finalize() {
        if (this.m_cacheFile != null && this.m_cacheFile.isOpen()) {
            try {
                this.m_cacheFile.closeFile();
                this.m_cacheFile = null;
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        }
    }
}

