/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.db.CachedNetworkFile;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.InMemoryLoader;
import org.filesys.server.filesys.loader.MemoryBuffer;
import org.filesys.server.filesys.loader.MemoryLoadableFile;
import org.filesys.server.filesys.loader.MemorySegmentInfo;
import org.filesys.server.filesys.loader.MemoryStorableFile;
import org.filesys.server.filesys.loader.SegmentInfo;

public abstract class MemCachedNetworkFile
extends CachedNetworkFile {
    public static final long WriteBufferWaitTime = 20000L;
    protected MemorySegmentInfo m_memFile;

    public MemCachedNetworkFile(String name, int fid, int stid, int did, FileStateProxy state, MemorySegmentInfo segment, FileLoader loader) {
        super(name, fid, stid, did, state, loader);
        this.m_memFile = segment;
    }

    public final MemorySegmentInfo getMemorySegment() {
        return this.m_memFile;
    }

    public final void setMemorySegment(MemorySegmentInfo memInfo) {
        this.m_memFile = memInfo;
    }

    public abstract long getInMemoryMaximumSize();

    @Override
    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_memFile.hasLoadError()) {
            throw new FileOfflineException("Error loading from store");
        }
        this.m_lastReadPos = fileOff;
        this.m_lastReadLen = len;
        MemoryLoadableFile.LoadableStatus loadSts = this.m_memFile.hasDataFor(fileOff, len);
        int rdlen = 0;
        if (loadSts == MemoryLoadableFile.LoadableStatus.Available) {
            rdlen = this.m_memFile.readBytes(buf, len, pos, fileOff);
        } else if (loadSts == MemoryLoadableFile.LoadableStatus.Loadable || loadSts == MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq || loadSts == MemoryLoadableFile.LoadableStatus.Loading) {
            long waitTime = 0L;
            boolean readDone = false;
            boolean dataAvailable = false;
            while (!readDone && waitTime < 20000L) {
                if (loadSts == MemoryLoadableFile.LoadableStatus.Loadable || loadSts == MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq) {
                    MemorySegmentInfo memorySegmentInfo = this.m_memFile;
                    synchronized (memorySegmentInfo) {
                        if (!this.m_memFile.isQueued()) {
                            this.m_memFile.setStatus(SegmentInfo.State.Loading);
                            boolean outOfSeq = loadSts == MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq;
                            this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Load, fileOff, len, outOfSeq));
                        }
                    }
                }
                try {
                    this.setIOPending(true);
                    long startTime = System.currentTimeMillis();
                    this.m_memFile.waitForData(250L, fileOff, len);
                    long endTime = System.currentTimeMillis();
                    waitTime += endTime - startTime;
                    this.setIOPending(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_memFile.hasLoadError()) {
                    throw new FileOfflineException("Load error for " + this.getFullName());
                }
                loadSts = this.m_memFile.hasDataFor(fileOff, len);
                if (loadSts != MemoryLoadableFile.LoadableStatus.Available) continue;
                rdlen = this.m_memFile.readBytes(buf, len, pos, fileOff);
                readDone = true;
                if (!this.hasDebug()) continue;
                Debug.println("MemCachedNetworkFile waited " + waitTime + "ms for data, rdlen=" + rdlen + ", len=" + len);
            }
            if (!readDone) {
                throw new FileOfflineException("Failed to load file data in 20000ms for " + this.getFullName());
            }
        } else {
            throw new FileOfflineException("Data not available for read, offset=" + fileOff + ", len=" + len);
        }
        return rdlen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        if (this.m_memFile.hasSaveError()) {
            throw new IOException("Write error saving to store");
        }
        MemoryStorableFile.SaveableStatus writeSts = this.m_memFile.writeBytes(buf, len, pos, offset);
        if (writeSts == MemoryStorableFile.SaveableStatus.Saveable) {
            MemorySegmentInfo memorySegmentInfo = this.m_memFile;
            synchronized (memorySegmentInfo) {
                if (!this.m_memFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, offset, len, false));
                }
            }
        }
        if (writeSts == MemoryStorableFile.SaveableStatus.MaxBuffers) {
            long waitTime = 0L;
            boolean writeDone = false;
            while (!writeDone && waitTime < 20000L) {
                try {
                    this.setIOPending(true);
                    long startTime = System.currentTimeMillis();
                    this.m_memFile.waitForWriteBuffer(2000L);
                    long endTime = System.currentTimeMillis();
                    waitTime += endTime - startTime;
                    this.setIOPending(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                writeSts = this.m_memFile.writeBytes(buf, len, pos, offset);
                if (writeSts == MemoryStorableFile.SaveableStatus.Saveable) {
                    MemorySegmentInfo memorySegmentInfo = this.m_memFile;
                    synchronized (memorySegmentInfo) {
                        if (!this.m_memFile.isQueued()) {
                            this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, offset, len, false));
                        }
                    }
                    writeDone = true;
                } else if (writeSts == MemoryStorableFile.SaveableStatus.Buffering) {
                    writeDone = true;
                }
                if (!writeDone || !this.hasDebug()) continue;
                Debug.println("MemCachedNetworkFile waited " + waitTime + "ms for write buffer, writeSts=" + writeSts.name());
            }
        } else if (writeSts == MemoryStorableFile.SaveableStatus.BufferOverflow && this.m_memFile.isAllFileData()) {
            long fileLen = offset + (long)len;
            if (!(this.getLoader() instanceof InMemoryLoader)) throw new DiskFullException("Cannot convert in-memory file to streamed, " + this.getFullName() + ", size=" + fileLen);
            InMemoryLoader inMemLoader = (InMemoryLoader)((Object)this.getLoader());
            if (!inMemLoader.convertInMemoryToStreamedFile(this)) throw new IOException("Failed to convert to streamed file, " + this.getFullName() + ", size=" + fileLen);
            if (this.hasDebug()) {
                Debug.println("MemCachedNetworkFile: Converted to streamed file, path=" + this.getFullName() + ", size=" + fileLen);
            }
            this.writeFile(buf, len, pos, offset);
        }
        this.incrementWriteCount();
        long fileLen = this.m_memFile.getFileLength();
        if (fileLen == -1L) return;
        this.updateFileSize(fileLen, -1L);
    }

    @Override
    public void flushFile() throws IOException {
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        return 0L;
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_memFile.truncate(siz);
        this.updateFileSize(siz, siz);
        this.incrementWriteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile() {
        MemoryBuffer updData;
        this.setClosed(true);
        if (this.getWriteCount() > 0 && (updData = this.m_memFile.dataToSave()) != null) {
            this.m_memFile.closeFile();
            MemorySegmentInfo memorySegmentInfo = this.m_memFile;
            synchronized (memorySegmentInfo) {
                if (!this.m_memFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, updData.getFileOffset(), updData.getUsedLength(), false));
                }
            }
        }
    }
}

