/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.util.EnumSet;
import org.filesys.debug.Debug;

public class MemoryBuffer {
    private byte[] m_data;
    private long m_fileOffset;
    private volatile int m_usedLen;
    private EnumSet<Flags> m_flags = EnumSet.noneOf(Flags.class);

    public MemoryBuffer() {
    }

    public MemoryBuffer(byte[] byts, long fileOff) {
        this.m_data = byts;
        this.m_fileOffset = fileOff;
        this.m_usedLen = this.m_data.length;
    }

    public MemoryBuffer(byte[] byts, long fileOff, int usedLen) {
        this.m_data = byts;
        this.m_fileOffset = fileOff;
        this.m_usedLen = usedLen;
    }

    public final byte[] getData() {
        return this.m_data;
    }

    public final long getFileOffset() {
        return this.m_fileOffset;
    }

    public final int getUsedLength() {
        return this.m_usedLen;
    }

    public final int getBufferSize() {
        return this.m_data != null ? this.m_data.length : 0;
    }

    public final boolean isFull() {
        return this.m_data != null && this.m_data.length == this.m_usedLen;
    }

    public final boolean hasWriteData() {
        return this.m_flags.contains((Object)Flags.Written);
    }

    public final boolean isOutOfSequence() {
        return this.m_flags.contains((Object)Flags.OutOfSeq);
    }

    public final void setFileOffset(long fileOff) {
        this.m_fileOffset = fileOff;
    }

    public final void setUsedLength(int usedLen) {
        this.m_usedLen = usedLen;
    }

    public final void setWrittenTo(boolean writtenTo) {
        if (writtenTo) {
            this.m_flags.add(Flags.Written);
        } else {
            this.m_flags.remove((Object)Flags.Written);
        }
    }

    public final void setOutOfSequence(boolean outOfSeq) {
        if (outOfSeq) {
            this.m_flags.add(Flags.OutOfSeq);
        } else {
            this.m_flags.remove((Object)Flags.OutOfSeq);
        }
    }

    public final Contains containsData(long fileOff, int dataLen) {
        long dataEndOff = fileOff + (long)dataLen;
        long endOff = this.getFileOffset() + (long)this.getUsedLength();
        if (fileOff >= this.getFileOffset() && fileOff < endOff) {
            if (dataEndOff <= endOff) {
                return Contains.All;
            }
            return Contains.Partial;
        }
        return Contains.None;
    }

    public final Contains canFitData(long fileOff, int dataLen) {
        long dataEndOff = fileOff + (long)dataLen;
        long endOff = this.getFileOffset() + (long)this.getBufferSize();
        if (fileOff >= this.getFileOffset() && fileOff < endOff) {
            if (dataEndOff <= endOff) {
                return Contains.All;
            }
            return Contains.Partial;
        }
        return Contains.None;
    }

    public final int readBytes(byte[] buf, int len, int pos, long fileOff) {
        long endOffset = this.getFileOffset() + (long)this.getUsedLength();
        if (fileOff < this.getFileOffset() || fileOff > endOffset) {
            return 0;
        }
        int bufOffset = (int)(fileOff - this.getFileOffset());
        if (fileOff + (long)len > endOffset) {
            len = (int)(endOffset - fileOff);
        }
        System.arraycopy(this.getData(), bufOffset, buf, pos, len);
        return len;
    }

    public final int writeBytes(byte[] buf, int len, int pos, long fileOff) {
        long endOffset = this.getFileOffset() + (long)this.getBufferSize();
        if (fileOff < this.getFileOffset() || fileOff > endOffset) {
            return 0;
        }
        int bufOffset = (int)(fileOff - this.getFileOffset());
        Debug.println("MemoryBuffer.writeBytes() fileOff=" + fileOff + ", len=" + len + ", bufOffset=" + bufOffset);
        if (fileOff + (long)len > endOffset) {
            len = (int)(endOffset - fileOff);
        }
        System.arraycopy(buf, pos, this.getData(), bufOffset, len);
        int usedLen = bufOffset + len;
        if (usedLen > this.m_usedLen) {
            this.m_usedLen = usedLen;
        }
        Debug.println("MemoryBuffer: write len=" + len + ", usedLen=" + this.m_usedLen + ", bufSize=" + this.m_data.length);
        this.setWrittenTo(true);
        return len;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Data:");
        str.append(this.getData());
        str.append(",fileOffset:");
        str.append(this.getFileOffset());
        if (this.m_data != null) {
            str.append(",len=");
            str.append(this.m_data.length);
            if (this.getUsedLength() != this.m_data.length) {
                str.append(",used=");
                str.append(this.getUsedLength());
            }
            if (this.isFull()) {
                str.append(",Full");
            }
            if (this.hasWriteData()) {
                str.append(",Write");
            }
            if (this.isOutOfSequence()) {
                str.append(",OutOfSeq");
            }
        }
        str.append("]");
        return str.toString();
    }

    public static enum Contains {
        All,
        Partial,
        None;

    }

    public static enum Flags {
        Written,
        OutOfSeq;

    }
}

