/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.IOException;
import java.util.EnumSet;
import org.filesys.debug.Debug;

public abstract class SegmentInfo {
    private volatile EnumSet<Flags> m_flags = EnumSet.noneOf(Flags.class);
    private volatile State m_status = State.Initial;
    private volatile long m_readable = -1L;

    public SegmentInfo() {
    }

    public SegmentInfo(EnumSet<Flags> flags) {
        this.m_flags = flags;
    }

    public final boolean isUpdated() {
        return this.m_flags.contains((Object)Flags.Updated);
    }

    public final boolean isQueued() {
        return this.m_flags.contains((Object)Flags.RequestQueued);
    }

    public final boolean isAllFileData() {
        return this.m_flags.contains((Object)Flags.AllData);
    }

    public final boolean isStreamed() {
        return this.m_flags.contains((Object)Flags.Streamed);
    }

    public final boolean hasDeleteFromStore() {
        return this.m_flags.contains((Object)Flags.DeleteFromStore);
    }

    public boolean isDataAvailable(long fileOff, int len) {
        return this.hasStatus().ordinal() >= State.Available.ordinal() && this.hasStatus().ordinal() < State.Error.ordinal();
    }

    public final boolean hasDeleteOnStore() {
        return this.m_flags.contains((Object)Flags.DeleteOnStore);
    }

    public final State hasStatus() {
        return this.m_status;
    }

    public final boolean hasLoadError() {
        return this.hasStatus() == State.Error && this.m_flags.contains((Object)Flags.ReadError);
    }

    public final boolean hasSaveError() {
        return this.hasStatus() == State.Error && this.m_flags.contains((Object)Flags.WriteError);
    }

    public final boolean isClosed() {
        return this.m_flags.contains((Object)Flags.FileClosed);
    }

    public abstract long getFileLength() throws IOException;

    public final long getReadableLength() {
        return this.m_readable;
    }

    public final EnumSet<Flags> getFlags() {
        return this.m_flags;
    }

    public final void setReadableLength(long readable) {
        this.m_readable = readable;
    }

    public final synchronized void setStatus(State sts) {
        this.m_status = sts;
        this.notifyAll();
    }

    public final void setUpdated(boolean sts) {
        this.setFlag(Flags.Updated, sts);
    }

    public final void setQueued(boolean qd) {
        this.setFlag(Flags.RequestQueued, qd);
    }

    public final void setDeleteOnStore() {
        this.setFlag(Flags.DeleteOnStore, true);
    }

    public final void setDeleteFromStore() {
        this.setFlag(Flags.DeleteFromStore, true);
    }

    public final void setAllFileData(boolean allData) {
        this.setFlag(Flags.AllData, allData);
    }

    public final void setStreamed(boolean streamed) {
        this.setFlag(Flags.Streamed, streamed);
    }

    public final void setReadError(boolean readErr) {
        this.setFlag(Flags.ReadError, readErr);
    }

    public final void setWriteError(boolean writeErr) {
        this.setFlag(Flags.WriteError, writeErr);
    }

    public final void setFileClosed(boolean closed) {
        this.setFlag(Flags.FileClosed, closed);
    }

    protected final synchronized void setFlag(Flags flag, boolean sts) {
        if (sts) {
            this.m_flags.add(flag);
        } else {
            this.m_flags.remove((Object)flag);
        }
        Debug.println("SegmentInfo: setFlag flag=" + flag.name() + ", sts=" + sts + ", flags=" + this.m_flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForData(long tmo, long fileOff, int len) {
        if (!this.isDataAvailable(fileOff, len)) {
            SegmentInfo segmentInfo = this;
            synchronized (segmentInfo) {
                try {
                    this.wait(tmo);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final synchronized void signalDataAvailable() {
        this.notifyAll();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.hasStatus().name());
        str.append(",");
        str.append(",flags=");
        str.append(this.m_flags);
        str.append("]");
        return str.toString();
    }

    public static enum Flags {
        Updated,
        RequestQueued,
        DeleteOnStore,
        AllData,
        Streamed,
        ReadError,
        WriteError,
        FileClosed,
        DeleteFromStore;

    }

    public static enum State {
        Initial,
        LoadWait,
        Loading,
        Available,
        SaveWait,
        Saving,
        Saved,
        Error;

    }
}

