/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.pseudo;

import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.pseudo.PseudoFile;
import org.filesys.server.filesys.pseudo.PseudoFileList;

public abstract class PseudoSearchContext
extends SearchContext {
    protected int m_index;
    private PseudoFileList m_pseudoList;
    private boolean m_donePseudoFiles = false;
    private int m_resumeId;
    private String m_relPath;

    public PseudoSearchContext(String relPath) {
        this.m_relPath = relPath;
    }

    public final boolean hasPseudoFiles() {
        return this.m_pseudoList != null && this.m_pseudoList.numberOfFiles() > 0;
    }

    public final void setPseudoFileList(PseudoFileList pseudoList) {
        this.m_pseudoList = pseudoList;
    }

    @Override
    public int getResumeId() {
        return this.m_resumeId;
    }

    public boolean hasMorePseudoFiles() {
        return !this.m_donePseudoFiles && this.m_pseudoList != null && this.m_index < this.m_pseudoList.numberOfFiles() - 1;
    }

    public boolean nextPseudoFileInfo(FileInfo info) {
        PseudoFile pfile;
        if (!this.hasMorePseudoFiles()) {
            return false;
        }
        ++this.m_index;
        ++this.m_resumeId;
        if (!this.m_donePseudoFiles && this.m_pseudoList != null && this.m_index < this.m_pseudoList.numberOfFiles() && (pfile = this.m_pseudoList.getFileAt(this.m_index)) != null) {
            FileInfo pinfo = pfile.getFileInfo();
            info.copyFrom(pinfo);
            if (info != null && info.getFileId() == -1) {
                StringBuilder pathStr = new StringBuilder(this.m_relPath);
                pathStr.append(info.getFileName());
                info.setFileId(pathStr.toString().hashCode());
            }
            if (this.m_index == this.m_pseudoList.numberOfFiles() - 1) {
                this.m_donePseudoFiles = true;
                this.m_index = -1;
            }
            return true;
        }
        return false;
    }

    public String nextPseudoFileName() {
        if (!this.hasMorePseudoFiles()) {
            return null;
        }
        ++this.m_index;
        ++this.m_resumeId;
        if (!this.m_donePseudoFiles && this.m_pseudoList != null) {
            if (this.m_index < this.m_pseudoList.numberOfFiles()) {
                PseudoFile pfile = this.m_pseudoList.getFileAt(this.m_index);
                if (pfile != null) {
                    FileInfo pinfo = pfile.getFileInfo();
                    return pinfo.getFileName();
                }
            } else {
                this.m_donePseudoFiles = true;
                this.m_index = -1;
            }
        }
        return null;
    }

    public boolean restartAtPseudoFile(FileInfo info) {
        if (this.m_pseudoList != null) {
            for (int resId = 0; resId < this.m_pseudoList.numberOfFiles(); ++resId) {
                PseudoFile pfile = this.m_pseudoList.getFileAt(resId);
                if (!pfile.getFileName().equals(info.getFileName())) continue;
                this.m_donePseudoFiles = false;
                this.m_index = resId - 1;
                return true;
            }
        }
        return false;
    }

    public boolean restartAtPseudoFile(int resumeId) {
        if (this.m_pseudoList != null && resumeId < this.m_pseudoList.numberOfFiles()) {
            this.m_index = resumeId;
            this.m_donePseudoFiles = false;
            return true;
        }
        return false;
    }
}

