/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb;

import java.util.HashMap;
import java.util.Map;

public enum PacketTypeV2 {
    Negotiate(0),
    SessionSetup(1),
    Logoff(2),
    TreeConnect(3),
    TreeDisconnect(4),
    Create(5),
    Close(6),
    Flush(7),
    Read(8),
    Write(9),
    Lock(10),
    IOCtl(11),
    Cancel(12),
    Echo(13),
    QueryDirectory(14),
    ChangeNotify(15),
    QueryInfo(16),
    SetInfo(17),
    OplockBreak(18),
    Invalid(65535);

    private final int pktType;
    private static Map<Integer, PacketTypeV2> _typeMap;

    private PacketTypeV2(int typ) {
        this.pktType = typ;
    }

    public final int intValue() {
        return this.pktType;
    }

    public static final PacketTypeV2 fromInt(int typ) {
        if (_typeMap.containsKey(typ)) {
            return _typeMap.get(typ);
        }
        return Invalid;
    }

    static {
        _typeMap = new HashMap<Integer, PacketTypeV2>();
        for (PacketTypeV2 typeV2 : PacketTypeV2.values()) {
            _typeMap.put(typeV2.intValue(), typeV2);
        }
    }
}

