/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb;

public enum SharingMode {
    NOSHARING(0),
    READ(1),
    WRITE(2),
    READ_WRITE(3),
    DELETE(4),
    READ_DELETE(5),
    WRITE_DELETE(6),
    ALL(7),
    INVALID(-1);

    private final int shareMode;

    private SharingMode(int mode) {
        this.shareMode = mode;
    }

    public final int intValue() {
        return this.shareMode;
    }

    public final boolean hasRead() {
        return (this.shareMode & READ.intValue()) != 0;
    }

    public final boolean hasWrite() {
        return (this.shareMode & WRITE.intValue()) != 0;
    }

    public final boolean hasDelete() {
        return (this.shareMode & DELETE.intValue()) != 0;
    }

    public static final SharingMode fromInt(int mode) {
        SharingMode shrMode = INVALID;
        switch (mode) {
            case 0: {
                shrMode = NOSHARING;
                break;
            }
            case 1: {
                shrMode = READ;
                break;
            }
            case 2: {
                shrMode = WRITE;
                break;
            }
            case 3: {
                shrMode = READ_WRITE;
                break;
            }
            case 4: {
                shrMode = DELETE;
                break;
            }
            case 5: {
                shrMode = READ_DELETE;
                break;
            }
            case 6: {
                shrMode = WRITE_DELETE;
                break;
            }
            case 7: {
                shrMode = ALL;
            }
        }
        return shrMode;
    }
}

