/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.Srvsvc;
import org.filesys.smb.dcerpc.info.ServerInfo;
import org.filesys.smb.dcerpc.info.ShareInfo;
import org.filesys.smb.dcerpc.info.ShareInfoList;
import org.filesys.smb.dcerpc.server.DCEHandler;
import org.filesys.smb.dcerpc.server.DCEPipeFile;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class SrvsvcDCEHandler
implements DCEHandler {
    @Override
    public void processRequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int opNum = inBuf.getHeaderValue(9);
        try {
            inBuf.skipBytes(24);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("DCE/RPC SrvSvc request=" + Srvsvc.getOpcodeName(opNum));
        }
        DCEBuffer outBuf = new DCEBuffer();
        outBuf.putResponseHeader(inBuf.getHeaderValue(7), 0);
        boolean processed = false;
        switch (opNum) {
            case 15: {
                processed = this.netShareEnum(sess, inBuf, outBuf);
                break;
            }
            case 36: {
                processed = this.netShareEnum(sess, inBuf, outBuf);
                break;
            }
            case 16: {
                processed = this.netShareGetInfo(sess, inBuf, outBuf);
                break;
            }
            case 21: {
                processed = this.netServerGetInfo(sess, inBuf, outBuf);
                break;
            }
        }
        if (!processed) {
            throw new SMBSrvException(-1073741637);
        }
        outBuf.setHeaderValue(8, outBuf.getLength());
        pipeFile.setBufferedData(outBuf);
    }

    protected final boolean netShareEnum(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        ShareInfoList shrInfo = null;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString();
            shrInfo = new ShareInfoList(inBuf);
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("NetShareEnum srvName=" + srvName + ", shrInfo=" + shrInfo.toString());
        }
        SharedDeviceList shareList = sess.getServer().getShareMapper().getShareList(srvName, sess, false);
        if (sess.getServer().hasAccessControlManager()) {
            AccessControlManager aclMgr = sess.getServer().getAccessControlManager();
            shareList = aclMgr.filterShareList(sess, shareList);
        }
        ArrayList<Object> infoList = new ArrayList<Object>();
        Enumeration<SharedDevice> enm = shareList.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice share = enm.nextElement();
            int shrTyp = 0;
            if (share.getType() == ShareType.PRINTER) {
                shrTyp = 1;
            } else if (share.getType() == ShareType.NAMEDPIPE) {
                shrTyp = 3;
            } else if (share.getType() == ShareType.ADMINPIPE) {
                shrTyp = -2147483645;
            }
            ShareInfo info = new ShareInfo(shrInfo.getInformationLevel(), share.getName(), shrTyp, share.getComment());
            infoList.add(info);
            switch (shrInfo.getInformationLevel()) {
                case 2: {
                    if (share.getContext() == null) break;
                    info.setPath(share.getContext().getDeviceName());
                    break;
                }
                case 502: {
                    if (share.getContext() == null) break;
                    info.setPath(share.getContext().getDeviceName());
                }
            }
        }
        shrInfo.setShareList(infoList);
        try {
            shrInfo.writeList(outBuf);
            outBuf.putInt(0);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return true;
    }

    protected final boolean netShareGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        String shrName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            shrName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("netShareGetInfo srvname=" + srvName + ", share=" + shrName + ", infoLevel=" + infoLevel);
        }
        SharedDevice share = null;
        try {
            share = sess.getServer().findShare(srvName, shrName, ShareType.UNKNOWN, sess, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (share == null) {
            return false;
        }
        int shrTyp = 0;
        if (share.getType() == ShareType.PRINTER) {
            shrTyp = 1;
        } else if (share.getType() == ShareType.NAMEDPIPE) {
            shrTyp = 3;
        } else if (share.getType() == ShareType.ADMINPIPE) {
            shrTyp = -2147483645;
        }
        ShareInfo shrInfo = new ShareInfo(infoLevel, share.getName(), shrTyp, share.getComment());
        outBuf.putInt(infoLevel);
        outBuf.putPointer(true);
        shrInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }

    protected final boolean netServerGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("netServerGetInfo srvname=" + srvName + ", infoLevel=" + infoLevel);
        }
        ServerInfo srvInfo = new ServerInfo(infoLevel);
        SMBServer srv = sess.getSMBServer();
        srvInfo.setServerName(srv.getServerName());
        srvInfo.setComment(srv.getComment());
        srvInfo.setServerType(srv.getServerType());
        SMBConfigSection smbConfig = srv.getSMBConfiguration();
        if (smbConfig != null && smbConfig.getEnabledDialects().hasDialect(7)) {
            srvInfo.setPlatformId(500);
            srvInfo.setVersion(5, 1);
        } else {
            srvInfo.setPlatformId(400);
            srvInfo.setVersion(4, 0);
        }
        srvInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }
}

