/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.server;

import java.io.IOException;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.Wkssvc;
import org.filesys.smb.dcerpc.info.WorkstationInfo;
import org.filesys.smb.dcerpc.server.DCEHandler;
import org.filesys.smb.dcerpc.server.DCEPipeFile;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class WkssvcDCEHandler
implements DCEHandler {
    @Override
    public void processRequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int opNum = inBuf.getHeaderValue(9);
        try {
            inBuf.skipBytes(24);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("DCE/RPC WksSvc request=" + Wkssvc.getOpcodeName(opNum));
        }
        DCEBuffer outBuf = new DCEBuffer();
        outBuf.putResponseHeader(inBuf.getHeaderValue(7), 0);
        boolean processed = false;
        switch (opNum) {
            case 0: {
                processed = this.netWkstaGetInfo(sess, inBuf, outBuf);
                break;
            }
        }
        if (!processed) {
            throw new SMBSrvException(-1073741637);
        }
        outBuf.setHeaderValue(8, outBuf.getLength());
        pipeFile.setBufferedData(outBuf);
    }

    protected final boolean netWkstaGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.DCERPC)) {
            sess.debugPrintln("NetWkstaGetInfo srvName=" + srvName + ", infoLevel=" + infoLevel);
        }
        WorkstationInfo wkstaInfo = new WorkstationInfo(infoLevel);
        SMBServer srv = sess.getSMBServer();
        wkstaInfo.setWorkstationName(srv.getServerName());
        wkstaInfo.setDomain(srv.getSMBConfiguration().getDomainName());
        SMBConfigSection smbConfig = sess.getSMBServer().getSMBConfiguration();
        if (smbConfig != null && smbConfig.getEnabledDialects().hasDialect(7)) {
            wkstaInfo.setPlatformId(500);
            wkstaInfo.setVersion(5, 1);
        } else {
            wkstaInfo.setPlatformId(400);
            wkstaInfo.setVersion(4, 0);
        }
        wkstaInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }
}

