/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.nt;

import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

public class SymLink {
    public static final int StringOffset = 20;
    private String m_substName;
    private String m_printName;

    public SymLink(DataBuffer dataBuf) {
        this.parseDataBuffer(dataBuf);
    }

    public SymLink(String substName, String printName) {
        this.m_substName = substName;
        this.m_printName = printName;
    }

    public final String getSubstituteName() {
        return this.m_substName;
    }

    public final String getPrintName() {
        return this.m_printName;
    }

    public final void parseDataBuffer(DataBuffer symlinkBuf) {
        this.m_substName = null;
        this.m_printName = null;
        if (symlinkBuf.getInt() != -1610612724) {
            return;
        }
        symlinkBuf.skipBytes(4);
        int offset = symlinkBuf.getShort();
        int len = symlinkBuf.getShort();
        this.m_substName = DataPacker.getUnicodeString(symlinkBuf.getBuffer(), 20 + offset, len / 2);
        offset = symlinkBuf.getShort();
        len = symlinkBuf.getShort();
        this.m_printName = DataPacker.getUnicodeString(symlinkBuf.getBuffer(), 20 + offset, len / 2);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[SymLink subst=");
        str.append(this.getSubstituteName());
        str.append(",print=");
        str.append(this.getPrintName());
        str.append("]");
        return str.toString();
    }
}

