/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import org.filesys.debug.Debug;
import org.filesys.server.SocketSessionHandler;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.smb.mailslot.TcpipNetBIOSHostAnnouncer;
import org.filesys.smb.server.NetBIOSPacketHandler;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvSession;

public class NetBIOSSessionSocketHandler
extends SocketSessionHandler {
    private static final ThreadGroup NetBIOSGroup = new ThreadGroup("NetBIOSSessions");

    public NetBIOSSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("NetBIOS", "SMB", srv, bindAddr, port);
        this.setDebug(debug);
    }

    @Override
    protected void acceptConnection(Socket sock) {
        block3: {
            try {
                sock.setSoTimeout(this.getSocketTimeout());
                SMBServer smbServer = (SMBServer)this.getServer();
                NetBIOSPacketHandler pktHandler = new NetBIOSPacketHandler(sock, smbServer.getPacketPool());
                SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                if (this.hasDebug()) {
                    Debug.println("[SMB] Created session " + srvSess.getUniqueId());
                }
                Thread srvThread = new Thread(NetBIOSGroup, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_N" + srvSess.getSessionId() + "_" + sock.getInetAddress().getHostAddress());
                srvThread.start();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block3;
                Debug.println("[SMB] NetBIOS Failed to create session, " + ex.toString());
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        SMBConfigSection smbConfig = (SMBConfigSection)config.getConfigSection("SMB");
        NetBIOSSessionSocketHandler sessHandler = new NetBIOSSessionSocketHandler(server, smbConfig.getSessionPort(), smbConfig.getSMBBindAddress(), sockDbg);
        sessHandler.setSocketTimeout(smbConfig.getSocketTimeout());
        sessHandler.initializeSessionHandler(server);
        Thread nbThread = new Thread(sessHandler);
        nbThread.setName("NetBIOS_Handler");
        nbThread.start();
        if (sockDbg) {
            Debug.println("[SMB] TCP NetBIOS session handler created");
        }
        if (smbConfig.hasEnableAnnouncer()) {
            TcpipNetBIOSHostAnnouncer announcer = new TcpipNetBIOSHostAnnouncer();
            announcer.addHostName(smbConfig.getServerName());
            announcer.setDomain(smbConfig.getDomainName());
            announcer.setComment(smbConfig.getComment());
            announcer.setBindAddress(smbConfig.getSMBBindAddress());
            if (smbConfig.getHostAnnouncerPort() != 0) {
                announcer.setPort(smbConfig.getHostAnnouncerPort());
            }
            if (smbConfig.hasAliasNames()) {
                announcer.addHostNames(smbConfig.getAliasNames());
            }
            if (smbConfig.getHostAnnounceInterval() > 0) {
                announcer.setInterval(smbConfig.getHostAnnounceInterval());
            }
            try {
                announcer.setBroadcastAddress(smbConfig.getBroadcastMask());
            }
            catch (Exception exception) {
                // empty catch block
            }
            announcer.setServerType(smbConfig.getServerType());
            if (smbConfig.hasHostAnnounceDebug()) {
                announcer.setDebug(true);
            }
            announcer.start();
            if (sockDbg) {
                Debug.println("[SMB] TCP NetBIOS host announcer created");
            }
        }
    }
}

