/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.filesys.debug.Debug;
import org.filesys.netbios.NetBIOSException;
import org.filesys.netbios.NetBIOSSession;
import org.filesys.netbios.RFCNetBIOSProtocol;
import org.filesys.server.SrvSession;
import org.filesys.server.SrvSessionList;
import org.filesys.server.auth.AuthenticatorException;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.filesys.DeferredPacketException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyChange;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.postprocess.PostRequestProcessor;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.smb.Dialect;
import org.filesys.smb.DialectSelector;
import org.filesys.smb.SMBErrorText;
import org.filesys.smb.server.DefaultSrvSessionFactory;
import org.filesys.smb.server.NegotiateContext;
import org.filesys.smb.server.PacketHandler;
import org.filesys.smb.server.Protocol;
import org.filesys.smb.server.ProtocolFactory;
import org.filesys.smb.server.ProtocolHandler;
import org.filesys.smb.server.SMBPacketPool;
import org.filesys.smb.server.SMBParser;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBThreadRequest;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.SessionState;
import org.filesys.smb.server.SetupObjectType;
import org.filesys.smb.server.SrvSessionFactory;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.VirtualCircuitList;
import org.filesys.smb.server.notify.NotifyRequest;
import org.filesys.smb.server.notify.NotifyRequestList;
import org.filesys.util.HexDump;
import org.filesys.util.StringList;

public class SMBSrvSession
extends SrvSession<Dbg>
implements Runnable {
    public static final int DefaultBufferSize = 65540;
    public static final int LanManBufferSize = 8192;
    public static final int LanManMaxMultiplexed = 1;
    public static final int NTMaxMultiplexed = 4;
    private static final int MaxVirtualCircuits = 0;
    private static SrvSessionFactory m_factory = new DefaultSrvSessionFactory();
    private PacketHandler m_pktHandler;
    private ProtocolHandler m_handler;
    private SessionState m_state = SessionState.NETBIOS_SESS_REQUEST;
    private NotifyRequestList m_notifyList;
    private boolean m_notifyPending;
    private Queue<SMBSrvPacket> m_asynchQueue;
    private int m_maxBufSize;
    private int m_maxMultiplex;
    private int m_maxVC;
    private int m_clientCaps;
    private VirtualCircuitList m_vcircuits;
    private Hashtable<Integer, EnumMap<SetupObjectType, Object>> m_setupObjects;
    private boolean m_asyncRead;
    private HashMap<String, Object> m_sessionKeys;

    protected SMBSrvSession(PacketHandler handler, SMBServer srv, int maxVC) {
        super(-1, srv, handler.isProtocolName(), null, Dbg.class);
        this.m_pktHandler = handler;
        if (this.isProtocol() == Protocol.TCPIP || this.isProtocol() == Protocol.Win32NetBIOS) {
            this.setState(SessionState.SMB_NEGOTIATE);
        }
        this.setMaximumVirtualCircuits(maxVC);
    }

    public final Protocol isProtocol() {
        return this.m_pktHandler.isProtocol();
    }

    public final TreeConnection findTreeConnection(SMBSrvPacket smbPkt) {
        SMBV1Parser parser;
        VirtualCircuit vc;
        TreeConnection tree = null;
        if (smbPkt.isSMB1() && (vc = this.findVirtualCircuit((parser = (SMBV1Parser)smbPkt.getParser()).getUserId())) != null) {
            tree = vc.findConnection(parser.getTreeId());
        }
        return tree;
    }

    public final synchronized VirtualCircuit createVirtualCircuit(int vcNum, ClientInfo client) {
        if (this.m_vcircuits == null) {
            if (this.m_handler != null) {
                this.m_vcircuits = this.m_handler.createVirtualCircuitList(this.getMaximumVirtualCircuits());
            } else {
                return null;
            }
        }
        return this.m_vcircuits.createVirtualCircuit(vcNum, client);
    }

    public final synchronized int addVirtualCircuit(VirtualCircuit vc) {
        if (vc == null) {
            return -1;
        }
        if (this.m_vcircuits == null) {
            if (this.m_handler != null) {
                this.m_vcircuits = this.m_handler.createVirtualCircuitList(this.getMaximumVirtualCircuits());
            } else {
                return -1;
            }
        }
        return this.m_vcircuits.addCircuit(vc);
    }

    public final VirtualCircuit findVirtualCircuit(int id) {
        VirtualCircuit vc;
        if (this.m_vcircuits == null) {
            if (this.m_handler != null) {
                this.m_vcircuits = this.m_handler.createVirtualCircuitList(this.getMaximumVirtualCircuits());
            } else {
                return null;
            }
        }
        if ((vc = this.m_vcircuits.findCircuit(id)) != null) {
            this.setClientInformation(vc.getClientInformation());
            this.getSMBServer().getSMBAuthenticator().setCurrentUser(this.getClientInformation());
        }
        return vc;
    }

    public final void removeVirtualCircuit(int id) {
        if (this.m_vcircuits != null) {
            this.m_vcircuits.removeCircuit(id, this);
        }
    }

    public final int numberOfVirtualCircuits() {
        return this.m_vcircuits != null ? this.m_vcircuits.getCircuitCount() : 0;
    }

    protected final VirtualCircuitList getVirtualCircuitList() {
        return this.m_vcircuits;
    }

    protected final void clearVirtualCircuitList() {
        if (this.m_vcircuits != null) {
            this.m_vcircuits = null;
        }
    }

    protected final void cleanupSession() {
        try {
            if (this.m_vcircuits != null) {
                if (this.hasDebug(Dbg.STATE)) {
                    this.debugPrintln("Cleanup session, vcircuits=" + this.m_vcircuits.getCircuitCount() + ", changeNotify=" + this.getNotifyChangeCount());
                }
                this.m_vcircuits.clearCircuitList(this);
            } else if (this.hasDebug(Dbg.STATE)) {
                this.debugPrintln("Cleanup session, vcircuits=null, changeNotify=" + this.getNotifyChangeCount());
            }
            if (this.m_notifyList != null && this.m_notifyList.numberOfRequests() > 0) {
                for (int i = 0; i < this.m_notifyList.numberOfRequests(); ++i) {
                    NotifyRequest curReq = this.m_notifyList.getRequest(i);
                    if (!curReq.getDiskContext().hasChangeHandler()) continue;
                    curReq.getDiskContext().getChangeHandler().removeNotifyRequests(this);
                }
            }
            this.getSMBServer().deleteTemporaryShares(this);
        }
        finally {
            if (this.hasTransaction()) {
                this.endTransaction();
            }
        }
    }

    protected final void closeSocket() {
        this.setShutdown(true);
        try {
            this.m_pktHandler.closeHandler();
            if (this.hasDebug(Dbg.STATE)) {
                this.debugPrintln("Closed packet handler for client: " + this.m_pktHandler.getClientName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void closeSession() {
        block5: {
            if (!this.isPersistentSession() || this.getSMBServer().hasShutdown()) {
                this.cleanupSession();
                super.closeSession();
            } else {
                this.getSMBServer().findActiveSession(this.getSessionId());
                this.getSMBServer().addDisconnectedSession(this);
                if (this.hasDebug(Dbg.STATE)) {
                    this.debugPrintln("[SMB] Add session to disconnected session list, sessId=" + this.getSessionId() + "/" + this.getUniqueId());
                }
                this.cleanupSession();
            }
            try {
                this.setState(SessionState.NETBIOS_HANGUP);
                this.closeSocket();
            }
            catch (Exception ex) {
                if (!this.hasDebug(Dbg.STATE)) break block5;
                this.debugPrintln("[SMB] Error during close session, " + this.getUniqueId() + ", addr=" + this.getRemoteAddress().getHostAddress());
                this.debugPrintln(ex);
            }
        }
    }

    public void finalize() {
        this.cleanupSession();
        this.closeSocket();
    }

    public final int getNotifyChangeCount() {
        if (this.m_notifyList == null) {
            return 0;
        }
        return this.m_notifyList.numberOfRequests();
    }

    public final int getClientMaximumBufferSize() {
        return this.m_maxBufSize;
    }

    public final int getClientMaximumMultiplex() {
        return this.m_maxMultiplex;
    }

    public final int getClientCapabilities() {
        return this.m_clientCaps;
    }

    public final boolean hasClientCapability(int cap) {
        return (this.m_clientCaps & cap) != 0;
    }

    public final PacketHandler getPacketHandler() {
        return this.m_pktHandler;
    }

    public final ProtocolHandler getProtocolHandler() {
        return this.m_handler;
    }

    protected final void clearPacketHandler() {
        this.m_pktHandler = null;
    }

    public final SMBPacketPool getPacketPool() {
        return this.m_pktHandler.getPacketPool();
    }

    public final ThreadRequestPool getThreadPool() {
        return this.getSMBServer().getThreadPool();
    }

    public final boolean hasRemoteAddress() {
        return this.m_pktHandler.hasRemoteAddress();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.m_pktHandler.getRemoteAddress();
    }

    public final String getRemoteAddressString() {
        if (this.m_pktHandler != null) {
            return this.m_pktHandler.getRemoteAddress().getHostAddress();
        }
        return "Unknown";
    }

    public final SMBServer getSMBServer() {
        return (SMBServer)this.getServer();
    }

    public final String getServerName() {
        return this.getSMBServer().getServerName();
    }

    public final SessionState getState() {
        return this.m_state;
    }

    public final int getMaximumVirtualCircuits() {
        return this.m_vcircuits != null ? this.m_vcircuits.getMaximumVirtualCircuits() : 0;
    }

    public final synchronized boolean hasSessionKeys() {
        return this.m_sessionKeys != null;
    }

    public final synchronized boolean hasSessionKey(String key) {
        if (this.m_sessionKeys == null) {
            return false;
        }
        return this.m_sessionKeys.containsKey(key);
    }

    public final synchronized Object getSessionKey(String key) {
        if (this.m_sessionKeys == null) {
            return null;
        }
        return this.m_sessionKeys.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void addSessionKey(String key, Object val) {
        if (this.m_sessionKeys == null) {
            SMBSrvSession sMBSrvSession = this;
            synchronized (sMBSrvSession) {
                if (this.m_sessionKeys == null) {
                    this.m_sessionKeys = new HashMap();
                }
            }
        }
        this.m_sessionKeys.put(key, val);
    }

    public final synchronized Object removeSessionKey(String key) {
        if (this.m_sessionKeys != null) {
            return this.m_sessionKeys.remove(key);
        }
        return null;
    }

    public synchronized void removeAllSessionKeys() {
        if (this.m_sessionKeys != null) {
            this.m_sessionKeys.clear();
            this.m_sessionKeys = null;
        }
    }

    public void hangupSession(String reason) {
        if (this.hasDebug(Dbg.STATE)) {
            this.debugPrint("## Session closing, reason=" + reason);
            this.debugPrintln(reason);
        }
        if (this.getProtocolHandler() != null) {
            this.getProtocolHandler().hangupSession(this, reason);
        }
        this.setState(SessionState.NETBIOS_HANGUP);
    }

    public final boolean hasMacintoshExtensions() {
        return this.getSMBServer().getSMBConfiguration().hasMacintoshExtensions();
    }

    public final boolean hasNotifyPending() {
        return this.m_notifyPending;
    }

    public final synchronized boolean hasSetupObject(int pid, SetupObjectType typ) {
        if (this.m_setupObjects == null) {
            return false;
        }
        EnumMap<SetupObjectType, Object> setupMap = this.m_setupObjects.get(pid);
        if (setupMap == null) {
            return false;
        }
        return setupMap.containsKey((Object)typ);
    }

    public final synchronized Object getSetupObject(int pid, SetupObjectType typ) {
        if (this.m_setupObjects == null) {
            return null;
        }
        EnumMap<SetupObjectType, Object> setupMap = this.m_setupObjects.get(pid);
        if (setupMap == null) {
            return null;
        }
        return setupMap.get((Object)typ);
    }

    public final synchronized void setSetupObject(int pid, Object obj, SetupObjectType typ) {
        EnumMap<SetupObjectType, Object> setupMap = null;
        if (this.m_setupObjects == null) {
            this.m_setupObjects = new Hashtable();
        } else {
            setupMap = this.m_setupObjects.get(pid);
        }
        if (setupMap == null) {
            setupMap = new EnumMap(SetupObjectType.class);
            this.m_setupObjects.put(pid, setupMap);
        }
        setupMap.put(typ, obj);
    }

    public final synchronized Object removeSetupObject(int pid, SetupObjectType typ) {
        if (this.m_setupObjects == null) {
            return null;
        }
        EnumMap<SetupObjectType, Object> setupMap = this.m_setupObjects.get(pid);
        if (setupMap == null) {
            return null;
        }
        Object setupObj = setupMap.remove((Object)typ);
        if (setupMap.isEmpty()) {
            this.m_setupObjects.remove(pid);
        }
        return setupObj;
    }

    public final synchronized void removeAllSetupObjects(int pid) {
        if (this.m_setupObjects == null) {
            return;
        }
        this.m_setupObjects.remove(pid);
    }

    public final void setNotifyPending(boolean pend) {
        this.m_notifyPending = pend;
    }

    public final void setClientMaximumBufferSize(int maxBuf) {
        this.m_maxBufSize = maxBuf;
    }

    public final void setClientMaximumMultiplex(int maxMpx) {
        this.m_maxMultiplex = maxMpx;
    }

    public final void setClientCapabilities(int flags) {
        this.m_clientCaps = flags;
    }

    public final void setServerCapabilities(int srvCapab) {
        this.m_handler.setServerCapabilities(srvCapab);
    }

    public void setState(SessionState state) {
        if (this.hasDebug(Dbg.STATE)) {
            this.debugPrintln("State changed to " + state.name());
        }
        this.m_state = state;
    }

    public final void setMaximumVirtualCircuits(int maxVC) {
        this.m_maxVC = maxVC;
    }

    protected void procNetBIOSSessionRequest(SMBSrvPacket smbPkt) throws IOException, NetBIOSException {
        if (smbPkt.getReceivedLength() < 72 || smbPkt.getHeaderType() != RFCNetBIOSProtocol.MsgType.REQUEST) {
            if (this.hasDebug(Dbg.STATE)) {
                Debug.println("NBREQ invalid packet len=" + smbPkt.getReceivedLength() + ", header=0x" + Integer.toHexString(smbPkt.getHeaderType().intValue()));
                HexDump.Dump(smbPkt.getBuffer(), smbPkt.getReceivedLength(), 0, Debug.getDebugInterface());
            }
            throw new NetBIOSException("NBREQ Invalid packet len=" + smbPkt.getReceivedLength());
        }
        byte[] buf = smbPkt.getBuffer();
        if (buf[4] != 32 || buf[38] != 32) {
            throw new NetBIOSException("NBREQ Invalid NetBIOS name data");
        }
        StringBuffer nbName = new StringBuffer(32);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)buf[5 + i]);
        }
        String toName = NetBIOSSession.DecodeName(nbName.toString());
        toName = toName.trim();
        nbName.setLength(0);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)buf[39 + i]);
        }
        String fromName = NetBIOSSession.DecodeName(nbName.toString());
        fromName = fromName.trim();
        if (this.hasDebug(Dbg.STATE)) {
            this.debugPrintln("NetBIOS CALL From " + fromName + " to " + toName);
        }
        boolean forThisServer = false;
        if (toName.compareTo(this.getServerName()) == 0 || toName.compareTo("*SMBSERVER") == 0 || toName.compareTo("*SMBSERV") == 0 || toName.compareTo("*") == 0) {
            forThisServer = true;
        } else if (this.getSMBServer().getSMBConfiguration().hasAliasNames()) {
            StringList aliasNames = this.getSMBServer().getSMBConfiguration().getAliasNames();
            if (aliasNames.containsString(toName)) {
                forThisServer = true;
            }
        } else {
            InetAddress[] srvAddr = this.getSMBServer().getServerAddresses();
            if (srvAddr != null) {
                int idx = 0;
                while (idx < srvAddr.length && !forThisServer) {
                    if (srvAddr[idx++].getHostAddress().compareTo(toName) != 0) continue;
                    forThisServer = true;
                }
            }
        }
        if (!forThisServer) {
            throw new NetBIOSException("NBREQ Called name is not this server (" + toName + ")");
        }
        if (this.hasDebug(Dbg.STATE)) {
            this.debugPrintln("NetBIOS session request from " + fromName);
        }
        this.setState(SessionState.SMB_NEGOTIATE);
        this.setRemoteName(fromName);
        smbPkt.setHeaderType(RFCNetBIOSProtocol.MsgType.ACK);
        smbPkt.setHeaderFlags(0);
        smbPkt.setHeaderLength(0);
        this.m_pktHandler.writePacket(smbPkt, 4, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void procSMBNegotiate(SMBSrvPacket smbPkt) throws SMBSrvException, IOException {
        byte[] buf = smbPkt.getBuffer();
        buf[0] = (byte)RFCNetBIOSProtocol.MsgType.MESSAGE.intValue();
        NegotiateContext negCtx = null;
        try {
            if (smbPkt.getParser() == null) {
                this.setState(SessionState.NETBIOS_HANGUP);
                if (!this.hasDebug(Dbg.NEGOTIATE)) return;
                this.debugPrintln("Failed to get parser for received negotiate");
                return;
            }
            negCtx = smbPkt.getParser().parseNegotiateRequest(this);
            if (this.hasDebug(Dbg.NEGOTIATE)) {
                this.debugPrintln("Negotiate context: " + negCtx);
            }
        }
        catch (SMBSrvException ex) {
            this.sendErrorResponseSMB(smbPkt, ex.getNTErrorCode(), ex.getErrorCode(), ex.getErrorClass());
            this.setState(SessionState.NETBIOS_HANGUP);
            return;
        }
        DialectSelector diaSelector = this.getSMBServer().getSMBConfiguration().getEnabledDialects();
        int diaIdx = diaSelector.findHighestDialect(negCtx.getDialects());
        if (this.hasDebug(Dbg.NEGOTIATE)) {
            if (diaIdx == -1) {
                this.debugPrintln("Failed to negotiate SMB dialect");
            } else {
                this.debugPrintln("Negotiated SMB dialect - " + Dialect.DialectTypeString(diaIdx));
            }
        }
        try {
            block18: {
                SMBSrvPacket respPkt;
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                respPkt = null;
                                if (diaIdx == -1) break block14;
                                this.m_handler = ProtocolFactory.getHandler(diaIdx);
                                if (this.m_handler == null) break block15;
                                if (this.hasDebug(Dbg.NEGOTIATE)) {
                                    this.debugPrintln("Assigned protocol handler - " + this.m_handler.getClass().getName());
                                }
                                this.m_handler.initialize(this.getSMBServer(), this, diaIdx);
                                this.setDebugPrefix("[" + this.getPacketHandler().getShortName() + this.getSessionId() + ":" + Dialect.getMajorSMBVersion(diaIdx) + "] ");
                                respPkt = this.m_handler.postProcessNegotiate(smbPkt, negCtx);
                                respPkt.getParser().packNegotiateResponse(this.getSMBServer(), this, respPkt, diaIdx, negCtx);
                                this.m_pktHandler.writePacket(respPkt, respPkt.getLength());
                                if (diaIdx != -1) break block16;
                                break block17;
                            }
                            diaIdx = -1;
                            if (this.hasDebug(Dbg.NEGOTIATE)) {
                                this.debugPrintln("No protocol handler for dialect - " + Dialect.DialectTypeString(diaIdx));
                            }
                            this.sendErrorResponseSMB(smbPkt, -1073741811, 65535, 2);
                            return;
                        }
                        if (this.hasDebug(Dbg.NEGOTIATE)) {
                            this.debugPrintln("No common dialect between client and server");
                        }
                        this.sendErrorResponseSMB(smbPkt, -1073741811, 65535, 2);
                        this.setState(SessionState.NETBIOS_HANGUP);
                        return;
                    }
                    this.setState(SessionState.NETBIOS_HANGUP);
                    break block18;
                }
                this.setState(respPkt.getParser().nextStateForDialect(diaIdx));
            }
            if (diaIdx == -1) return;
            this.getSMBServer().sessionOpened(this);
            return;
        }
        catch (AuthenticatorException ex) {
            if (this.hasDebug(Dbg.NEGOTIATE)) {
                this.debugPrintln("Negotiate error - " + ex.getMessage());
            }
            this.setState(SessionState.NETBIOS_HANGUP);
            return;
        }
        catch (SMBSrvException ex) {
            smbPkt.getParser().buildErrorResponse(6, ex.getNTErrorCode(), this.getProtocolHandler());
            this.m_pktHandler.writePacket(smbPkt, smbPkt.getLength());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        SMBSrvPacket smbPkt = null;
        try {
            if (this.hasDebug(Dbg.NEGOTIATE)) {
                this.debugPrintln("Server session started");
            }
            while (this.m_state != SessionState.NETBIOS_HANGUP) {
                try {
                    smbPkt = this.m_pktHandler.readPacket();
                }
                catch (SocketTimeoutException ex) {
                    if (this.hasDebug(Dbg.SOCKET)) {
                        this.debugPrintln("Socket read timed out, closing session");
                    }
                    this.hangupSession("Socket read timeout");
                    smbPkt = null;
                }
                catch (IOException ex) {
                    this.hangupSession("Remote disconnect: " + ex.toString());
                    smbPkt = null;
                }
                if (smbPkt == null) continue;
                if (this.m_state != SessionState.NETBIOS_SESS_REQUEST && !smbPkt.isSMB()) {
                    if (!this.hasDebug(Dbg.ERROR)) continue;
                    this.debugPrintln("Invalid SMB packet signature received, packet ignored");
                    continue;
                }
                this.getThreadPool().queueRequest(new SMBThreadRequest(this, smbPkt));
                smbPkt = null;
            }
            this.closeSession();
            if (this.hasDebug(Dbg.STATE)) {
                this.debugPrintln("[SMB] Closed session, " + this.getUniqueId() + ", addr=" + this.getRemoteAddress().getHostAddress());
            }
            this.getSMBServer().sessionClosed(this);
            if (this.hasClientInformation()) {
                this.getSMBServer().getSMBAuthenticator().setCurrentUser(null);
            }
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
        }
        catch (Exception ex) {
            if (!this.isShutdown()) {
                this.debugPrintln("Closing session due to exception");
                this.debugPrintln(ex);
                Debug.println(ex);
            }
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
        }
        catch (Throwable ex2) {
            this.debugPrintln("Closing session due to throwable");
            this.debugPrintln(ex2.toString());
            Debug.println(ex2);
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
            {
                catch (Throwable throwable) {
                    if (smbPkt != null) {
                        this.getSMBServer().getPacketPool().releasePacket(smbPkt);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runHandler(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        SMBSrvPacket asynchPkt;
        if (this.hasDebug(Dbg.PKTTYPE)) {
            this.debugPrintln("Rx packet - " + smbPkt.getParser().toShortString());
        }
        if (!this.m_handler.runProtocol(smbPkt)) {
            this.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
        if (this.hasTransaction()) {
            this.endTransaction();
        }
        while ((asynchPkt = this.removeFirstAsynchResponse()) != null) {
            this.sendResponseSMB(asynchPkt, asynchPkt.getLength());
            if (!this.hasDebug(Dbg.NOTIFY)) continue;
            this.debugPrintln("Sent queued asynch response type=" + smbPkt.getParser().toShortString());
            SMBSrvSession sMBSrvSession = this;
            synchronized (sMBSrvSession) {
                this.debugPrintln("  Async queue len=" + this.m_asynchQueue.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processPacket(SMBSrvPacket smbPkt) {
        if (smbPkt != null) {
            try {
                block35: {
                    long startTime = 0L;
                    long endTime = 0L;
                    if (this.hasDebug(Dbg.TIMING)) {
                        startTime = System.currentTimeMillis();
                    }
                    if (this.hasDebug(Dbg.RXDATA)) {
                        this.debugPrintln("Rx Data len=" + smbPkt.getReceivedLength());
                        HexDump.Dump(smbPkt.getBuffer(), smbPkt.getReceivedLength(), 0, Debug.getDebugInterface());
                    }
                    if (smbPkt.getReceivedLength() > 0) {
                        switch (this.m_state) {
                            case NETBIOS_SESS_REQUEST: {
                                this.procNetBIOSSessionRequest(smbPkt);
                                break;
                            }
                            case SMB_NEGOTIATE: {
                                this.procSMBNegotiate(smbPkt);
                                break;
                            }
                            case SMB_SESSSETUP: {
                                this.m_handler.runProtocol(smbPkt);
                                break;
                            }
                            case SMB_SESSION: {
                                long duration;
                                this.runHandler(smbPkt);
                                if (!this.hasDebug(Dbg.TIMING) || (duration = (endTime = System.currentTimeMillis()) - startTime) <= 20L) break;
                                this.debugPrintln("Processed packet " + smbPkt.getParser().toShortString());
                            }
                        }
                    }
                    PostRequestProcessor postProcessor = null;
                    if (smbPkt != null && smbPkt.getParser() != null && smbPkt.getParser().hasPostProcessor()) {
                        postProcessor = smbPkt.getParser().getPostProcessor();
                    }
                    this.getPacketPool().releasePacket(smbPkt);
                    smbPkt = null;
                    if (postProcessor != null) {
                        try {
                            if (this.hasDebug(Dbg.TIMING)) {
                                startTime = System.currentTimeMillis();
                            }
                            postProcessor.runPostProcessor();
                            if (this.hasDebug(Dbg.TIMING)) {
                                long duration = System.currentTimeMillis() - startTime;
                                this.debugPrintln("Post processor (" + postProcessor.getClass().getSimpleName() + ") took " + duration + "ms");
                            }
                        }
                        catch (IOException ex) {
                            if (!this.hasDebug(Dbg.ERROR)) break block35;
                            Debug.println("[SMB] Error from post processor (" + postProcessor.getClass().getSimpleName() + "): " + ex);
                        }
                    }
                }
                if (this.hasDebug(Dbg.PKTSTATS)) {
                    Debug.println("[SMB] Packet pool stats: " + this.getPacketPool());
                }
            }
            catch (DeferredPacketException ex) {
                smbPkt = null;
            }
            catch (SocketException ex) {
                if (this.hasDebug(Dbg.STATE)) {
                    this.debugPrintln("Socket closed by remote client");
                }
            }
            catch (Exception ex) {
                if (!this.isShutdown()) {
                    this.debugPrintln("Closing session due to exception");
                    this.debugPrintln(ex);
                    Debug.println(ex);
                }
            }
            catch (Throwable ex) {
                this.debugPrintln("Closing session due to throwable");
                this.debugPrintln(ex.toString());
                Debug.println(ex);
            }
            finally {
                if (smbPkt != null) {
                    this.getSMBServer().getPacketPool().releasePacket(smbPkt);
                }
            }
        }
        if (this.hasTransaction()) {
            this.debugPrintln("** Active transaction after packet processing, cleaning up **");
            this.endTransaction();
        }
        if (this.m_state == SessionState.NETBIOS_HANGUP && !this.isPersistentSession()) {
            this.cleanupSession();
            if (this.hasDebug(Dbg.STATE)) {
                this.debugPrintln("Server session closed");
            }
            this.closeSocket();
            this.getSMBServer().sessionClosed(this);
        }
        if (this.hasClientInformation()) {
            this.getSMBServer().getSMBAuthenticator().setCurrentUser(null);
        }
    }

    public final void sendResponseSMB(SMBSrvPacket pkt) throws IOException {
        this.sendResponseSMB(pkt, pkt.getLength());
    }

    public final synchronized void sendResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        if (this.hasTransaction()) {
            long elapsedTime;
            long startTime = 0L;
            if (this.hasDebug(Dbg.BENCHMARK)) {
                startTime = System.currentTimeMillis();
            }
            this.endTransaction();
            if (this.hasDebug(Dbg.BENCHMARK) && (elapsedTime = System.currentTimeMillis() - startTime) > 5L) {
                Debug.println("Benchmark: End transaction took " + elapsedTime + "ms");
            }
        }
        pkt.getParser().responsePreSend(this, pkt);
        this.m_pktHandler.writePacket(pkt, len);
        this.m_pktHandler.flushPacket();
        if (this.hasDebug(Dbg.TXDATA)) {
            this.debugPrintln("Tx Data len=" + len);
            HexDump.Dump(pkt.getBuffer(), len, 0, Debug.getDebugInterface());
        }
    }

    public final void sendSuccessResponseSMB(SMBSrvPacket smbPkt) throws IOException {
        SMBParser parser = smbPkt.getParser();
        parser.setResponse();
        if (parser.isLongErrorCode()) {
            parser.buildErrorResponse(6, 0, this.getProtocolHandler());
        } else {
            parser.buildErrorResponse(0, 0, this.getProtocolHandler());
        }
        this.sendResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(Dbg.TXDATA)) {
            this.debugPrintln("Tx Data len=" + smbPkt.getLength() + ", success SMB");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void sendErrorResponseSMB(SMBSrvPacket smbPkt, int ntCode, int stdCode, int stdClass) throws IOException, SMBSrvException {
        SMBParser parser = smbPkt.getParser();
        if (parser.isLongErrorCode()) {
            if (ntCode == -1) throw new SMBSrvException(5, 9);
            this.sendErrorResponseSMB(smbPkt, ntCode, 6);
            return;
        } else {
            this.sendErrorResponseSMB(smbPkt, stdCode, stdClass);
        }
    }

    public final void sendErrorResponseSMB(SMBSrvPacket smbPkt, int errCode, int errClass) throws IOException {
        SMBParser parser = smbPkt.getParser();
        parser.setResponse();
        if (parser.isLongErrorCode()) {
            parser.buildErrorResponse(6, errCode, this.getProtocolHandler());
        } else {
            parser.buildErrorResponse(errClass, errCode, this.getProtocolHandler());
        }
        this.sendResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(Dbg.ERROR)) {
            this.debugPrintln("Error : Cmd = " + smbPkt.getParser().toShortString() + " - " + SMBErrorText.ErrorString(errClass, errCode));
        }
    }

    public final void sendNTErrorResponseSMB(SMBSrvPacket smbPkt, int ntErrCode) throws IOException {
        SMBParser parser = smbPkt.getParser();
        parser.setResponse();
        parser.buildErrorResponse(6, ntErrCode, this.getProtocolHandler());
        this.sendResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(Dbg.ERROR)) {
            this.debugPrintln("Error : Cmd = " + smbPkt.getParser().toShortString() + " - " + SMBErrorText.ErrorString(6, ntErrCode));
        }
    }

    public final boolean sendAsyncErrorResponseSMB(SMBSrvPacket smbPkt, int errCode, int errClass) throws IOException {
        SMBParser parser = smbPkt.getParser();
        parser.buildErrorResponse(errClass, errCode, this.getProtocolHandler());
        boolean sentOK = this.sendAsynchResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(Dbg.ERROR)) {
            this.debugPrintln("Async Error : Cmd = " + smbPkt.getParser().toShortString() + " - " + SMBErrorText.ErrorString(errClass, errCode) + ", sent=" + sentOK);
        }
        return sentOK;
    }

    public final boolean sendAsynchResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        boolean sts = false;
        if (this.m_pktHandler.availableBytes() == 0) {
            this.sendResponseSMB(pkt, len);
            sts = true;
        } else {
            this.queueAsynchResponseSMB(pkt);
        }
        return sts;
    }

    public final synchronized void queueAsynchResponseSMB(SMBSrvPacket pkt) {
        if (this.m_asynchQueue == null) {
            this.m_asynchQueue = new LinkedList<SMBSrvPacket>();
        }
        this.m_asynchQueue.add(pkt);
    }

    protected final synchronized SMBSrvPacket removeFirstAsynchResponse() {
        if (this.m_asynchQueue == null || this.m_asynchQueue.size() == 0) {
            return null;
        }
        SMBSrvPacket pkt = this.m_asynchQueue.poll();
        return pkt;
    }

    public final synchronized boolean hasAsyncResponseQueued() {
        return this.m_asynchQueue != null && this.m_asynchQueue.size() != 0;
    }

    public final synchronized int sendQueuedAsyncResponses() {
        SMBSrvPacket asyncPkt;
        int asyncCnt = 0;
        while ((asyncPkt = this.removeFirstAsynchResponse()) != null) {
            try {
                ++asyncCnt;
                this.sendResponseSMB(asyncPkt, asyncPkt.getLength());
                if (!this.hasDebug(Dbg.NOTIFY) && !this.hasDebug(Dbg.OPLOCK)) continue;
                this.debugPrintln("Sent queued async response type=" + asyncPkt.getParser().toShortString());
                this.debugPrintln("  Async queue len=" + this.m_asynchQueue.size());
            }
            catch (Exception ex) {
                if (!this.hasDebug(Dbg.NOTIFY) && !this.hasDebug(Dbg.OPLOCK)) continue;
                this.debugPrintln("Failed to send queued asynch response type=" + asyncPkt.getParser().toShortString() + ", ex=" + ex);
            }
        }
        return asyncCnt;
    }

    public final NotifyRequest findNotifyRequest(int mid, int tid, int uid, int pid) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(mid, tid, uid, pid);
    }

    public final NotifyRequest findNotifyRequest(long mid) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(mid);
    }

    public final NotifyRequest findNotifyRequest(NetworkFile dir, Set<NotifyChange> filter, boolean watchTree) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(dir, filter, watchTree);
    }

    public final void addNotifyRequest(NotifyRequest req, DiskDeviceContext ctx) {
        if (this.m_notifyList == null) {
            this.m_notifyList = new NotifyRequestList();
        }
        this.m_notifyList.addRequest(req);
        ctx.addNotifyRequest(req);
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        if (this.m_notifyList == null) {
            return;
        }
        this.m_notifyList.removeRequest(req);
        if (req.getDiskContext() != null) {
            req.getDiskContext().removeNotifyRequest(req);
        }
    }

    public static final SrvSessionFactory getFactory() {
        return m_factory;
    }

    public static final void setFactory(SrvSessionFactory factory) {
        m_factory = factory;
    }

    public static final SMBSrvSession createSession(PacketHandler handler, SMBServer server, int sessId) {
        return m_factory.createSession(handler, server, sessId);
    }

    public final boolean hasReadInProgress() {
        return this.m_asyncRead;
    }

    public final void setReadInProgress(boolean inProgress) {
        this.m_asyncRead = inProgress;
    }

    @Override
    public boolean useCaseSensitiveSearch() {
        return false;
    }

    @Override
    public boolean isPseudoFilesEnabled() {
        return true;
    }

    public final int disconnectClientSessions() {
        SrvSessionList sessList = this.getSMBServer().getSessions();
        int discCnt = 0;
        if (sessList != null) {
            Enumeration<SrvSession> enumSess = sessList.enumerateSessions();
            boolean addrMatch = false;
            String addrStr = null;
            while (enumSess.hasMoreElements()) {
                SMBSrvSession curSess = (SMBSrvSession)enumSess.nextElement();
                addrMatch = false;
                InetAddress address = curSess.getRemoteAddress();
                List<String> terminalServerList = this.getSMBServer().getSMBConfiguration().getTerminalServerList();
                List<String> loadBalancerList = this.getSMBServer().getSMBConfiguration().getLoadBalancerList();
                boolean disableCheckLoadBalancer = true;
                if (loadBalancerList != null && loadBalancerList.size() > 0) {
                    disableCheckLoadBalancer = !loadBalancerList.contains(address.getHostAddress());
                }
                boolean disableCheckTerminalServer = true;
                if (terminalServerList != null && terminalServerList.size() > 0) {
                    boolean bl = disableCheckTerminalServer = !terminalServerList.contains(address.getHostAddress());
                }
                if (curSess.getSessionId() != this.getSessionId() && disableCheckLoadBalancer && disableCheckTerminalServer) {
                    boolean userNameIsTheSame = false;
                    if (this.hasClientInformation() && curSess.hasClientInformation()) {
                        String userName = this.getClientInformation().getUserName();
                        String userNameSess = curSess.getClientInformation().getUserName();
                        if (userName != null && userName.equals(userNameSess)) {
                            userNameIsTheSame = true;
                        }
                    }
                    if (this.hasRemoteAddress() && curSess.hasRemoteAddress()) {
                        if (this.getRemoteAddress().equals(curSess.getRemoteAddress()) && userNameIsTheSame) {
                            addrMatch = true;
                            addrStr = this.getRemoteAddress().getHostAddress();
                        }
                    } else if (this.hasRemoteName() && curSess.hasRemoteName() && this.getRemoteName().equals(curSess.getRemoteName()) && userNameIsTheSame) {
                        addrMatch = true;
                        addrStr = this.getRemoteName();
                    }
                }
                if (!addrMatch) continue;
                if (this.hasDebug(Dbg.NEGOTIATE)) {
                    this.debugPrintln("Close existing session sess=" + curSess + "addr=" + addrStr);
                }
                curSess.closeSession();
                ++discCnt;
            }
        }
        return discCnt;
    }

    public final void transferSession(SMBSrvSession otherSess) {
        this.m_vcircuits = otherSess.getVirtualCircuitList();
        otherSess.clearVirtualCircuitList();
    }

    public final void dumpSetupObjects() {
        if (this.m_setupObjects != null) {
            this.debugPrintln("Setup objects:");
            Enumeration<Integer> enumPids = this.m_setupObjects.keys();
            while (enumPids.hasMoreElements()) {
                Integer pid = enumPids.nextElement();
                EnumMap<SetupObjectType, Object> setupObjs = this.m_setupObjects.get(pid);
                this.debugPrintln(" PID=" + pid + ", setupObjs=" + setupObjs);
            }
        } else {
            this.debugPrintln("No setup objects");
        }
    }

    public final void dumpSessionKeys() {
        if (this.m_sessionKeys != null) {
            this.debugPrintln("Session keys:");
            Iterator<String> keys = this.m_sessionKeys.keySet().iterator();
            while (keys.hasNext()) {
                this.debugPrintln(" " + keys.next());
            }
        } else {
            this.debugPrintln("No session keys");
        }
    }

    public static enum Dbg {
        PKTTYPE,
        STATE,
        RXDATA,
        TXDATA,
        DUMPDATA,
        NEGOTIATE,
        TREE,
        SEARCH,
        INFO,
        FILE,
        FILEIO,
        TRAN,
        ECHO,
        ERROR,
        IPC,
        LOCK,
        DCERPC,
        STATECACHE,
        TIMING,
        NOTIFY,
        STREAMS,
        SOCKET,
        PKTPOOL,
        PKTSTATS,
        THREADPOOL,
        BENCHMARK,
        OPLOCK,
        PKTALLOC,
        COMPOUND,
        CANCEL,
        SIGNING,
        ENCRYPTION;

    }
}

