/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import org.filesys.smb.TransactBuffer;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBTransPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

class SMBSrvTransPacket
extends SMBTransPacket {
    private static final int StandardParamsResponse = 10;
    protected static final int SetupOffsetResponse = 57;

    public SMBSrvTransPacket(byte[] buf) {
        super(buf);
    }

    public SMBSrvTransPacket(SMBV1Parser parser) {
        super(parser);
    }

    public SMBSrvTransPacket(SMBSrvPacket smbPkt) {
        super(smbPkt.getBuffer());
    }

    public SMBSrvTransPacket(int siz) {
        super(siz);
        this.getV1Parser().setMultiplexId(SMBSrvTransPacket.getNextMultiplexId());
    }

    public static final void initTransactReply(SMBSrvPacket pkt, int prmCnt, int prmPos, int dataCnt, int dataPos) {
        SMBV1Parser parser = (SMBV1Parser)pkt.getParser();
        parser.setParameterCount(10);
        parser.setParameter(0, prmCnt);
        parser.setParameter(1, dataCnt);
        parser.setParameter(2, 0);
        parser.setParameter(3, prmCnt);
        parser.setParameter(4, prmPos - 4);
        parser.setParameter(5, 0);
        parser.setParameter(6, dataCnt);
        parser.setParameter(7, dataPos - 4);
        parser.setParameter(8, 0);
        parser.setParameter(9, 0);
    }

    protected static final int CalculateDataItemSize(String desc) {
        int len = 0;
        int pos = 0;
        while (pos < desc.length()) {
            char dtype = desc.charAt(pos++);
            int dlen = 1;
            if (pos < desc.length() && Character.isDigit(desc.charAt(pos))) {
                int numlen = 1;
                int numpos = pos + 1;
                while (numpos < desc.length() && Character.isDigit(desc.charAt(numpos++))) {
                    ++numlen;
                }
                dlen = Integer.parseInt(desc.substring(pos, pos + numlen));
                pos = numpos - 1;
            }
            switch (dtype) {
                case 'W': {
                    len += 2;
                    break;
                }
                case 'D': {
                    len += 4;
                    break;
                }
                case 'B': {
                    len += dlen;
                    break;
                }
                case 'z': {
                    len += 4;
                    break;
                }
                case '.': {
                    len += dlen;
                    break;
                }
                case 'T': {
                    len += 4;
                }
            }
        }
        return len;
    }

    public final int getDataBlockOffset(int prmLen) {
        int pos = this.getParameterBlockOffset() + prmLen;
        if ((pos & 1) != 0) {
            ++pos;
        }
        return pos;
    }

    public final int getRxDataBlock() {
        return this.getV1Parser().getParameter(12) + 4;
    }

    public final int getRxDataBlockLength() {
        return this.getV1Parser().getParameter(11);
    }

    public final int getRxParameter(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelShort(this.getBuffer(), pos += prmIdx * 2);
    }

    public final int getRxParameterBlock() {
        return this.getV1Parser().getParameter(10) + 4;
    }

    public final int getRxParameterBlockLength() {
        return this.getV1Parser().getParameter(9);
    }

    public final int getRxParameterCount() {
        return this.getV1Parser().getParameterCount() - 14;
    }

    public final int getRxParameterInt(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelInt(this.getBuffer(), pos += prmIdx * 2);
    }

    public final String getRxParameterString(int pos, boolean uni) {
        pos += this.getRxParameterBlock();
        byte[] buf = this.getBuffer();
        int len = buf[pos++] & 0xFF;
        return DataPacker.getString(buf, pos, len, uni);
    }

    public final String getRxParameterString(int pos, int len, boolean uni) {
        byte[] buf = this.getBuffer();
        return DataPacker.getString(buf, pos += this.getRxParameterBlock(), len, uni);
    }

    public final String getRxTransactName() {
        if (this.getV1Parser().getCommand() == 50) {
            return "";
        }
        int pos = this.getV1Parser().getByteOffset();
        return DataPacker.getString(this.getBuffer(), pos, this.getV1Parser().getByteCount());
    }

    public final int getSetupCount() {
        return this.getV1Parser().getParameter(13) & 0xFF;
    }

    public final int getSetupOffset() {
        return 65;
    }

    public final int getSetupParameter(int idx) {
        if (idx >= this.getRxParameterCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getV1Parser().getParameter(idx + 14);
    }

    public final int getMaximumReturnParameterCount() {
        return this.getV1Parser().getParameter(2);
    }

    public final int getMaximumReturnDataCount() {
        return this.getV1Parser().getParameter(3);
    }

    public final int getMaximumReturnSetupCount() {
        return this.getV1Parser().getParameter(4);
    }

    public final int getSetupParameterInt(int idx) {
        if (idx >= this.getRxParameterCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getV1Parser().getParameterLong(idx + 14);
    }

    public final void setTotalParameterCount(int cnt) {
        this.getV1Parser().setParameter(0, cnt);
    }

    public final void setTotalDataCount(int cnt) {
        this.getV1Parser().setParameter(1, cnt);
    }

    public final void setParameterBlockCount(int len) {
        this.getV1Parser().setParameter(3, len);
    }

    public final void setParameterBlockOffset(int off) {
        this.getV1Parser().setParameter(4, off != 0 ? off - 4 : 0);
    }

    public final void setParameterBlockDisplacement(int disp) {
        this.getV1Parser().setParameter(5, disp);
    }

    public final void setDataBlockCount(int len) {
        this.getV1Parser().setParameter(6, len);
    }

    public final void setDataBlockOffset(int off) {
        this.getV1Parser().setParameter(7, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockDisplacement(int disp) {
        this.getV1Parser().setParameter(8, disp);
    }

    protected final void doTransactionResponse(SMBSrvSession sess, TransactBuffer tbuf) throws IOException {
        this.doTransactionResponse(sess, tbuf, this);
    }

    protected final void doTransactionResponse(SMBSrvSession sess, TransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException {
        SMBV1Parser parser = this.getV1Parser();
        parser.setCommand(tbuf.isType());
        tbuf.setEndOfBuffer();
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        if (tbuf.hasSetupBuffer()) {
            parser.setParameterCount(10 + setupBuf.getLengthInWords());
        } else {
            parser.setParameterCount(10);
        }
        for (int i = 0; i < parser.getParameterCount(); ++i) {
            parser.setParameter(i, 0);
        }
        int availBuf = parser.getAvailableLength();
        int clientLen = parser.getAvailableLength(sess.getClientMaximumBufferSize());
        if (clientLen > availBuf) {
            SMBSrvPacket respPkt = sess.getPacketPool().allocatePacket(sess.getClientMaximumBufferSize(), smbPkt, parser.getByteOffset());
            this.setBuffer(respPkt.getBuffer());
            parser.resetParser(this.getBuffer(), this.getBuffer().length);
            availBuf = parser.getAvailableLength() - 4;
        } else if (availBuf > clientLen) {
            availBuf = clientLen;
        }
        int totParamLen = paramBuf != null ? paramBuf.getLength() : 0;
        int totDataLen = dataBuf != null ? dataBuf.getLength() : 0;
        this.setTotalParameterCount(totParamLen);
        this.setTotalDataCount(totDataLen);
        int plen = totParamLen;
        int dlen = totDataLen;
        if (plen + dlen > availBuf) {
            if (plen > 0) {
                if (plen <= availBuf) {
                    if (dlen > 0) {
                        dlen = availBuf - plen;
                    }
                } else {
                    dlen = plen = availBuf / 2;
                }
            } else if (dlen > availBuf) {
                dlen = availBuf;
            }
        }
        this.setParameterBlockCount(plen);
        this.setDataBlockCount(dlen);
        if (setupBuf != null) {
            setupBuf.copyData(this.getBuffer(), 57);
        }
        int pos = DataPacker.wordAlign(parser.getByteOffset());
        parser.setPosition(pos);
        this.setParameterBlockCount(plen);
        this.setParameterBlockOffset(pos);
        int packLen = -1;
        if (paramBuf != null) {
            packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
            pos = DataPacker.longwordAlign(pos + packLen);
            parser.setPosition(pos);
        }
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(pos);
        if (dataBuf != null) {
            packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
            parser.setPosition(pos + packLen);
        }
        parser.setByteCount();
        sess.sendResponseSMB(this);
        availBuf = parser.getAvailableLength();
        if (availBuf > clientLen) {
            availBuf = clientLen;
        }
        Object rxBuf = null;
        while (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
            parser.setCommand(tbuf.isType());
            plen = paramBuf != null ? paramBuf.getAvailableLength() : 0;
            int n = dlen = dataBuf != null ? dataBuf.getAvailableLength() : 0;
            if (plen + dlen > availBuf) {
                if (plen > 0) {
                    if (plen <= availBuf) {
                        if (dlen > 0) {
                            dlen = availBuf - plen;
                        }
                    } else {
                        dlen = plen = availBuf / 2;
                    }
                } else if (dlen > availBuf) {
                    dlen = availBuf;
                }
            }
            parser.resetBytePointerAlign();
            packLen = -1;
            pos = parser.getPosition();
            if (plen > 0 && paramBuf != null) {
                this.setParameterBlockOffset(pos);
                this.setParameterBlockCount(plen);
                this.setParameterBlockDisplacement(paramBuf.getDisplacement());
                packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
                pos = DataPacker.wordAlign(pos + packLen);
                parser.setPosition(pos);
            } else {
                this.setParameterBlockCount(0);
                this.setParameterBlockOffset(pos);
            }
            if (dlen > 0 && dataBuf != null) {
                this.setDataBlockOffset(pos);
                this.setDataBlockCount(dlen);
                this.setDataBlockDisplacement(dataBuf.getDisplacement());
                packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
                parser.setPosition(pos + packLen);
            } else {
                this.setDataBlockCount(0);
                this.setDataBlockOffset(pos);
            }
            parser.setByteCount();
            sess.sendResponseSMB(this);
        }
    }
}

