/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.util.DataPacker;

public class SMBTransPacket
extends SMBSrvPacket {
    protected static final int STD_PARAMS = 14;
    public static final int IsContinued = 234;
    protected String m_transName;
    protected int m_paramCnt;
    private static int m_nextMID = 1;

    public SMBTransPacket(byte[] buf) {
        super(buf);
        this.setParser(SMBSrvPacket.Version.V1);
    }

    public SMBTransPacket(SMBV1Parser parser) {
        super(parser.getBuffer());
        this.m_parser = parser;
    }

    public SMBTransPacket(int siz) {
        super(siz);
        this.setParser(SMBSrvPacket.Version.V1);
        this.getV1Parser().setMultiplexId(SMBTransPacket.getNextMultiplexId());
    }

    public final SMBV1Parser getV1Parser() {
        return (SMBV1Parser)this.m_parser;
    }

    public static final int getNextMultiplexId() {
        return m_nextMID++;
    }

    public final int getTotalParameterCount() {
        return this.getV1Parser().getParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getV1Parser().getParameter(1);
    }

    public final int getParameterBlockCount() {
        return this.getV1Parser().getParameter(9);
    }

    public final int getParameterBlockOffset() {
        return this.getV1Parser().getParameter(10) + 4;
    }

    public final int getDataBlockCount() {
        return this.getV1Parser().getParameter(11);
    }

    public final int getDataBlockOffset() {
        return this.getV1Parser().getParameter(12) + 4;
    }

    public final int getSecondaryParameterBlockCount() {
        return this.getV1Parser().getParameter(2);
    }

    public final int getSecondaryParameterBlockOffset() {
        return this.getV1Parser().getParameter(3) + 4;
    }

    public final int getParameterBlockDisplacement() {
        return this.getV1Parser().getParameter(4);
    }

    public final int getSecondaryDataBlockCount() {
        return this.getV1Parser().getParameter(5);
    }

    public final int getSecondaryDataBlockOffset() {
        return this.getV1Parser().getParameter(6) + 4;
    }

    public final int getDataBlockDisplacement() {
        return this.getV1Parser().getParameter(7);
    }

    public final int getSubFunction() {
        return this.getV1Parser().getParameter(14);
    }

    public final void getParameterBlock(short[] prmblk) throws ArrayIndexOutOfBoundsException {
        int prmcnt = this.getV1Parser().getParameter(3) / 2;
        if (prmblk.length < prmcnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int pos = this.getV1Parser().getParameter(4) + 4;
        byte[] buf = this.getBuffer();
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = (short)DataPacker.getIntelShort(buf, pos);
            pos += 2;
        }
    }

    public final void InitializeTransact(int pcnt, byte[] paramblk, int plen, byte[] datablk, int dlen) {
        int idx;
        int pos;
        SMBV1Parser parser = this.getV1Parser();
        if (this.m_transName == null) {
            parser.setCommand(50);
        } else {
            parser.setCommand(37);
        }
        parser.setParameterCount(pcnt);
        this.m_paramCnt = pcnt;
        parser.setParameter(0, plen);
        parser.setParameter(1, dlen);
        int i = 2;
        while (i < 9) {
            parser.setParameter(i++, 0);
        }
        parser.setParameter(9, plen);
        parser.setParameter(11, dlen);
        parser.setParameter(13, pcnt - 14);
        int startPos = pos = parser.getByteOffset();
        byte[] buf = this.getBuffer();
        if (this.m_transName != null) {
            byte[] nam = this.m_transName.getBytes();
            for (idx = 0; idx < nam.length; ++idx) {
                buf[pos++] = nam[idx];
            }
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (paramblk != null) {
            parser.setParameter(10, pos - 4);
            for (idx = 0; idx < plen; ++idx) {
                buf[pos++] = paramblk[idx];
            }
        } else {
            parser.setParameter(10, 0);
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (datablk != null) {
            parser.setParameter(12, pos - 4);
            for (idx = 0; idx < dlen; ++idx) {
                buf[pos++] = datablk[idx];
            }
        } else {
            parser.setParameter(12, 0);
        }
        parser.setByteCount(pos - startPos);
    }

    public final void setSetupParameter(int idx, int val) {
        this.getV1Parser().setParameter(14 + idx, val);
    }

    public final void setTransactionName(String tname) {
        this.m_transName = tname;
    }
}

