/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

public class SMBV1 {
    public static final int SIGNATURE = 4;
    public static final int COMMAND = 8;
    public static final int ERRORCODE = 9;
    public static final int ERRORCLASS = 9;
    public static final int ERROR = 11;
    public static final int FLAGS = 13;
    public static final int FLAGS2 = 14;
    public static final int PIDHIGH = 16;
    public static final int SID = 22;
    public static final int SEQNO = 24;
    public static final int TID = 28;
    public static final int PID = 30;
    public static final int UID = 32;
    public static final int MID = 34;
    public static final int WORDCNT = 36;
    public static final int ANDXCOMMAND = 37;
    public static final int ANDXRESERVED = 38;
    public static final int PARAMWORDS = 37;
    public static final int HeaderLength = 33;
    public static final int TRANS_HEADERLEN = 70;
    public static final int MIN_RXLEN = 32;
    public static final int FLG_SUBDIALECT = 1;
    public static final int FLG_CASELESS = 8;
    public static final int FLG_CANONICAL = 16;
    public static final int FLG_OPLOCK = 32;
    public static final int FLG_NOTIFY = 64;
    public static final int FLG_RESPONSE = 128;
    public static final int FLG2_LONGFILENAMES = 1;
    public static final int FLG2_EXTENDEDATTRIB = 2;
    public static final int FLG2_SECURITYSIGS = 4;
    public static final int FLG2_EXTENDEDSECURITY = 2048;
    public static final int FLG2_DFSRESOLVE = 4096;
    public static final int FLG2_READIFEXE = 8192;
    public static final int FLG2_LONGERRORCODE = 16384;
    public static final int FLG2_UNICODE = 32768;
    public static final int SEC_USER = 1;
    public static final int SEC_ENCRYPT = 2;
    public static final int RAW_READ = 1;
    public static final int RAW_WRITE = 2;
    public static final int NO_ANDX_CMD = 255;
    public static final int DefaultBufferSize = 65540;
    public static final int LanManBufferSize = 8192;
    public static final int LanManMaxMultiplexed = 1;
    public static final int NTMaxMultiplexed = 4;
    public static final int MaxVirtualCircuits = 0;

    public static final String getPacketTypeString(int cmd) {
        String pktType = "";
        switch (cmd) {
            case 114: {
                pktType = "NEGOTIATE";
                break;
            }
            case 115: {
                pktType = "SESSION_SETUP";
                break;
            }
            case 112: {
                pktType = "TREE_CONNECT";
                break;
            }
            case 117: {
                pktType = "TREE_CONNECT_ANDX";
                break;
            }
            case 113: {
                pktType = "TREE_DISCONNECT";
                break;
            }
            case 129: {
                pktType = "SEARCH";
                break;
            }
            case 2: {
                pktType = "OPEN_FILE";
                break;
            }
            case 45: {
                pktType = "OPEN_ANDX";
                break;
            }
            case 10: {
                pktType = "READ_FILE";
                break;
            }
            case 11: {
                pktType = "WRITE_FILE";
                break;
            }
            case 4: {
                pktType = "CLOSE_FILE";
                break;
            }
            case 3: {
                pktType = "CREATE_FILE";
                break;
            }
            case 8: {
                pktType = "GET_FILE_INFO";
                break;
            }
            case 128: {
                pktType = "GET_DISK_INFO";
                break;
            }
            case 16: {
                pktType = "CHECK_DIRECTORY";
                break;
            }
            case 7: {
                pktType = "RENAME_FILE";
                break;
            }
            case 1: {
                pktType = "DELETE_DIRECTORY";
                break;
            }
            case 195: {
                pktType = "GET_PRINT_QUEUE";
                break;
            }
            case 50: {
                pktType = "TRANSACTION2";
                break;
            }
            case 37: {
                pktType = "TRANSACTION";
                break;
            }
            case 51: {
                pktType = "TRANSACTION2_SECONDARY";
                break;
            }
            case 38: {
                pktType = "TRANSACTION_SECONDARY";
                break;
            }
            case 43: {
                pktType = "ECHO";
                break;
            }
            case 35: {
                pktType = "QUERY_INFORMATION_2";
                break;
            }
            case 44: {
                pktType = "WRITE_AND_CLOSE";
                break;
            }
            case 34: {
                pktType = "SET_INFORMATION_2";
                break;
            }
            case 52: {
                pktType = "FIND_CLOSE2";
                break;
            }
            case 116: {
                pktType = "LOGOFF_ANDX";
                break;
            }
            case 46: {
                pktType = "READ_ANDX";
                break;
            }
            default: {
                pktType = "0x" + Integer.toHexString(cmd);
            }
        }
        return pktType;
    }
}

