/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.util.Date;
import org.filesys.server.auth.AuthenticatorException;
import org.filesys.server.auth.ChallengeAuthContext;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.locking.OpLockDetailsAdapter;
import org.filesys.smb.Dialect;
import org.filesys.smb.NTTime;
import org.filesys.smb.PacketTypeV1;
import org.filesys.smb.SMBDate;
import org.filesys.smb.SMBErrorText;
import org.filesys.smb.StringListDialectSelector;
import org.filesys.smb.dcerpc.UUID;
import org.filesys.smb.server.CoreProtocolHandler;
import org.filesys.smb.server.NTParameterPacker;
import org.filesys.smb.server.NegotiateContext;
import org.filesys.smb.server.ProtocolHandler;
import org.filesys.smb.server.SMBParser;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBV1;
import org.filesys.smb.server.SMBV1OplockOwner;
import org.filesys.smb.server.SessionState;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;

public class SMBV1Parser
extends SMBParser {
    private static final byte[] SMB_V1_SIGNATURE = new byte[]{-1, 83, 77, 66};
    private static final int StandardParams = 19;
    private static final int ParameterBytes = 36;
    private static final int ReplyParams = 18;
    private static final int NTMaxSetupCount = 37;
    private static final int NTParams = 40;
    private static final int NTSetupCount = 72;
    private static final int NTFunction = 73;
    private static final int DefaultReturnParams = 4;
    private static final int DefaultReturnData = 1024;

    public SMBV1Parser(byte[] buf, int len) {
        super(buf, len);
    }

    @Override
    public String getName() {
        return "SMBv1";
    }

    @Override
    public SMBSrvPacket.Version isType() {
        return SMBSrvPacket.Version.V1;
    }

    @Override
    public String toShortString() {
        StringBuffer str = new StringBuffer();
        str.append("[V1 cmd=");
        str.append(PacketTypeV1.getCommandName(this.getCommand()));
        str.append("]");
        return str.toString();
    }

    @Override
    public boolean checkPacketIsValid(int reqWords, int reqBytes) {
        for (int idx = 0; idx < SMB_V1_SIGNATURE.length; ++idx) {
            if (this.m_smbbuf[idx + 4] == SMB_V1_SIGNATURE[idx]) continue;
            return false;
        }
        return this.getParameterCount() >= reqWords && this.getByteCount() >= reqBytes;
    }

    @Override
    public void packSuccessRespone() {
        this.setParameterCount(0);
        this.setByteCount(0);
    }

    @Override
    public void setResponse() {
        this.setRequestPacket(false);
    }

    public final void clearBytes() {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(0, this.m_smbbuf, offset);
    }

    public final int getAndXByteCount(int off) {
        int pos = off + 1 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this.m_smbbuf, pos);
    }

    public final int getAndXByteOffset(int off) {
        int pCnt = this.getAndXParameterCount(off);
        int pos = off + 2 * pCnt + 3;
        return pos;
    }

    public final int getAndXCommand() {
        return this.m_smbbuf[37] & 0xFF;
    }

    public final int getAndXParameter(int off, int idx) throws IndexOutOfBoundsException {
        if (idx > this.getAndXParameterCount(off)) {
            throw new IndexOutOfBoundsException();
        }
        int pos = off + 2 * idx + 1;
        return DataPacker.getIntelShort(this.m_smbbuf, pos) & 0xFFFF;
    }

    public final int getAndXParameterLong(int off, int idx) throws IndexOutOfBoundsException {
        if (idx > this.getAndXParameterCount(off)) {
            throw new IndexOutOfBoundsException();
        }
        int pos = off + 2 * idx + 1;
        return DataPacker.getIntelInt(this.m_smbbuf, pos);
    }

    public final int getAndXParameterCount(int off) {
        return this.m_smbbuf[off];
    }

    public final int getBufferLength() {
        return this.m_smbbuf.length - 4;
    }

    public final int getByteCount() {
        int pos = 37 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this.m_smbbuf, pos);
    }

    public final int getByteOffset() {
        return 36 + 2 * this.getParameterCount() + 3;
    }

    public final int getCommand() {
        return this.m_smbbuf[8] & 0xFF;
    }

    @Override
    public final int getErrorClass() {
        return this.m_smbbuf[9] & 0xFF;
    }

    @Override
    public final int getErrorCode() {
        return this.m_smbbuf[11] & 0xFF;
    }

    public final int getFlags() {
        return this.m_smbbuf[13] & 0xFF;
    }

    public final int getFlags2() {
        return DataPacker.getIntelShort(this.m_smbbuf, 14);
    }

    public final int getHeaderFlags() {
        return this.m_smbbuf[1] & 0xFF;
    }

    public final int getHeaderLength() {
        return DataPacker.getIntelShort(this.m_smbbuf, 2) & 0xFFFF;
    }

    public final int getHeaderType() {
        return this.m_smbbuf[0] & 0xFF;
    }

    @Override
    public int getLength() {
        return this.getByteOffset() + this.getByteCount() - 4;
    }

    public final int getAvailableLength() {
        return this.m_smbbuf.length - DataPacker.longwordAlign(this.getByteOffset());
    }

    public final int getAvailableLength(int len) {
        return len - DataPacker.longwordAlign(this.getByteOffset());
    }

    public final int getLongErrorCode() {
        return DataPacker.getIntelInt(this.m_smbbuf, 9);
    }

    public final int getMultiplexId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 34);
    }

    public final int getParameter(int idx) throws IndexOutOfBoundsException {
        if (idx > this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int pos = 36 + 2 * idx + 1;
        return DataPacker.getIntelShort(this.m_smbbuf, pos) & 0xFFFF;
    }

    public final int getParameterCount() {
        return this.m_smbbuf[36];
    }

    public final int getParameterLong(int idx) {
        int pos = 36 + 2 * idx + 1;
        return DataPacker.getIntelInt(this.m_smbbuf, pos);
    }

    public final int getProcessId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 30);
    }

    public final int getProcessIdHigh() {
        return DataPacker.getIntelShort(this.m_smbbuf, 16);
    }

    public final int getProcessIdFull() {
        int pid = this.getProcessId();
        int pidHigh = this.getProcessIdHigh();
        if (pidHigh != 0) {
            pid += pidHigh << 16;
        }
        return pid;
    }

    public final int getSID() {
        return DataPacker.getIntelShort(this.m_smbbuf, 22);
    }

    public final int getTreeId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 28);
    }

    public final int getUserId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 32);
    }

    public final boolean hasAndXCommand() {
        int andxCmd = this.getAndXCommand();
        return andxCmd != 255 && andxCmd != 0;
    }

    private final void InitializeBuffer() {
        this.m_smbbuf[4] = -1;
        this.m_smbbuf[5] = 83;
        this.m_smbbuf[6] = 77;
        this.m_smbbuf[7] = 66;
    }

    public final boolean isResponse() {
        int resp = this.getFlags();
        return (resp & 0x80) != 0;
    }

    public final boolean isUnicode() {
        return (this.getFlags2() & 0x8000) != 0;
    }

    public final boolean isCaseless() {
        return (this.getFlags() & 8) != 0;
    }

    public final boolean isLongFileNames() {
        return (this.getFlags2() & 1) != 0;
    }

    @Override
    public final boolean isLongErrorCode() {
        return (this.getFlags2() & 0x4000) != 0;
    }

    public final boolean isRequestPacket() {
        return !this.isResponse();
    }

    public final void setRequestPacket(boolean reqPkt) {
        int flgs = this.getFlags();
        flgs = reqPkt ? (flgs &= 0xFFFFFF7F) : (flgs |= 0x80);
        this.setFlags(flgs);
    }

    public final void setAndXByteCount(int off, int cnt) {
        int offset = this.getAndXByteOffset(off) - 2;
        DataPacker.putIntelShort(cnt, this.m_smbbuf, offset);
    }

    public final void setAndXBytes(int off, byte[] byts) {
        int offset = this.getAndXByteOffset(off) - 2;
        DataPacker.putIntelShort(byts.length, this.m_smbbuf, offset);
        offset += 2;
        int idx = 0;
        while (idx < byts.length) {
            this.m_smbbuf[offset + idx] = byts[idx++];
        }
    }

    public final void setAndXCommand(int cmd) {
        this.m_smbbuf[37] = (byte)cmd;
        this.m_smbbuf[38] = 0;
    }

    public final void setAndXCommand(int off, int cmd) {
        this.m_smbbuf[off + 1] = (byte)cmd;
        this.m_smbbuf[off + 2] = 0;
    }

    public final void setAndXParameter(int off, int idx, int val) {
        int pos = off + 2 * idx + 1;
        DataPacker.putIntelShort(val, this.m_smbbuf, pos);
    }

    public final void setAndXParameterCount(int off, int cnt) {
        this.m_smbbuf[off] = (byte)cnt;
    }

    public final void setByteCount(int cnt) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(cnt, this.m_smbbuf, offset);
    }

    public final void setByteCount() {
        int offset = this.getByteOffset() - 2;
        int len = this.m_pos - this.getByteOffset();
        DataPacker.putIntelShort(len, this.m_smbbuf, offset);
    }

    public final void setBytes(byte[] byts) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(byts.length, this.m_smbbuf, offset);
        offset += 2;
        int idx = 0;
        while (idx < byts.length) {
            this.m_smbbuf[offset + idx] = byts[idx++];
        }
    }

    public final void setCommand(int cmd) {
        this.m_smbbuf[8] = (byte)cmd;
    }

    public final void setError(int errCode, int errClass) {
        this.setErrorClass(errClass);
        this.setErrorCode(errCode);
    }

    public final void setError(boolean longError, int ntErr, int errCode, int errClass) {
        if (longError) {
            this.setLongErrorCode(ntErr);
            if (!this.isLongErrorCode()) {
                this.setFlags2(this.getFlags2() + 16384);
            }
        } else {
            this.setErrorClass(errClass);
            this.setErrorCode(errCode);
        }
    }

    public final void setErrorClass(int cl) {
        this.m_smbbuf[9] = (byte)(cl & 0xFF);
    }

    public final void setErrorCode(int sts) {
        this.m_smbbuf[11] = (byte)(sts & 0xFF);
    }

    public final void setLongErrorCode(int err) {
        DataPacker.putIntelInt(err, this.m_smbbuf, 9);
    }

    public final void setSuccessStatus() {
        this.setLongErrorCode(0);
    }

    public final void setFlags(int flg) {
        this.m_smbbuf[13] = (byte)flg;
    }

    public final void setFlags2(int flg) {
        DataPacker.putIntelShort(flg, this.m_smbbuf, 14);
    }

    public final void setHeaderFlags(int flg) {
        this.m_smbbuf[1] = (byte)(flg & 0xFF);
    }

    public final void setHeaderLength(int len) {
        DataPacker.putIntelShort(len, this.m_smbbuf, 2);
    }

    public final void setHeaderType(int typ) {
        this.m_smbbuf[0] = (byte)(typ & 0xFF);
    }

    public final void setMultiplexId(int mid) {
        DataPacker.putIntelShort(mid, this.m_smbbuf, 34);
    }

    public final void setParameter(int idx, int val) {
        int pos = 36 + 2 * idx + 1;
        DataPacker.putIntelShort(val, this.m_smbbuf, pos);
    }

    public final void setParameterCount(int cnt) {
        this.m_smbbuf[36] = (byte)cnt;
        this.resetBytePointer();
    }

    public final void setParameterLong(int idx, int val) {
        int pos = 36 + 2 * idx + 1;
        DataPacker.putIntelInt(val, this.m_smbbuf, pos);
    }

    public final void setProcessId(int pid) {
        DataPacker.putIntelShort(pid, this.m_smbbuf, 30);
    }

    public final void setSeqNo(int seq) {
        DataPacker.putIntelShort(seq, this.m_smbbuf, 24);
    }

    public final void setSID(int sid) {
        DataPacker.putIntelShort(sid, this.m_smbbuf, 22);
    }

    public final void setTreeId(int tid) {
        DataPacker.putIntelShort(tid, this.m_smbbuf, 28);
    }

    public final void setUserId(int uid) {
        DataPacker.putIntelShort(uid, this.m_smbbuf, 32);
    }

    public final void resetBytePointer() {
        this.m_pos = this.getByteOffset();
        this.m_endpos = this.m_pos + this.getByteCount();
    }

    public final void setBytePointer(int off, int len) {
        this.m_pos = off;
        this.m_endpos = this.m_pos + len;
    }

    public final void alignBytePointer() {
        this.m_pos = DataPacker.longwordAlign(this.m_pos);
    }

    public final void resetBytePointerAlign() {
        this.m_pos = DataPacker.longwordAlign(this.getByteOffset());
        this.m_endpos = this.m_pos + this.getByteCount();
    }

    public final int calculateHeaderLength(int numParams) {
        return 33 + numParams * 2 + 4;
    }

    public final int getDataLength() {
        return this.getNTParameter(6);
    }

    public final int getDataOffset() {
        return this.getNTParameter(7) + 4;
    }

    public final int[] getParameterBlock() {
        int prmcnt = this.getParameterBlockCount() / 4;
        if (prmcnt <= 0) {
            return null;
        }
        int[] prmblk = new int[prmcnt];
        int pos = this.getParameterBlockOffset();
        this.setBytePointer(pos, this.getByteCount());
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = this.unpackInt();
        }
        return prmblk;
    }

    public final int getTotalParameterCount() {
        return this.getNTParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getNTParameter(1);
    }

    public final int getMaximumParameterReturn() {
        return this.getNTParameter(2);
    }

    public final int getMaximumDataReturn() {
        return this.getNTParameter(3);
    }

    public final int getParameterBlockCount() {
        return this.getNTParameter(this.getCommand() == 160 ? 4 : 2);
    }

    public final int getParameterBlockOffset() {
        return this.getNTParameter(this.getCommand() == 160 ? 5 : 3) + 4;
    }

    public final int getParameterBlockDisplacement() {
        return this.getNTParameter(4);
    }

    public final int getDataBlockCount() {
        return this.getNTParameter(this.getCommand() == 160 ? 6 : 5);
    }

    public final int getDataBlockOffset() {
        return this.getNTParameter(this.getCommand() == 160 ? 7 : 6) + 4;
    }

    public final int getDataBlockDisplacement() {
        return this.getNTParameter(7);
    }

    protected final int getNTParameter(int idx) {
        int pos = 40 + 4 * idx;
        return DataPacker.getIntelInt(this.getBuffer(), pos);
    }

    public final int getSetupCount() {
        byte[] buf = this.getBuffer();
        return buf[72] & 0xFF;
    }

    public final int getSetupOffset() {
        return 75;
    }

    public final int getNTFunction() {
        byte[] buf = this.getBuffer();
        return DataPacker.getIntelShort(buf, 73);
    }

    public static final int calculateResponseLength(int plen, int dlen, int setupcnt) {
        return 33 + (18 + setupcnt) * 2 + plen + dlen;
    }

    public final void initTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt) {
        this.initTransact(func, paramblk, plen, datablk, dlen, setupcnt, 4, 1024);
    }

    public final void initTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt, int maxPrm, int maxData) {
        this.setCommand(160);
        this.setParameterCount(19 + setupcnt);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setMaximumParameterReturn(maxPrm);
        this.setMaximumDataReturn(maxData);
        this.setParameterCount(plen);
        this.setParameterBlockOffset(0);
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(0);
        this.setSetupCount(setupcnt);
        this.setNTFunction(func);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setParameterBlockOffset(this.getPosition());
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setDataBlockOffset(this.getPosition());
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void initTransactReply(byte[] paramblk, int plen, byte[] datablk, int dlen) {
        this.setParameterCount(18);
        this.setSetupCount(0);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setReplyParameterCount(plen);
        this.setReplyParameterOffset(0);
        this.setReplyParameterDisplacement(0);
        this.setReplyDataCount(dlen);
        this.setDataBlockOffset(0);
        this.setReplyDataDisplacement(0);
        this.setSetupCount(0);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setReplyParameterOffset(this.getPosition() - 4);
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setReplyDataOffset(this.getPosition() - 4);
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void initTransactReply(byte[] paramblk, int plen, byte[] datablk, int dlen, int setupCnt) {
        this.setParameterCount(18 + setupCnt);
        this.setSetupCount(setupCnt);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setReplyParameterCount(plen);
        this.setReplyParameterOffset(0);
        this.setReplyParameterDisplacement(0);
        this.setReplyDataCount(dlen);
        this.setDataBlockOffset(0);
        this.setReplyDataDisplacement(0);
        this.setSetupCount(setupCnt);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setReplyParameterOffset(this.getPosition() - 4);
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setReplyDataOffset(this.getPosition() - 4);
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void setTotalParameterCount(int cnt) {
        this.setNTParameter(0, cnt);
    }

    public final void setTotalDataCount(int cnt) {
        this.setNTParameter(1, cnt);
    }

    public final void setMaximumParameterReturn(int cnt) {
        this.setNTParameter(2, cnt);
    }

    public final void setMaximumDataReturn(int cnt) {
        this.setNTParameter(3, cnt);
    }

    public final void setTransactParameterCount(int cnt) {
        this.setNTParameter(4, cnt);
    }

    public final void setReplyParameterCount(int cnt) {
        this.setNTParameter(2, cnt);
    }

    public final void setReplyParameterOffset(int off) {
        this.setNTParameter(3, off);
    }

    public final void setReplyParameterDisplacement(int disp) {
        this.setNTParameter(4, disp);
    }

    public final void setReplyDataCount(int cnt) {
        this.setNTParameter(5, cnt);
    }

    public final void setReplyDataOffset(int off) {
        this.setNTParameter(6, off);
    }

    public final void setReplyDataDisplacement(int disp) {
        this.setNTParameter(7, disp);
    }

    public final void setParameterBlockOffset(int off) {
        this.setNTParameter(5, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockCount(int cnt) {
        this.setNTParameter(6, cnt);
    }

    public final void setDataBlockOffset(int off) {
        this.setNTParameter(7, off != 0 ? off - 4 : 0);
    }

    public final void setNTParameter(int idx, int val) {
        int pos = 40 + 4 * idx;
        DataPacker.putIntelInt(val, this.getBuffer(), pos);
    }

    public final void setMaximumSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[37] = (byte)cnt;
    }

    public final void setSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[72] = (byte)cnt;
    }

    public final void setSetupParameter(int setupIdx, int setupVal) {
        int pos = 73 + setupIdx * 2;
        DataPacker.putIntelShort(setupVal, this.getBuffer(), pos);
    }

    public final void setNTFunction(int func) {
        byte[] buf = this.getBuffer();
        DataPacker.putIntelShort(func, buf, 73);
    }

    public final void resetSetupPointer() {
        this.m_endpos = this.m_pos = 75;
    }

    public final void resetDataBlockPointer() {
        this.m_endpos = this.m_pos = this.getDataBlockOffset();
    }

    public final void resetParameterBlockPointer() {
        this.m_endpos = this.m_pos = this.getParameterBlockOffset();
    }

    @Override
    public void buildErrorResponse(int errClass, int errCode, ProtocolHandler protocolHandler) {
        this.setResponse();
        this.setParameterCount(0);
        this.setByteCount(0);
        this.setFlags(this.getFlags());
        this.setFlags2(this.getFlags2());
        if (errClass == 6) {
            if (!this.isLongErrorCode()) {
                this.setFlags2(this.getFlags2() + 16384);
            }
            this.setLongErrorCode(errCode);
        } else {
            if (this.isLongErrorCode()) {
                this.setFlags2(this.getFlags2() - 16384);
            }
            this.setErrorCode(errCode);
            this.setErrorClass(errClass);
        }
    }

    @Override
    public NegotiateContext parseNegotiateRequest(SMBSrvSession sess) throws SMBSrvException {
        if (this.getCommand() != 114 || !this.checkPacketIsValid(0, 2)) {
            throw new SMBSrvException(64, 2);
        }
        int dataPos = this.getByteOffset();
        String diaStr = null;
        StringListDialectSelector dialects = new StringListDialectSelector();
        for (int dataLen = this.getByteCount(); dataLen > 0; dataLen -= diaStr.length() + 2) {
            diaStr = DataPacker.getDataString('\u0002', this.m_smbbuf, dataPos, dataLen, false);
            if (diaStr == null) {
                throw new SMBSrvException(1, 2);
            }
            int diaId = Dialect.DialectType(diaStr);
            dialects.AddDialectAndString(diaId, diaStr);
            dataPos += diaStr.length() + 2;
        }
        return new NegotiateContext(dialects);
    }

    @Override
    public SessionState nextStateForDialect(int dialectId) {
        if (Dialect.DialectSupportsCommand(dialectId, 115)) {
            return SessionState.SMB_SESSSETUP;
        }
        return SessionState.SMB_SESSION;
    }

    @Override
    public void packNegotiateResponse(SMBServer server, SMBSrvSession sess, SMBSrvPacket smbPkt, int selDialect, NegotiateContext negCtx) throws AuthenticatorException, SMBSrvException {
        StringListDialectSelector strDiaSelector = (StringListDialectSelector)negCtx.getDialects();
        int selIdx = strDiaSelector.getStringIndexForDialect(selDialect);
        boolean extendedSecurity = (this.getFlags2() & 0x800) != 0;
        ISMBAuthenticator auth = server.getSMBAuthenticator();
        if (selDialect == -1 || selDialect <= 1) {
            this.setParameterCount(1);
            this.setParameter(0, selIdx);
            this.setByteCount(0);
            this.setTreeId(0);
            this.setUserId(0);
        } else if (selDialect <= 6) {
            this.setFlags(8);
            this.setFlags2(1);
            this.setParameterCount(13);
            this.setParameter(0, selIdx);
            this.setParameter(1, auth.getSecurityMode());
            this.setParameter(2, 8192);
            this.setParameter(3, 1);
            this.setParameter(4, 0);
            this.setParameter(5, 0);
            this.setParameterLong(6, (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL));
            SMBDate srvDate = new SMBDate(System.currentTimeMillis());
            this.setParameter(8, srvDate.asSMBTime());
            this.setParameter(9, srvDate.asSMBDate());
            this.setParameter(10, server.getGlobalConfiguration().getTimeZoneOffset());
            this.setParameter(11, auth.getEncryptionKeyLength());
            this.setParameter(12, 0);
            this.setTreeId(0);
            this.setUserId(0);
            this.packNegotiateSecuritySection(server, sess, false);
        } else if (selDialect == 7) {
            CoreProtocolHandler smbV1Handler = (CoreProtocolHandler)sess.getProtocolHandler();
            smbV1Handler.setDefaultFlags(8);
            smbV1Handler.setDefaultFlags2(32769);
            if (!auth.hasExtendedSecurity()) {
                extendedSecurity = false;
            }
            NTParameterPacker nt = new NTParameterPacker(this.getBuffer());
            this.setParameterCount(17);
            nt.packWord(selIdx);
            nt.packByte(auth.getSecurityMode());
            nt.packWord(4);
            nt.packWord(0);
            int maxBufSize = server.getPacketPool().getLargestSize() - 4;
            nt.packInt(maxBufSize);
            nt.packInt(0);
            if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                nt.packInt((int)(System.currentTimeMillis() & 0xFFFFFFFFL));
            } else {
                nt.packInt(0);
            }
            int srvCapabs = auth.getServerCapabilities();
            if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                srvCapabs &= Integer.MAX_VALUE;
            }
            nt.packInt(srvCapabs);
            long srvTime = NTTime.toNTTime(new Date(System.currentTimeMillis()));
            nt.packLong(srvTime);
            nt.packWord(server.getGlobalConfiguration().getTimeZoneOffset());
            if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                nt.packByte(auth.getEncryptionKeyLength());
            } else {
                nt.packByte(0);
            }
            this.setFlags(smbV1Handler.getDefaultFlags());
            this.setFlags2(smbV1Handler.getDefaultFlags2());
            this.setTreeId(0);
            this.setUserId(0);
            this.packNegotiateSecuritySection(server, sess, extendedSecurity);
        }
        this.setTreeId(65535);
        this.setUserId(65535);
        this.setResponse();
    }

    private void packNegotiateSecuritySection(SMBServer server, SMBSrvSession sess, boolean extendedSecurity) {
        ISMBAuthenticator auth = server.getSMBAuthenticator();
        if (!extendedSecurity) {
            ChallengeAuthContext authCtx = (ChallengeAuthContext)auth.getAuthContext(sess);
            int pos = this.getByteOffset();
            byte[] buf = this.getBuffer();
            if (authCtx == null || authCtx.getChallenge() == null) {
                this.packZeroes(8);
            } else {
                byte[] key = authCtx.getChallenge();
                for (int i = 0; i < key.length; ++i) {
                    buf[pos++] = key[i];
                }
            }
            String domain = sess.getSMBServer().getSMBConfiguration().getDomainName();
            if (domain != null) {
                pos = DataPacker.putString(domain, buf, pos, true, true);
            }
            pos = DataPacker.putString(sess.getSMBServer().getServerName(), buf, pos, true, true);
            this.setByteCount(pos - this.getByteOffset());
        } else {
            int flags2 = this.getFlags2();
            this.setFlags2(flags2 |= 0x4800);
            int pos = this.getByteOffset();
            byte[] buf = this.getBuffer();
            UUID serverGUID = sess.getSMBServer().getServerGUID();
            System.arraycopy(serverGUID.getBytes(), 0, buf, pos, 16);
            pos += 16;
            if (auth.usingSPNEGO() && auth.getNegTokenInit() != null) {
                byte[] negTokenInit = auth.getNegTokenInit();
                System.arraycopy(negTokenInit, 0, buf, pos, negTokenInit.length);
                pos += negTokenInit.length;
            }
            this.setByteCount(pos - this.getByteOffset());
        }
    }

    @Override
    public void responsePreSend(SMBSrvSession sess, SMBSrvPacket smbPkt) {
        CoreProtocolHandler smbV1Handler;
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        if (!parser.isResponse()) {
            parser.setFlags(parser.getFlags() + 128);
        }
        if ((smbV1Handler = (CoreProtocolHandler)sess.getProtocolHandler()) != null) {
            parser.setFlags(parser.getFlags() | smbV1Handler.getDefaultFlags());
            int flags2 = parser.getFlags2() | smbV1Handler.getDefaultFlags2();
            parser.setFlags2(flags2 &= 0xFFFFEFF9);
        }
    }

    @Override
    public void setOplockOwner(SMBSrvSession sess, OpLockDetailsAdapter opLock) {
        opLock.setOplockOwner(new SMBV1OplockOwner(this.getTreeId(), this.getProcessId(), this.getUserId()));
    }

    protected final boolean hasChainedCommand() {
        int cmd = this.getCommand();
        if (cmd == 115 || cmd == 117 || cmd == 45 || cmd == 47 || cmd == 46 || cmd == 116 || cmd == 36 || cmd == 162) {
            return this.hasAndXCommand();
        }
        return false;
    }

    @Override
    public void dumpPacket(boolean dumpRaw, boolean dumpAll) {
        int pCount = this.getParameterCount();
        System.out.print("** SMB V1 Packet Type: " + SMBV1.getPacketTypeString(this.getCommand()));
        if (this.isResponse()) {
            System.out.println(" [Response]");
        } else {
            System.out.println();
        }
        System.out.println("** SMB Packet Dump");
        System.out.println("Packet Length : " + this.getLength());
        System.out.println("Byte Offset: " + this.getByteOffset() + ", Byte Count: " + this.getByteCount());
        System.out.println("Flags: " + Integer.toBinaryString(this.getFlags()));
        System.out.println("Flags2: " + Integer.toBinaryString(this.getFlags2()));
        System.out.println("TID: " + this.getTreeId());
        System.out.println("PID: " + this.getProcessId());
        System.out.println("UID: " + this.getUserId());
        System.out.println("MID: " + this.getMultiplexId());
        System.out.println("Parameter Words: " + pCount);
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < pCount; ++i) {
            str.setLength(0);
            str.append(" P");
            str.append(Integer.toString(i + 1));
            str.append(" = ");
            str.append(Integer.toString(this.getParameter(i)));
            while (str.length() < 16) {
                str.append(" ");
            }
            str.append("0x");
            str.append(Integer.toHexString(this.getParameter(i)));
            System.out.println(str.toString());
        }
        if (this.isResponse()) {
            System.out.println("Error: 0x" + Integer.toHexString(this.getErrorCode()));
            System.out.print("Error Class: ");
            switch (this.getErrorClass()) {
                case 0: {
                    System.out.println("SUCCESS");
                    break;
                }
                case 1: {
                    System.out.println("ERRDOS");
                    break;
                }
                case 2: {
                    System.out.println("ERRSRV");
                    break;
                }
                case 3: {
                    System.out.println("ERRHRD");
                    break;
                }
                case 255: {
                    System.out.println("ERRCMD");
                    break;
                }
                default: {
                    System.out.println("0x" + Integer.toHexString(this.getErrorClass()));
                }
            }
            System.out.print("Error Text: ");
            System.out.println(SMBErrorText.ErrorString(this.getErrorClass(), this.getErrorCode()));
        }
        if (dumpRaw) {
            System.out.println("********** Raw SMB Data Dump **********");
            if (dumpAll) {
                HexDump.Dump(this.m_smbbuf, this.getLength(), 4);
            } else {
                HexDump.Dump(this.m_smbbuf, this.getLength() < 100 ? this.getLength() : 100, 4);
            }
        }
        System.out.println();
        System.out.flush();
    }
}

