/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.disk;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import org.filesys.server.filesys.FileAttribute;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.SearchContext;
import org.filesys.smb.server.disk.JavaNIODiskDriver;
import org.filesys.util.WildCard;

public class JavaNIOSearchContext
extends SearchContext {
    private Path m_root;
    private DirectoryStream<Path> m_stream;
    private Iterator<Path> m_pathIter;
    private int m_idx;
    private int m_attr;
    private boolean m_single;
    private WildCard m_wildcard;
    private String m_relPath;

    protected JavaNIOSearchContext() {
    }

    @Override
    public int getResumeId() {
        return this.m_idx;
    }

    @Override
    public boolean hasMoreFiles() {
        if (this.m_single && this.m_idx > 0) {
            return false;
        }
        if (this.m_stream == null || this.m_pathIter == null) {
            return false;
        }
        if (this.m_pathIter != null) {
            return this.m_pathIter.hasNext();
        }
        return true;
    }

    public final void initSinglePathSearch(Path singlePath) {
        this.m_root = singlePath;
        this.setSearchString(this.m_root.toString());
        this.setSingleFileSearch(true);
        this.m_idx = 0;
        this.m_stream = null;
        this.m_pathIter = null;
        this.m_wildcard = null;
        this.m_attr = 0;
    }

    public final void initWildcardSearch(Path folderPath, int attr, WildCard wildCard) throws IOException {
        this.m_root = folderPath;
        this.setSearchString(this.m_root.toString());
        this.m_attr = attr;
        this.m_wildcard = wildCard;
        this.setSingleFileSearch(false);
        this.m_idx = 0;
        this.m_stream = Files.newDirectoryStream(this.m_root);
        this.m_pathIter = this.m_stream.iterator();
    }

    protected final boolean isSingleFileSearch() {
        return this.m_single;
    }

    public final boolean isValidSearch() {
        return this.m_root != null;
    }

    @Override
    public boolean nextFileInfo(FileInfo info) {
        boolean infoValid = false;
        try {
            if (this.isSingleFileSearch()) {
                if (this.m_idx == 0) {
                    ++this.m_idx;
                    int fattr = 0;
                    long flen = 0L;
                    if (Files.isDirectory(this.m_root, LinkOption.NOFOLLOW_LINKS)) {
                        fattr = 16;
                    } else {
                        flen = Files.size(this.m_root);
                    }
                    if (!Files.isWritable(this.m_root)) {
                        ++fattr;
                    }
                    if (Files.isHidden(this.m_root)) {
                        fattr += 2;
                    }
                    if (fattr == 0) {
                        fattr = 128;
                    }
                    info.setFileName(this.m_root.getFileName().toString());
                    info.setSize(flen);
                    info.setFileAttributes(fattr);
                    info.setFileId(this.m_root.toString().hashCode());
                    FileTime modifyDate = Files.getLastModifiedTime(this.m_root, LinkOption.NOFOLLOW_LINKS);
                    long modifyDateMs = modifyDate.toMillis();
                    info.setModifyDateTime(modifyDateMs);
                    info.setChangeDateTime(modifyDateMs);
                    long dummyCreate = JavaNIODiskDriver.getGlobalCreateDateTime();
                    if (dummyCreate > modifyDateMs) {
                        dummyCreate = modifyDateMs;
                    }
                    info.setCreationDateTime(dummyCreate);
                    infoValid = true;
                }
            } else if (this.m_pathIter != null && this.m_pathIter.hasNext()) {
                boolean foundMatch = false;
                Path curPath = this.m_pathIter.next();
                ++this.m_idx;
                while (!foundMatch && curPath != null) {
                    if (this.m_wildcard.matchesPattern(curPath.getFileName().toString())) {
                        foundMatch = FileAttribute.hasAttribute(this.m_attr, 16) && Files.isDirectory(curPath, LinkOption.NOFOLLOW_LINKS) ? true : true;
                    }
                    if (foundMatch) continue;
                    if (this.m_pathIter.hasNext()) {
                        curPath = this.m_pathIter.next();
                        ++this.m_idx;
                        continue;
                    }
                    curPath = null;
                }
                if (curPath != null) {
                    int fattr = 0;
                    long flen = 0L;
                    long falloc = 0L;
                    String fname = curPath.getFileName().toString();
                    if (Files.isDirectory(curPath, LinkOption.NOFOLLOW_LINKS)) {
                        fattr = 16;
                        if (Files.isHidden(curPath)) {
                            fattr += 2;
                        }
                    } else {
                        flen = Files.size(curPath);
                        falloc = flen + 512L & 0xFFFFFFFFFFFFFE00L;
                        if (!Files.isWritable(curPath)) {
                            ++fattr;
                        }
                        if (Files.isHidden(curPath)) {
                            fattr += 2;
                        } else if (fname.equalsIgnoreCase("Desktop.ini") || fname.equalsIgnoreCase("Thumbs.db") || fname.startsWith(".")) {
                            fattr += 2;
                        }
                    }
                    info.setFileName(curPath.getFileName().toString());
                    info.setSize(flen);
                    info.setAllocationSize(falloc);
                    info.setFileAttributes(fattr);
                    StringBuffer relPath = new StringBuffer();
                    relPath.append(this.m_relPath);
                    relPath.append(curPath.getFileName().toString());
                    info.setFileId(relPath.toString().hashCode());
                    FileTime modifyDate = Files.getLastModifiedTime(curPath, LinkOption.NOFOLLOW_LINKS);
                    long modifyDateMs = modifyDate.toMillis();
                    info.setModifyDateTime(modifyDateMs);
                    info.setChangeDateTime(modifyDateMs);
                    long dummyCreate = JavaNIODiskDriver.getGlobalCreateDateTime();
                    if (dummyCreate > modifyDateMs) {
                        dummyCreate = modifyDateMs;
                    }
                    info.setCreationDateTime(dummyCreate);
                    infoValid = true;
                }
            }
        }
        catch (IOException ex) {
            infoValid = false;
        }
        return infoValid;
    }

    @Override
    public String nextFileName() {
        if (this.isSingleFileSearch()) {
            if (this.m_idx++ == 0) {
                return this.m_root.getFileName().toString();
            }
            return null;
        }
        if (this.m_pathIter != null && this.m_pathIter.hasNext()) {
            Path curPath = this.m_pathIter.next();
            while (curPath != null) {
                String fName = curPath.getFileName().toString();
                if (this.m_wildcard.matchesPattern(fName)) {
                    ++this.m_idx;
                    return fName;
                }
                curPath = this.m_pathIter.next();
            }
        }
        return null;
    }

    @Override
    public boolean restartAt(int resumeId) {
        if (this.m_stream == null || resumeId > this.m_idx) {
            return false;
        }
        try {
            this.m_stream = Files.newDirectoryStream(this.m_root);
            this.m_pathIter = this.m_stream.iterator();
        }
        catch (IOException ex) {
            return false;
        }
        this.m_idx = 0;
        while (this.m_pathIter.hasNext() && this.m_idx != resumeId) {
            this.m_pathIter.next();
            ++this.m_idx;
        }
        return this.m_pathIter.hasNext();
    }

    @Override
    public boolean restartAt(FileInfo info) {
        boolean restartOK = false;
        if (this.m_stream != null) {
            this.m_idx = 0;
            try {
                this.m_stream = Files.newDirectoryStream(this.m_root);
                this.m_pathIter = this.m_stream.iterator();
            }
            catch (IOException ex) {
                return false;
            }
            Path curPath = this.m_pathIter.next();
            ++this.m_idx;
            while (curPath != null && !restartOK) {
                if (curPath.getFileName().toString().equalsIgnoreCase(info.getFileName())) {
                    restartOK = true;
                    continue;
                }
                curPath = this.m_pathIter.next();
                ++this.m_idx;
            }
        }
        return restartOK;
    }

    protected final void setSingleFileSearch(boolean single) {
        this.m_single = single;
    }

    @Override
    public int numberOfEntries() {
        if (this.isSingleFileSearch()) {
            return 1;
        }
        return -1;
    }

    public final void setRelativePath(String relPath) {
        this.m_relPath = relPath;
        if (this.m_relPath != null && !this.m_relPath.endsWith("\\")) {
            this.m_relPath = this.m_relPath + "\\";
        }
    }
}

