/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.notify;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.NotifyAction;
import org.filesys.server.filesys.NotifyChange;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.notify.NotifyChangeEvent;
import org.filesys.smb.server.notify.NotifyChangeEventList;
import org.filesys.smb.server.notify.NotifyRequest;
import org.filesys.smb.server.notify.NotifyRequestList;

public class NotifyChangeHandler
implements Runnable {
    private NotifyRequestList m_notifyList;
    private Set<NotifyChange> m_globalNotifyMask = EnumSet.noneOf(NotifyChange.class);
    private DiskDeviceContext m_diskCtx;
    private Thread m_procThread;
    private NotifyChangeEventList m_eventList;
    private boolean m_debug = false;
    private boolean m_shutdown;

    public NotifyChangeHandler(DiskDeviceContext diskCtx) {
        this.m_diskCtx = diskCtx;
        this.m_eventList = new NotifyChangeEventList();
        this.m_procThread = new Thread(this);
        this.m_procThread.setDaemon(true);
        this.m_procThread.setName("Notify_" + this.m_diskCtx.getDeviceName());
        this.m_procThread.start();
    }

    public final void addNotifyRequest(NotifyRequest req) {
        if (this.m_notifyList == null) {
            this.m_notifyList = new NotifyRequestList();
        }
        req.setDiskContext(this.m_diskCtx);
        this.m_notifyList.addRequest(req);
        this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        this.removeNotifyRequest(req, true);
    }

    public final void removeNotifyRequest(NotifyRequest req, boolean updateMask) {
        if (this.m_notifyList == null) {
            return;
        }
        this.m_notifyList.removeRequest(req);
        if (updateMask) {
            this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
        }
    }

    public final void removeNotifyRequests(SMBSrvSession sess) {
        this.m_notifyList.removeAllRequestsForSession(sess);
        this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
    }

    public final boolean hasFileNameChange() {
        return this.hasFilterFlag(NotifyChange.FileName);
    }

    public final boolean hasDirectoryNameChange() {
        return this.hasFilterFlag(NotifyChange.DirectoryName);
    }

    public final boolean hasAttributeChange() {
        return this.hasFilterFlag(NotifyChange.Attributes);
    }

    public final boolean hasFileSizeChange() {
        return this.hasFilterFlag(NotifyChange.Size);
    }

    public final boolean hasFileWriteTimeChange() {
        return this.hasFilterFlag(NotifyChange.LastWrite);
    }

    public final boolean hasFileAccessTimeChange() {
        return this.hasFilterFlag(NotifyChange.LastAccess);
    }

    public final boolean hasFileCreateTimeChange() {
        return this.hasFilterFlag(NotifyChange.Creation);
    }

    public final boolean hasSecurityDescriptorChange() {
        return this.hasFilterFlag(NotifyChange.Security);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final Set<NotifyChange> getGlobalNotifyMask() {
        return this.m_globalNotifyMask;
    }

    public final int getRequestQueueSize() {
        return this.m_notifyList != null ? this.m_notifyList.numberOfRequests() : 0;
    }

    private final boolean hasFilterFlag(NotifyChange flag) {
        return this.m_globalNotifyMask.contains((Object)flag);
    }

    public final void notifyFileChanged(NotifyAction action, String path) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.FileName, action, path, false));
    }

    public final void notifyRename(String oldName, String newName) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileNameChange() && !this.hasDirectoryNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.FileName, NotifyAction.RenamedNewName, newName, oldName, false));
    }

    public final void notifyDirectoryChanged(NotifyAction action, String path) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasDirectoryNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.DirectoryName, action, path, true));
    }

    public final void notifyAttributesChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasAttributeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.Attributes, NotifyAction.Modified, path, isdir));
    }

    public final void notifyFileSizeChanged(String path) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileSizeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.Size, NotifyAction.Modified, path, false));
    }

    public final void notifyLastWriteTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileWriteTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.LastWrite, NotifyAction.Modified, path, isdir));
    }

    public final void notifyLastAccessTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileAccessTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.LastAccess, NotifyAction.Modified, path, isdir));
    }

    public final void notifyCreationTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasFileCreateTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.Creation, NotifyAction.Modified, path, isdir));
    }

    public final void notifySecurityDescriptorChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask().isEmpty() || !this.hasSecurityDescriptorChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(NotifyChange.Security, NotifyAction.Modified, path, isdir));
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void shutdownRequest() {
        if (this.m_procThread != null) {
            this.m_shutdown = true;
            this.m_procThread.interrupt();
        }
    }

    public final void sendBufferedNotifications(NotifyRequest req, NotifyChangeEventList evtList) {
        if (this.hasDebug()) {
            Debug.println("[Notify] Send buffered notifications, req=" + req + ", evtList=" + (evtList != null ? "" + evtList.numberOfEvents() : "null"));
        }
        long tmo = System.currentTimeMillis() + 10000L;
        if (req.hasNotifyEnum()) {
            block14: {
                SMBSrvPacket smbPkt = req.getSession().getProtocolHandler().buildChangeNotificationResponse(null, req);
                if (smbPkt != null) {
                    try {
                        req.getSession().sendAsynchResponseSMB(smbPkt, smbPkt.getLength());
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) break block14;
                        Debug.println("[Notify] Failed to send change notification, " + ex.getMessage());
                    }
                }
            }
            req.setCompleted(true, tmo);
            req.setNotifyEnum(false);
        } else if (evtList != null) {
            for (int i = 0; i < evtList.numberOfEvents(); ++i) {
                block15: {
                    SMBSrvPacket smbPkt;
                    NotifyChangeEvent evt = evtList.getEventAt(i);
                    String relName = FileName.makeRelativePath(req.getWatchPath(), evt.getFileName());
                    if (relName == null) {
                        relName = evt.getShortFileName();
                    }
                    if (this.hasDebug()) {
                        Debug.println("[Notify]   Notify evtPath=" + evt.getFileName() + ", reqPath=" + req.getWatchPath() + ", relative=" + relName);
                    }
                    if ((smbPkt = req.getSession().getProtocolHandler().buildChangeNotificationResponse(evt, req)) != null) {
                        try {
                            req.getSession().sendAsynchResponseSMB(smbPkt, smbPkt.getLength());
                        }
                        catch (Exception ex) {
                            if (!this.hasDebug()) break block15;
                            Debug.println("[Notify] Failed to send change notification, " + ex.getMessage());
                        }
                    }
                }
                req.setCompleted(true, tmo);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[Notify] sendBufferedNotifications() done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void queueNotification(NotifyChangeEvent evt) {
        if (this.hasDebug()) {
            Debug.println("[Notify] Queue notification event=" + evt.toString());
        }
        NotifyChangeEventList notifyChangeEventList = this.m_eventList;
        synchronized (notifyChangeEventList) {
            this.m_eventList.addEvent(evt);
            this.m_eventList.notifyAll();
        }
    }

    protected final int sendChangeNotification(NotifyChangeEvent evt) {
        List<NotifyRequest> reqList;
        if (this.hasDebug()) {
            Debug.println("[Notify] sendChangeNotification event=" + evt);
        }
        if ((reqList = this.findMatchingRequests(evt.getFilter(), evt.getFileName(), evt.isDirectory())) == null || reqList.size() == 0) {
            return 0;
        }
        if (this.hasDebug()) {
            Debug.println("[Notify]   Found " + reqList.size() + " matching change listeners");
            for (NotifyRequest req : reqList) {
                Debug.println("   Request=" + req);
            }
        }
        long tmo = System.currentTimeMillis() + 10000L;
        for (int i = 0; i < reqList.size(); ++i) {
            NotifyRequest req = reqList.get(i);
            if (!req.isCompleted()) {
                req.setCompleted(true, tmo);
                SMBSrvPacket smbPkt = req.getSession().getProtocolHandler().buildChangeNotificationResponse(evt, req);
                if (smbPkt != null) {
                    try {
                        if (!req.getSession().sendAsynchResponseSMB(smbPkt, smbPkt.getLength())) {
                            if (req.getSession().hasDebug(SMBSrvSession.Dbg.NOTIFY)) {
                                req.getSession().debugPrintln("  Notification request was queued, sess=" + req.getSession().getSessionId() + ", ID=" + req.getId());
                            }
                        } else if (req.getSession().hasDebug(SMBSrvSession.Dbg.NOTIFY)) {
                            req.getSession().debugPrintln("  Notification request was sent, sess=" + req.getSession().getSessionId() + ", ID=" + req.getId());
                        }
                    }
                    catch (Exception ex) {
                        Debug.println(ex);
                    }
                }
            } else {
                req.addEvent(evt);
                if (req.getSession().hasDebug(SMBSrvSession.Dbg.NOTIFY)) {
                    req.getSession().debugPrintln("Buffered notify req=" + req + ", event=" + evt + ", sess=" + req.getSession().getSessionId());
                }
            }
            req.getSession().setNotifyPending(false);
            if (!req.getSession().hasDebug(SMBSrvSession.Dbg.NOTIFY)) continue;
            req.getSession().debugPrintln("Asynch notify req=" + req + ", event=" + evt + ", sess=" + req.getSession().getUniqueId());
        }
        if (this.hasDebug()) {
            Debug.println("[Notify] sendChangeNotification() done");
        }
        return reqList.size();
    }

    protected final synchronized List<NotifyRequest> findMatchingRequests(Set<NotifyChange> filter, String path, boolean isdir) {
        ArrayList<NotifyRequest> reqList = new ArrayList<NotifyRequest>();
        String matchPath = path.toUpperCase();
        if (matchPath.length() == 0 || !matchPath.startsWith("\\")) {
            matchPath = "\\" + matchPath;
        }
        int idx = 0;
        long curTime = System.currentTimeMillis();
        boolean removedReq = false;
        while (idx < this.m_notifyList.numberOfRequests()) {
            NotifyRequest curReq = this.m_notifyList.getRequest(idx);
            if (this.hasDebug()) {
                Debug.println("[Notify] findMatchingRequests() req=" + curReq.toString());
            }
            if (curReq.hasExpired(curTime)) {
                this.m_notifyList.removeRequestAt(idx);
                if (this.hasDebug()) {
                    Debug.println("[Notify] Removed expired request req=" + curReq.toString());
                    if (curReq.getBufferedEventList() != null) {
                        NotifyChangeEventList bufList = curReq.getBufferedEventList();
                        Debug.println("[Notify]   Buffered events = " + bufList.numberOfEvents());
                        for (int b = 0; b < bufList.numberOfEvents(); ++b) {
                            Debug.println("    " + (b + 1) + ": " + bufList.getEventAt(b));
                        }
                    }
                }
                removedReq = true;
                continue;
            }
            if (curReq.containsFilter(filter)) {
                String[] paths;
                if (this.hasDebug()) {
                    Debug.println("[Notify]   hasFilter typ=" + filter + ", watchTree=" + curReq.hasWatchTree() + ", watchPath=" + curReq.getWatchPath() + ", matchPath=" + matchPath + ", isDir=" + isdir + ", addr=" + curReq.getSession().getRemoteAddress());
                }
                boolean wantReq = false;
                if (matchPath.length() == 0 && curReq.hasWatchTree()) {
                    wantReq = true;
                } else if (curReq.hasWatchTree() && matchPath.startsWith(curReq.getWatchPath())) {
                    wantReq = true;
                } else if (isdir && matchPath.compareTo(curReq.getWatchPath()) == 0) {
                    wantReq = true;
                } else if (!isdir && (paths = FileName.splitPath(matchPath)) != null && paths[0] != null && curReq.getWatchPath().equalsIgnoreCase(paths[0])) {
                    wantReq = true;
                }
                if (wantReq) {
                    curReq.getSession().setNotifyPending(true);
                    reqList.add(curReq);
                    if (this.hasDebug()) {
                        Debug.println("[Notify]   Added request to matching list");
                    }
                } else if (this.hasDebug()) {
                    Debug.println("[Notify] Match failed for filter=" + filter + ", path=" + path + ", isDir=" + isdir + ", req=" + curReq);
                }
            } else if (this.hasDebug()) {
                Debug.println("[Notify] Not matched filter typ=" + filter + ", watchTree=" + curReq.hasWatchTree() + ", watchPath=" + curReq.getWatchPath() + ", matchPath=" + matchPath + ", isDir=" + isdir + ", addr=" + curReq.getSession().getRemoteAddress());
            }
            ++idx;
        }
        if (removedReq) {
            this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
        }
        return reqList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (!this.m_shutdown) {
            NotifyChangeEventList notifyChangeEventList = this.m_eventList;
            synchronized (notifyChangeEventList) {
                try {
                    this.m_eventList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.m_shutdown) break;
            while (this.m_eventList.numberOfEvents() > 0) {
                NotifyChangeEvent evt = null;
                NotifyChangeEventList notifyChangeEventList2 = this.m_eventList;
                synchronized (notifyChangeEventList2) {
                    evt = this.m_eventList.removeEventAt(0);
                }
                if (evt == null) continue block10;
                try {
                    int cnt = this.sendChangeNotification(evt);
                    if (!this.hasDebug()) continue;
                    Debug.println("[Notify] Change notify event=" + evt.toString() + ", clients=" + cnt);
                }
                catch (Throwable ex) {
                    Debug.println("NotifyChangeHandler thread");
                    Debug.println(ex);
                }
            }
        }
        if (this.hasDebug()) {
            Debug.println("NotifyChangeHandler thread exit");
        }
    }
}

