/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.notify;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyChange;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.notify.NotifyRequest;

public class NotifyRequestList {
    private List<NotifyRequest> m_requests = new ArrayList<NotifyRequest>();

    public final synchronized NotifyRequest getRequest(int idx) {
        if (idx >= this.m_requests.size()) {
            return null;
        }
        return this.m_requests.get(idx);
    }

    public final synchronized Set<NotifyChange> getGlobalFilter() {
        EnumSet<NotifyChange> filter = EnumSet.noneOf(NotifyChange.class);
        if (this.m_requests.size() > 0) {
            for (int i = 0; i < this.m_requests.size(); ++i) {
                NotifyRequest req = this.m_requests.get(i);
                filter.addAll(req.getFilter());
            }
        }
        return filter;
    }

    public final synchronized void addRequest(NotifyRequest req) {
        this.m_requests.add(req);
    }

    public final synchronized NotifyRequest findRequest(int mid, int tid, int uid, int pid) {
        for (int i = 0; i < this.m_requests.size(); ++i) {
            NotifyRequest curReq = this.m_requests.get(i);
            if (curReq.getId() != (long)mid || curReq.getTreeId() != tid || curReq.getUserId() != uid || curReq.getProcessId() != pid) continue;
            return curReq;
        }
        return null;
    }

    public final synchronized NotifyRequest findRequest(long mid) {
        for (int i = 0; i < this.m_requests.size(); ++i) {
            NotifyRequest curReq = this.m_requests.get(i);
            if (curReq.getId() != mid) continue;
            return curReq;
        }
        return null;
    }

    public final synchronized NotifyRequest findRequest(NetworkFile dir, Set<NotifyChange> filter, boolean watchTree) {
        for (int i = 0; i < this.m_requests.size(); ++i) {
            NotifyRequest curReq = this.m_requests.get(i);
            if (curReq.getDirectory() != dir || curReq.getFilter() != filter || curReq.hasWatchTree() != watchTree) continue;
            return curReq;
        }
        return null;
    }

    public final synchronized NotifyRequest removeRequest(NotifyRequest req) {
        for (int i = 0; i < this.m_requests.size(); ++i) {
            NotifyRequest curReq = this.m_requests.get(i);
            if (curReq != req) continue;
            this.m_requests.remove(i);
            return curReq;
        }
        return null;
    }

    public final synchronized NotifyRequest removeRequestAt(int idx) {
        if (idx < 0 || idx >= this.m_requests.size()) {
            return null;
        }
        return this.m_requests.remove(idx);
    }

    public final synchronized void removeAllRequestsForSession(SMBSrvSession sess) {
        int idx = 0;
        while (idx < this.m_requests.size()) {
            NotifyRequest curReq = this.m_requests.get(idx);
            if (curReq.getSession() == sess) {
                this.m_requests.remove(idx);
                continue;
            }
            ++idx;
        }
    }

    public final synchronized void removeAllRequestsForSession(SMBSrvSession sess, int tid) {
        int idx = 0;
        while (idx < this.m_requests.size()) {
            NotifyRequest curReq = this.m_requests.get(idx);
            if (curReq.getSession() == sess && curReq.getTreeId() == tid) {
                this.m_requests.remove(idx);
                continue;
            }
            ++idx;
        }
    }

    public final synchronized void clearRequestList() {
        this.m_requests.clear();
    }

    public final synchronized int numberOfRequests() {
        return this.m_requests.size();
    }
}

