/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import java.net.InetAddress;
import java.util.StringTokenizer;
import org.filesys.util.DataPacker;

public class IPAddress {
    public static final boolean isNumericAddress(String ipaddr) {
        if (ipaddr == null || ipaddr.length() < 7 || ipaddr.length() > 15) {
            return false;
        }
        StringTokenizer token = new StringTokenizer(ipaddr, ".");
        if (token.countTokens() != 4) {
            return false;
        }
        while (token.hasMoreTokens()) {
            String ipNum = token.nextToken();
            try {
                int ipVal = Integer.valueOf(ipNum);
                if (ipVal >= 0 && ipVal <= 255) continue;
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    public static final int parseNumericAddress(String ipaddr) {
        if (ipaddr == null || ipaddr.length() < 7 || ipaddr.length() > 15) {
            return 0;
        }
        StringTokenizer token = new StringTokenizer(ipaddr, ".");
        if (token.countTokens() != 4) {
            return 0;
        }
        int ipInt = 0;
        while (token.hasMoreTokens()) {
            String ipNum = token.nextToken();
            try {
                int ipVal = Integer.valueOf(ipNum);
                if (ipVal < 0 || ipVal > 255) {
                    return 0;
                }
                ipInt = (ipInt << 8) + ipVal;
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return ipInt;
    }

    public static final int asInteger(InetAddress ipaddr) {
        byte[] addrBytes = ipaddr.getAddress();
        return DataPacker.getInt(addrBytes, 0);
    }

    public static final boolean isInSubnet(String ipaddr, String subnet, String mask) {
        int ipaddrInt = IPAddress.parseNumericAddress(ipaddr);
        if (ipaddrInt == 0) {
            return false;
        }
        int subnetInt = IPAddress.parseNumericAddress(subnet);
        if (subnetInt == 0) {
            return false;
        }
        int maskInt = IPAddress.parseNumericAddress(mask);
        if (maskInt == 0) {
            return false;
        }
        return (ipaddrInt & maskInt) == subnetInt;
    }

    public static final String asString(byte[] ipaddr) {
        if (ipaddr == null || ipaddr.length != 4) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        str.append(ipaddr[0] & 0xFF);
        str.append(".");
        str.append(ipaddr[1] & 0xFF);
        str.append(".");
        str.append(ipaddr[2] & 0xFF);
        str.append(".");
        str.append(ipaddr[3] & 0xFF);
        return str.toString();
    }

    public static final String asString(int ipaddr) {
        byte[] ipbyts = new byte[]{(byte)(ipaddr >> 24 & 0xFF), (byte)(ipaddr >> 16 & 0xFF), (byte)(ipaddr >> 8 & 0xFF), (byte)(ipaddr & 0xFF)};
        return IPAddress.asString(ipbyts);
    }

    public static final byte[] asBytes(String addr) {
        int ipInt = IPAddress.parseNumericAddress(addr);
        if (ipInt == 0) {
            return null;
        }
        byte[] ipByts = new byte[4];
        ipByts[3] = (byte)(ipInt & 0xFF);
        ipByts[2] = (byte)(ipInt >> 8 & 0xFF);
        ipByts[1] = (byte)(ipInt >> 16 & 0xFF);
        ipByts[0] = (byte)(ipInt >> 24 & 0xFF);
        return ipByts;
    }
}

