/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.util.db.DBCallbacks;
import org.filesys.util.db.DBConnectionPoolListener;
import org.filesys.util.db.DBStatus;

public class DBConnectionPool {
    public static final long PermanentLease = -1L;
    public static final int MinimumConnections = 5;
    public static final int MaximumConnections = 500;
    public static final int DefaultMinSize = 5;
    public static final int DefaultMaxSize = 10;
    private static final long DefaultLease = 30000L;
    private static final int ConnectionCheck = 20;
    private String m_dbDriver;
    private String m_dsn;
    private String m_user;
    private String m_password;
    private int m_minPoolSize = 5;
    private int m_maxPoolSize = 10;
    private long m_leaseTime = 30000L;
    private List<Connection> m_freePool;
    private Hashtable<Connection, Long> m_allocPool;
    private DBConnectionReaper m_reaper;
    private Thread m_reaperThread;
    private boolean m_online;
    private DBConnectionPoolListener m_dbListener;
    private DBCallbacks m_callback;

    public DBConnectionPool(String driver, String dsn, String user, String pwd) throws Exception {
        this.m_dbDriver = driver;
        this.m_dsn = dsn;
        this.m_user = user;
        this.m_password = pwd;
        this.commonConstructor();
    }

    public DBConnectionPool(String driver, String dsn, String user, String pwd, int initConns, int maxConns) throws Exception {
        this.m_dbDriver = driver;
        this.m_dsn = dsn;
        this.m_user = user;
        this.m_password = pwd;
        if (initConns > 0) {
            this.m_minPoolSize = initConns;
        }
        if (maxConns > 0) {
            this.m_maxPoolSize = maxConns;
        }
        this.commonConstructor();
    }

    public DBConnectionPool(String driver, String dsn, String user, String pwd, int initConns, int maxConns, DBCallbacks callback) throws Exception {
        this.m_dbDriver = driver;
        this.m_dsn = dsn;
        this.m_user = user;
        this.m_password = pwd;
        this.m_callback = callback;
        if (initConns > 0) {
            this.m_minPoolSize = initConns;
        }
        if (maxConns > 0) {
            this.m_maxPoolSize = maxConns;
        }
        this.commonConstructor();
    }

    private void commonConstructor() throws Exception {
        Class.forName(this.m_dbDriver).newInstance();
        this.m_freePool = new ArrayList<Connection>();
        this.m_allocPool = new Hashtable();
        this.m_reaper = new DBConnectionReaper(this.getLeaseTime());
        this.m_reaperThread = new Thread(this.m_reaper);
        this.m_reaperThread.setDaemon(true);
        this.m_reaperThread.setName("DBConnectionReaper");
        this.m_reaperThread.start();
    }

    public final String getDriver() {
        return this.m_dbDriver;
    }

    public final String getDSN() {
        return this.m_dsn;
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final int getMinimumPoolSize() {
        return this.m_minPoolSize;
    }

    public final int getMaximumPoolSize() {
        return this.m_maxPoolSize;
    }

    public final long getLeaseTime() {
        return this.m_leaseTime;
    }

    public final synchronized int getAvailableConnections() {
        return this.m_freePool.size();
    }

    public final synchronized int getAllocatedConnections() {
        return this.m_allocPool.size();
    }

    public final Connection getConnection() {
        long expireTime = System.currentTimeMillis() + this.getLeaseTime();
        return this.getConnection(expireTime);
    }

    public final boolean isOnline() {
        return this.m_online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(long expireTime) {
        Connection conn = null;
        Object object = this.m_freePool;
        synchronized (object) {
            if (this.m_freePool.size() > 0) {
                conn = this.m_freePool.remove(0);
                try {
                    if (conn.isClosed()) {
                        conn = null;
                    }
                }
                catch (SQLException ex) {
                    conn = null;
                    Debug.println("%%%%% SQL Connection Error: " + ex.toString());
                }
            } else if (!this.isOnline()) {
                try {
                    conn = this.createConnection();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        if (!this.isOnline()) {
            if (conn != null) {
                this.m_online = true;
                this.notifyConnectionPoolState();
            } else {
                return null;
            }
        }
        object = this.m_allocPool;
        synchronized (object) {
            if (conn != null) {
                this.m_allocPool.put(conn, new Long(expireTime));
            } else if (this.m_allocPool.size() < this.getMaximumPoolSize()) {
                try {
                    conn = this.createConnection();
                    this.m_allocPool.put(conn, new Long(expireTime));
                }
                catch (SQLException ex) {
                    conn = null;
                    Debug.println("%%%%% SQL Connection Error: " + ex.toString());
                }
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseConnection(Connection conn) {
        Object object = this.m_allocPool;
        synchronized (object) {
            Long curConn = this.m_allocPool.remove(conn);
            if (curConn == null) {
                return;
            }
        }
        object = this.m_freePool;
        synchronized (object) {
            try {
                if (!conn.isClosed()) {
                    this.m_freePool.add(conn);
                } else {
                    Debug.println("***** Connection closed *****");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void renewLease(Connection conn) {
        this.renewLease(conn, System.currentTimeMillis() + this.getLeaseTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renewLease(Connection conn, long expireTime) {
        Hashtable<Connection, Long> hashtable = this.m_allocPool;
        synchronized (hashtable) {
            if (this.m_allocPool.remove(conn) == null) {
                return;
            }
            this.m_allocPool.put(conn, new Long(expireTime));
        }
    }

    public final void closePool() {
        Connection conn;
        this.m_reaper.shutdownRequest();
        if (this.m_allocPool.size() > 0) {
            Enumeration<Connection> enm = this.m_allocPool.keys();
            while (enm.hasMoreElements()) {
                conn = enm.nextElement();
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.m_allocPool.clear();
        }
        if (this.m_freePool.size() > 0) {
            for (int i = 0; i < this.m_freePool.size(); ++i) {
                conn = this.m_freePool.get(i);
                try {
                    conn.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.m_freePool.clear();
        }
    }

    public final void setPoolSize(int initSize, int maxSize) {
        this.m_minPoolSize = initSize;
        this.m_maxPoolSize = maxSize;
    }

    public final void setDefaultLeaseTime(long leaseTime) {
        this.m_leaseTime = leaseTime;
    }

    public final void setOnlineCheckInterval(int interval) {
        int wakeups = interval / 30000;
        if (wakeups < 1) {
            wakeups = 1;
        }
        this.m_reaper.setOnlineCheckInterval(wakeups);
    }

    public final boolean hasConnectionPoolListener() {
        return this.m_dbListener != null;
    }

    public final void addConnectionPoolListener(DBConnectionPoolListener l) {
        this.m_dbListener = l;
    }

    public final DBConnectionPoolListener removeConnectionPoolListener() {
        DBConnectionPoolListener l = this.m_dbListener;
        this.m_dbListener = null;
        return l;
    }

    protected final Connection createConnection() throws SQLException {
        if (this.m_callback != null) {
            return this.m_callback.createConnectionForPool(this.getDSN(), this.getUserName(), this.getPassword());
        }
        return DriverManager.getConnection(this.getDSN(), this.getUserName(), this.getPassword());
    }

    protected final void notifyConnectionPoolState() {
        Debug.println("DBConnectionPool: Database server is " + (this.isOnline() ? "OnLine" : "OffLine"));
        if (this.hasConnectionPoolListener()) {
            this.m_dbListener.databaseOnlineStatus(this.isOnline() ? DBStatus.Online : DBStatus.Offline);
        } else {
            Debug.println("DBConnectionPool: No listener");
        }
    }

    public final boolean waitForConnection(int waitSecs) {
        Connection dbConn = null;
        long timeEnd = System.currentTimeMillis() + (long)waitSecs * 1000L;
        while (dbConn == null && System.currentTimeMillis() < timeEnd) {
            try {
                dbConn = this.createConnection();
            }
            catch (SQLException sQLException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dbConn != null) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return dbConn != null;
    }

    protected class DBConnectionReaper
    implements Runnable {
        private static final boolean DEBUG = false;
        private long m_wakeup;
        private boolean m_shutdown = false;
        private int m_onlineCheckInterval = 20;

        public DBConnectionReaper(long intvl) {
            this.m_wakeup = intvl;
        }

        public final void shutdownRequest() {
            this.m_shutdown = true;
            DBConnectionPool.this.m_reaperThread.interrupt();
        }

        public final void setOnlineCheckInterval(int interval) {
            this.m_onlineCheckInterval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            List list = DBConnectionPool.this.m_freePool;
            synchronized (list) {
                try {
                    while (DBConnectionPool.this.m_freePool.size() < DBConnectionPool.this.getMinimumPoolSize()) {
                        Connection conn = DBConnectionPool.this.createConnection();
                        if (conn == null) continue;
                        DBConnectionPool.this.m_freePool.add(conn);
                    }
                    DBConnectionPool.this.m_online = true;
                    DBConnectionPool.this.notifyConnectionPoolState();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            int loopCnt = 1;
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_shutdown) {
                    return;
                }
                ++loopCnt;
                Object object = DBConnectionPool.this.m_allocPool;
                synchronized (object) {
                    long timeNow = System.currentTimeMillis();
                    Enumeration enm = DBConnectionPool.this.m_allocPool.keys();
                    boolean removeConn = false;
                    while (enm.hasMoreElements()) {
                        Connection conn = (Connection)enm.nextElement();
                        Long expire = (Long)DBConnectionPool.this.m_allocPool.get(conn);
                        if (expire != -1L && expire < timeNow) {
                            removeConn = true;
                        } else if (expire == -1L) {
                            try {
                                if (conn.isClosed()) {
                                    removeConn = true;
                                } else {
                                    boolean autoCommit = conn.getAutoCommit();
                                    conn.setAutoCommit(true);
                                    conn.setAutoCommit(autoCommit);
                                }
                            }
                            catch (SQLException ex) {
                                removeConn = true;
                            }
                            if (removeConn) {
                                Debug.println("DBConnectionReaper Permanent lease connection error");
                            }
                        }
                        if (!removeConn) continue;
                        DBConnectionPool.this.m_allocPool.remove(conn);
                        try {
                            conn.close();
                            Debug.println("DBConnectionReaper closed expired connection, conn=" + conn);
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                object = DBConnectionPool.this.m_freePool;
                synchronized (object) {
                    while (DBConnectionPool.this.m_freePool.size() > DBConnectionPool.this.getMaximumPoolSize()) {
                        Connection conn = (Connection)DBConnectionPool.this.m_freePool.remove(0);
                        if (conn == null) continue;
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (loopCnt % this.m_onlineCheckInterval != 0 && DBConnectionPool.this.isOnline()) continue;
                }
                object = DBConnectionPool.this.m_freePool;
                synchronized (object) {
                    Connection conn;
                    int idx = 0;
                    while (idx < DBConnectionPool.this.m_freePool.size()) {
                        conn = (Connection)DBConnectionPool.this.m_freePool.get(idx);
                        try {
                            if (conn.isClosed()) {
                                DBConnectionPool.this.m_freePool.remove(idx);
                                continue;
                            }
                            boolean autoCommit = conn.getAutoCommit();
                            conn.setAutoCommit(true);
                            conn.setAutoCommit(autoCommit);
                            ++idx;
                        }
                        catch (SQLException ex) {
                            try {
                                DBConnectionPool.this.m_freePool.remove(idx);
                                conn.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (DBConnectionPool.this.isOnline()) {
                        if (DBConnectionPool.this.m_freePool.size() == 0 && DBConnectionPool.this.m_allocPool.size() == 0) {
                            DBConnectionPool.this.m_online = false;
                            DBConnectionPool.this.notifyConnectionPoolState();
                        }
                    } else {
                        conn = DBConnectionPool.this.getConnection();
                        if (conn != null) {
                            DBConnectionPool.this.releaseConnection(conn);
                        }
                    }
                }
            }
        }
    }
}

