/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.config.ConfigElement;

public class ConfigElementAdapter
implements ConfigElement {
    private String m_name;
    private String m_value;
    private Map<String, String> m_attributes;
    private List<ConfigElement> m_children;
    private Pattern m_envTokens = Pattern.compile("\\$\\{\\w+\\}");

    public ConfigElementAdapter(String name, String value) {
        this.m_name = name;
        this.m_value = this.convertEnvVars(value);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getAttribute(String name) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this.m_attributes != null) {
            return this.m_attributes.containsKey(name);
        }
        return false;
    }

    @Override
    public int getAttributeCount() {
        if (this.m_attributes != null) {
            return this.m_attributes.size();
        }
        return 0;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    @Override
    public ConfigElement getChild(String name) {
        if (this.m_children != null) {
            for (ConfigElement child : this.m_children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public List<ConfigElement> getChildren() {
        return this.m_children;
    }

    @Override
    public boolean hasChildren() {
        if (this.m_children == null) {
            return false;
        }
        return this.m_children.size() > 0;
    }

    @Override
    public int getChildCount() {
        if (this.m_children != null) {
            return this.m_children.size();
        }
        return 0;
    }

    @Override
    public ConfigElement combine(ConfigElement configElement) {
        return null;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public void setValue(String value) {
        this.m_value = this.convertEnvVars(value);
    }

    @Override
    public void addAttribute(String attrName, String attrVal) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap<String, String>();
        }
        this.m_attributes.put(attrName, this.convertEnvVars(attrVal));
    }

    @Override
    public void addChild(ConfigElement child) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<ConfigElement>();
        }
        this.m_children.add(child);
    }

    protected final String convertEnvVars(String val) {
        if (val != null) {
            Matcher matcher = this.m_envTokens.matcher(val);
            StringBuffer valOut = new StringBuffer(val.length());
            while (matcher.find()) {
                String token = val.substring(matcher.start(), matcher.end());
                String envVar = token.substring(2, token.length() - 1);
                String envValue = System.getenv(envVar);
                if (envValue == null) continue;
                matcher.appendReplacement(valOut, envValue);
            }
            if (valOut.length() > 0) {
                val = valOut.toString();
            }
        }
        return val;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append("=");
        str.append(this.getValue());
        str.append(",Attrs=");
        str.append(this.getAttributeCount());
        str.append(",Children=");
        str.append(this.getChildCount());
        str.append("]");
        return str.toString();
    }
}

