/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.util.CanEstimateSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<Key, Value extends CanEstimateSize> {
    private final EvictAction<Value> onEvict;
    private final CreateAction<Key, Value> createAction;
    private final int maxSizeEntries;
    private final long maxSizeBytes;
    private long currentSize;
    private final Map<Key, Value> cache = new LinkedHashMap<Key, Value>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
            if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                return false;
            }
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                if (this.size() <= LruCache.this.maxSizeEntries && LruCache.this.currentSize <= LruCache.this.maxSizeBytes) {
                    return false;
                }
                Map.Entry entry = it.next();
                LruCache.this.evictValue((CanEstimateSize)entry.getValue());
                long valueSize = ((CanEstimateSize)entry.getValue()).getSize();
                if (valueSize > 0L) {
                    LruCache.this.currentSize -= valueSize;
                }
                it.remove();
            }
            return false;
        }
    };

    private void evictValue(Value value) {
        try {
            this.onEvict.evict(value);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public LruCache(int maxSizeEntries, long maxSizeBytes, CreateAction<Key, Value> createAction, EvictAction<Value> onEvict) {
        this.maxSizeEntries = maxSizeEntries;
        this.maxSizeBytes = maxSizeBytes;
        this.createAction = createAction;
        this.onEvict = onEvict;
    }

    public Value borrow(Key key) throws SQLException {
        CanEstimateSize value = (CanEstimateSize)this.cache.remove(key);
        if (value == null) {
            return (Value)((CanEstimateSize)this.createAction.create(key));
        }
        this.currentSize -= value.getSize();
        return (Value)value;
    }

    public void put(Key key, Value value) {
        long valueSize = value.getSize();
        if (this.maxSizeBytes == 0L || this.maxSizeEntries == 0 || valueSize * 2L > this.maxSizeBytes) {
            this.evictValue(value);
            return;
        }
        this.currentSize += valueSize;
        this.cache.put(key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CreateAction<Key, Value> {
        public Value create(Key var1) throws SQLException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictAction<Value> {
        public void evict(Value var1) throws SQLException;
    }
}

