/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.mysql;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class MySQLNamedLockTemplate {
    private static final Log LOG = LogFactory.getLog(MySQLNamedLockTemplate.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockName;

    MySQLNamedLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockName = "Flyway-" + discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        try {
            this.jdbcTemplate.execute("SELECT GET_LOCK('" + this.lockName + "',100000)", new Object[0]);
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire MySQL named lock: " + this.lockName, e);
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e);
            throw rethrow;
        }
        finally {
            try {
                this.jdbcTemplate.execute("SELECT RELEASE_LOCK('" + this.lockName + "')", new Object[0]);
            }
            catch (SQLException e) {
                LOG.error("Unable to release MySQL named lock: " + this.lockName, e);
            }
        }
    }
}

