/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.Resource;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final DbSupport dbSupport;
    private final PlaceholderReplacer placeholderReplacer;
    private final Resource sqlScriptResource;
    private final FlywayConfiguration configuration;
    private SqlScript sqlScript;

    public SqlMigrationExecutor(DbSupport dbSupport, Resource sqlScriptResource, PlaceholderReplacer placeholderReplacer, FlywayConfiguration configuration) {
        this.dbSupport = dbSupport;
        this.sqlScriptResource = sqlScriptResource;
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
    }

    @Override
    public void execute(Connection connection) {
        this.getSqlScript().execute(new JdbcTemplate(connection, 0));
    }

    private synchronized SqlScript getSqlScript() {
        if (this.sqlScript == null) {
            this.sqlScript = new SqlScript(this.dbSupport, this.sqlScriptResource, this.placeholderReplacer, this.configuration.getEncoding(), this.configuration.isAllowMixedMigrations());
        }
        return this.sqlScript;
    }

    @Override
    public boolean executeInTransaction() {
        return this.getSqlScript().executeInTransaction();
    }
}

