package org.freehep.application.studio;

/** 
 * Directory where the library is installed.
 */
public enum PluginDir {
    
    BUILTIN("built-in"), 
    SYSTEM("system"), 
    GROUP("group"), 
    USER("user");
    
    private String label;
    
    PluginDir(String label) {
        this.label = label;
    }
    
    public String getLabel() {
        return label;
    }
    
    public static PluginDir[] searchOrder() {
        return new PluginDir[] {BUILTIN, USER, GROUP, SYSTEM};
    }
    
    public static PluginDir[] inverseSearchOrder() {
        return new PluginDir[] {SYSTEM, GROUP, USER, BUILTIN};
    }
    
    public static PluginDir[] sgu() {
        return new PluginDir[] {SYSTEM, GROUP, USER};
    }
  
}
