package org.freehep.application.studio.pluginmanager;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

/**
 *
 * @author tonyj
 * @version $Id: PluginPreferences.java 14095 2013-01-29 20:57:42Z tonyj $
 */
class PluginPreferences extends javax.swing.JPanel {

    private PluginManager manager;

    /**
     * Creates new form PluginPreferences
     */
    public PluginPreferences(PluginManager manager) {
        this.manager = manager;
        initComponents();
    }

    boolean apply() {
        try {
            manager.setCheckURL(new URL(url.getText()));
            manager.setCheckAtStart(checkAtStart.isSelected());
            return true;
        } catch (MalformedURLException x) {
            JOptionPane.showMessageDialog(this, x.getMessage(), "Error...", JOptionPane.ERROR_MESSAGE);
            url.requestFocus();
            return false;
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        checkAtStart = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        url = new javax.swing.JTextField();
        restoreDefaultButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        checkAtStart.setSelected(manager.isCheckAtStart());
        checkAtStart.setText("Check for updated plugins at startup");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(checkAtStart, gridBagConstraints);

        jLabel1.setText("URL:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 3);
        add(jLabel1, gridBagConstraints);

        url.setColumns(30);
        url.setText(manager.getCheckURL().toExternalForm());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(url, gridBagConstraints);

        restoreDefaultButton.setText("Restore Defaults");
        restoreDefaultButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                restoreDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(restoreDefaultButton, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

   private void restoreDefaultButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_restoreDefaultButtonActionPerformed
   {//GEN-HEADEREND:event_restoreDefaultButtonActionPerformed
       checkAtStart.setSelected(true);
       url.setText(manager.getApplication().getAppProperties().getProperty("PluginManager.URL"));
   }//GEN-LAST:event_restoreDefaultButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox checkAtStart;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton restoreDefaultButton;
    private javax.swing.JTextField url;
    // End of variables declaration//GEN-END:variables
}
