/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitmethod;

import hep.aida.IFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IFitMethod;

public abstract class AbstractFitMethod
implements IFitMethod {
    private String[] fitMethodNames;
    private int fitType;
    private Object correlationObject;

    public AbstractFitMethod(int fitType, String[] fitMethodNames) {
        this.fitType = fitType;
        this.fitMethodNames = fitMethodNames;
    }

    public int fitType() {
        return this.fitType;
    }

    public String[] fitMethodNames() {
        return this.fitMethodNames;
    }

    public double[] evaluateGradient(int dimension, IDevFitDataIterator dataIter, IFunction function) {
        if (this.correlationObject() != null) {
            throw new IllegalArgumentException("Correlation Object not used by this fit method.");
        }
        dataIter.start();
        double[] fitFunctionGradients = new double[dimension];
        while (dataIter.next()) {
            double[] grad = this.evaluateGradientSumElement(dataIter, function);
            for (int i = 0; i < dimension; ++i) {
                int n = i;
                fitFunctionGradients[n] = fitFunctionGradients[n] + grad[i];
            }
        }
        return fitFunctionGradients;
    }

    public double evaluate(IDevFitDataIterator dataIter, IFunction function) {
        if (this.correlationObject() != null) {
            throw new IllegalArgumentException("Correlation Object not used by this fit method.");
        }
        dataIter.start();
        double fitFunctionValue = 0.0;
        while (dataIter.next()) {
            fitFunctionValue += this.evaluateSumElement(dataIter, function);
        }
        return fitFunctionValue;
    }

    public void setCorrelationObject(Object correlationObj) {
        this.correlationObject = correlationObj;
    }

    public void clear() {
        this.correlationObject = null;
    }

    public Object correlationObject() {
        return this.correlationObject;
    }
}

