/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.ICloud;
import hep.aida.IHistogram;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.AbstractBaseHistogram;
import java.util.EventObject;
import java.util.Map;

public abstract class Cloud
extends AbstractBaseHistogram
implements ICloud,
IsObservable {
    protected int arraySize;
    protected int maxEntries;
    private boolean autoConvert;
    public static final int CLOUD_ARRAY_ENTRIES = 1000;
    private String options = "";
    private double margin = 0.05;
    protected int validEntries = 0;

    protected Cloud(String name, String title, int dimension, int maxEntries, String options) {
        super(name, title, dimension, options);
        this.initCloud(maxEntries, options);
    }

    protected EventObject createEvent() {
        return new HistogramEvent(this);
    }

    public void reset() {
        super.reset();
        this.validEntries = 0;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public abstract double sumOfWeights();

    public abstract void convertToHistogram();

    public abstract boolean isConverted();

    public abstract void scale(double var1);

    protected boolean autoConvert() {
        return this.autoConvert;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public String getOptions() {
        return this.options;
    }

    public void initCloud(int maxEntries, String options) {
        Map optionMap;
        String autoconv;
        this.maxEntries = maxEntries;
        if (options != null) {
            this.options = options;
        }
        this.autoConvert = (autoconv = (String)(optionMap = AidaUtils.parseOptions(options)).get("autoconvert")) == null ? true : Boolean.valueOf(autoconv);
        if (maxEntries < 0) {
            this.autoConvert = false;
        }
        this.arraySize = maxEntries <= 0 ? 1000 : (maxEntries > 1000 ? 1000 : maxEntries);
        String marginStr = (String)optionMap.get("margin");
        if (marginStr != null) {
            try {
                double tmpMargin = Double.valueOf(marginStr);
                if (tmpMargin < 0.0) {
                    throw new IllegalArgumentException("Illegal margin " + tmpMargin + "; it cannot be negative");
                }
                this.margin = tmpMargin;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Illegal value for margin option " + marginStr + ". It has to be a positive double.");
            }
        }
    }

    protected double margin() {
        return this.margin;
    }

    protected abstract IHistogram hist();

    public int nanEntries() {
        if (this.isConverted()) {
            return this.hist().nanEntries();
        }
        return this.entries() - this.validEntries;
    }
}

