/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IAnnotation;
import hep.aida.IProfile2D;
import jas.hist.ExtendedStatistics;
import java.util.ArrayList;

class AIDAProfileStatistics2D
implements ExtendedStatistics {
    private IProfile2D profile;
    private String[] statNames = new String[]{"Entries", "XMean", "XRms", "YMean", "YRms"};
    private final String nanExtStat = "NaN";
    private final String sumOfWeightsStat = "SumOfWeights";
    private final String outOfRangeStat = "OutOfRange";

    AIDAProfileStatistics2D(IProfile2D profile) {
        this.profile = profile;
    }

    public String[] getStatisticNames() {
        int i;
        IAnnotation an;
        ArrayList<String> stat = new ArrayList<String>();
        for (int i2 = 0; i2 < this.statNames.length; ++i2) {
            stat.add(this.statNames[i2]);
        }
        if ((Integer)this.getExtendedStatistic("OutOfRange") != 0) {
            stat.add("OutOfRange");
        }
        if ((Integer)this.getExtendedStatistic("NaN") != 0) {
            stat.add("NaN");
        }
        if ((double)((Integer)this.getExtendedStatistic("Entries")).intValue() != (Double)this.getExtendedStatistic("SumOfWeights")) {
            stat.add("SumOfWeights");
        }
        if ((an = this.profile.annotation()) != null) {
            int n = an.size();
            for (i = 0; i < n; ++i) {
                try {
                    String key = an.key(i);
                    if (!key.toLowerCase().startsWith("stat.") && !key.toLowerCase().startsWith("stat:")) continue;
                    stat.add(key.substring(5));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        String[] statArray = new String[stat.size()];
        for (i = 0; i < stat.size(); ++i) {
            statArray[i] = (String)stat.get(i);
        }
        return statArray;
    }

    public double getStatistic(String name) {
        if (name.equals("XMean")) {
            return this.profile.meanX();
        }
        if (name.equals("XRms")) {
            return this.profile.rmsX();
        }
        if (name.equals("YMean")) {
            return this.profile.meanY();
        }
        if (name.equals("YRms")) {
            return this.profile.rmsY();
        }
        return 0.0;
    }

    public Object getExtendedStatistic(String name) {
        if (name.equals("Entries")) {
            return new Integer(this.profile.entries());
        }
        if (name.equals("OutOfRange")) {
            return new Integer(this.profile.extraEntries());
        }
        if (name.equals("NaN")) {
            return new Integer(this.profile.nanEntries());
        }
        if (name.equals("SumOfWeights")) {
            return new Double(this.profile.sumBinHeights());
        }
        IAnnotation an = this.profile.annotation();
        if (an == null) {
            return null;
        }
        String v = null;
        try {
            if (an.hasKey("stat." + name)) {
                v = an.value("stat." + name);
            } else if (an.hasKey("stat:" + name)) {
                v = an.value("stat:" + name);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return v;
    }
}

