/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.IAnalysisFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.tree.Tree;
import java.io.IOException;

public class TreeFactory
implements ITreeFactory {
    private IAnalysisFactory analysisFactory;

    public TreeFactory(IAnalysisFactory analysisFactory) {
        this.analysisFactory = analysisFactory;
    }

    public ITree create() {
        return this.createTree();
    }

    public ITree create(String storeName) throws IllegalArgumentException, IOException {
        return this.create(storeName, null);
    }

    public ITree create(String storeName, String storeType) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, false, false, null, false);
    }

    public ITree create(String storeName, String storeType, boolean readOnly) throws IllegalArgumentException, IOException {
        return this.create(storeName, storeType, readOnly, false);
    }

    public ITree create(String storeName, String storeType, boolean readOnly, boolean createNew) throws IllegalArgumentException, IOException {
        return this.create(storeName, storeType, readOnly, createNew, null);
    }

    public ITree create(String storeName, String storeType, boolean readOnly, boolean createNew, String options) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, readOnly, createNew, options, true);
    }

    public ITree createTree() {
        return this.createTree(null);
    }

    public ITree createTree(String options) {
        try {
            return this.createTree(null, null, options);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public ITree createTree(String storeName, String storeType) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, 0);
    }

    public ITree createTree(String storeName, String storeType, String options) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, 0, options);
    }

    public ITree createTree(String storeName, String storeType, int mode) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, mode, null);
    }

    public ITree createTree(String storeName, String storeType, int mode, String options) throws IllegalArgumentException, IOException {
        return this.createNamedTree(null, storeName, storeType, mode, options);
    }

    public ITree createNamedTree(String name, String storeName, String storeType) throws IllegalArgumentException, IOException {
        return this.createNamedTree(name, storeName, storeType, 0);
    }

    public ITree createNamedTree(String name, String storeName, String storeType, int mode) throws IllegalArgumentException, IOException {
        return this.createNamedTree(name, storeName, storeType, mode, null);
    }

    public ITree createNamedTree(String name, String storeName, String storeType, int mode, String options) throws IllegalArgumentException, IOException {
        return new Tree(this.analysisFactory, name, storeName, storeType, mode, options);
    }

    protected ITree createTree(String storeName, String storeType, boolean readOnly, boolean createNew, String options, boolean readOnlyUserDefined) throws IllegalArgumentException, IOException {
        Tree tree = new Tree(this.analysisFactory);
        tree.init(storeName, readOnly, createNew, storeType, options, readOnlyUserDefined);
        return tree;
    }
}

