/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IAnnotation;
import hep.aida.IBaseTupleColumn;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IEvaluator;
import hep.aida.IFilter;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITuple;
import hep.aida.ITupleColumn;
import hep.aida.OutOfStorageException;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.tuple.FTuple;
import hep.aida.ref.tuple.FTupleColumn;
import hep.aida.ref.tuple.FTupleCursor;
import hep.aida.ref.tuple.Tuple;
import hep.aida.ref.tuple.TupleCursor;
import java.util.Hashtable;
import org.freehep.util.Value;

public abstract class AbstractTuple
extends ManagedObject
implements ITuple,
FTuple {
    private String title;
    private String options;
    private IAnnotation annotation = new Annotation();
    private Hashtable columnHash = new Hashtable();
    private Value v = new Value();
    private TupleCursor cursor;

    public AbstractTuple(String name, String options) {
        this(name, null, options);
    }

    public AbstractTuple(String name, String title, String options) {
        super(name);
        this.setTitle(title);
        this.options = options;
    }

    public abstract double columnMax(int var1) throws IllegalArgumentException;

    public abstract double columnMean(int var1) throws IllegalArgumentException;

    public abstract double columnMin(int var1) throws IllegalArgumentException;

    public abstract String columnName(int var1) throws IllegalArgumentException;

    public abstract double columnRms(int var1) throws IllegalArgumentException;

    public abstract Class columnType(int var1) throws IllegalArgumentException;

    public abstract int columns();

    public abstract String columnDefaultString(int var1);

    public abstract void addRow() throws OutOfStorageException;

    public abstract int findColumn(String var1) throws IllegalArgumentException;

    public abstract ITuple findTuple(int var1);

    public abstract int rows();

    public abstract void reset();

    public abstract void resetRow();

    public abstract void columnValue(int var1, Value var2);

    public abstract void fill(int var1, Value var2);

    public FTuple tuple(int index) {
        return (FTuple)this.findTuple(index);
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean providesColumnDefaultValues() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    int startRow() {
        return 0;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    private String defaultStringForType(Class type) {
        String defString = "";
        if (type == Integer.TYPE) {
            defString = "0";
        } else if (type == Short.TYPE) {
            defString = "0";
        } else if (type == Long.TYPE) {
            defString = "0";
        } else if (type == Float.TYPE) {
            defString = "0";
        } else if (type == Double.TYPE) {
            defString = "0";
        } else if (type == Boolean.TYPE) {
            defString = "false";
        } else if (type == Byte.TYPE) {
            defString = "0";
        } else if (type == Character.TYPE) {
            char[] chArr = new char[]{'\u0000'};
            defString = new String(chArr);
        }
        return defString;
    }

    public Object columnDefaultValue(int column) {
        Class type = this.columnType(column);
        String defString = this.columnDefaultString(column);
        if (this.isEmpty(defString)) {
            defString = this.defaultStringForType(type);
        }
        if (type == Integer.TYPE) {
            return new Integer(defString);
        }
        if (type == Short.TYPE) {
            return new Short(defString);
        }
        if (type == Long.TYPE) {
            return new Long(defString);
        }
        if (type == Float.TYPE) {
            return new Float(defString);
        }
        if (type == Double.TYPE) {
            return new Double(defString);
        }
        if (type == Boolean.TYPE) {
            return new Boolean(defString);
        }
        if (type == Byte.TYPE) {
            return new Byte(defString);
        }
        if (type == Character.TYPE) {
            return new Character(defString.toCharArray()[0]);
        }
        if (type == ITuple.class) {
            return new Tuple(this.name(), this.title(), defString, null);
        }
        return defString;
    }

    public String getOptions() {
        return this.options;
    }

    public FTupleCursor cursor() {
        return new TupleCursor(this);
    }

    public void newInternalCursor() {
        this.cursor = null;
    }

    protected TupleCursor internalCursor() {
        if (this.cursor == null) {
            this.cursor = new TupleCursor(this);
            this.cursor.start();
        }
        return this.cursor;
    }

    public void setRow(int row) {
        this.internalCursor().setRow(row);
    }

    public void start() {
        this.internalCursor().start();
    }

    public void skip(int rows) {
        this.internalCursor().skip(rows);
    }

    public boolean next() {
        return this.internalCursor().next();
    }

    public int getRow() {
        return this.internalCursor().row();
    }

    public void columnValue(int index, FTupleCursor c, Value v) {
        if (!this.supportsRandomAccess() && c.row() != this.getRow()) {
            throw new RuntimeException("This tuple does not support random access");
        }
        this.setRow(c.row());
        this.columnValue(index, v);
    }

    public boolean getBoolean(int index) throws ClassCastException {
        if (this.columnType(index) != Boolean.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to boolean.");
        }
        this.columnValue(index, this.v);
        return this.v.getBoolean();
    }

    public byte getByte(int index) throws ClassCastException {
        if (this.columnType(index) != Byte.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to byte.");
        }
        this.columnValue(index, this.v);
        return this.v.getByte();
    }

    public char getChar(int index) throws ClassCastException {
        if (this.columnType(index) != Character.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to char.");
        }
        this.columnValue(index, this.v);
        return this.v.getChar();
    }

    public double getDouble(int index) throws ClassCastException {
        if (this.columnType(index) != Double.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to double.");
        }
        this.columnValue(index, this.v);
        return this.v.getDouble();
    }

    public float getFloat(int index) throws ClassCastException {
        if (this.columnType(index) != Float.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to float.");
        }
        this.columnValue(index, this.v);
        return this.v.getFloat();
    }

    public int getInt(int index) throws ClassCastException {
        if (this.columnType(index) != Integer.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to int.");
        }
        this.columnValue(index, this.v);
        return this.v.getInt();
    }

    public long getLong(int index) throws ClassCastException {
        if (this.columnType(index) != Long.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to long.");
        }
        this.columnValue(index, this.v);
        return this.v.getLong();
    }

    public Object getObject(int index) throws ClassCastException {
        if (this.columnType(index).isPrimitive()) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to Object.");
        }
        this.columnValue(index, this.v);
        return this.v.getObject();
    }

    public short getShort(int index) throws ClassCastException {
        if (this.columnType(index) != Short.TYPE) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to short.");
        }
        this.columnValue(index, this.v);
        return this.v.getShort();
    }

    public String getString(int index) throws ClassCastException {
        if (this.columnType(index) != String.class) {
            throw new ClassCastException("Cannot cast column " + this.columnName(index) + "  to String.");
        }
        this.columnValue(index, this.v);
        return this.v.getString();
    }

    public void fill(double[] values) throws IllegalArgumentException {
        int nCol = this.columns();
        if (values.length != nCol) {
            throw new IllegalArgumentException("Wrong number of values provided " + values.length + ". It has to match the number of columns " + nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            this.fill(i, this.v.set(values[i]));
        }
    }

    public void fill(float[] values) throws IllegalArgumentException {
        int nCol = this.columns();
        if (values.length != nCol) {
            throw new IllegalArgumentException("Wrong number of values provided " + values.length + ". It has to match the number of columns " + nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            this.fill(i, this.v.set(values[i]));
        }
    }

    public void fill(int index, boolean value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, byte value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, char value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, double value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, float value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, int value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, Object obj) throws IllegalArgumentException {
        this.fill(index, this.v.set(obj));
    }

    public void fill(int index, String str) throws IllegalArgumentException {
        this.fill(index, this.v.set(str));
    }

    public void fill(int index, long value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public void fill(int index, short value) throws IllegalArgumentException {
        this.fill(index, this.v.set(value));
    }

    public String[] columnNames() {
        String[] result = new String[this.columns()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnName(i);
        }
        return result;
    }

    public Class[] columnTypes() {
        Class[] result = new Class[this.columns()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnType(i);
        }
        return result;
    }

    public String title() {
        return this.title == null ? this.name() : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public void setAnnotation(IAnnotation annotation) {
        this.annotation = annotation;
    }

    public ITuple getTuple(int col) {
        return this.findTuple(col);
    }

    public IBaseTupleColumn column(int index) {
        return this.column(this.columnName(index));
    }

    public IBaseTupleColumn column(String name) {
        Object col = this.columnHash.get(name);
        if (col == null) {
            col = AbstractTupleColumnFactory.createColumn(this, this.findColumn(name));
            this.columnHash.put(name, col);
        }
        return (IBaseTupleColumn)col;
    }

    public FTupleColumn columnByIndex(int index) {
        return (FTupleColumn)this.column(index);
    }

    public FTupleColumn columnByName(String name) {
        return (FTupleColumn)this.column(name);
    }

    public double evaluateMin(IEvaluator evaluator) throws IllegalArgumentException {
        double min = Double.NaN;
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            double tmp = evaluator.evaluateDouble();
            if (!Double.isNaN(min) && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public double evaluateMin(IEvaluator evaluator, IFilter filter) throws IllegalArgumentException {
        double min = Double.NaN;
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            double tmp = evaluator.evaluateDouble();
            if (!Double.isNaN(min) && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public double evaluateMax(IEvaluator evaluator) throws IllegalArgumentException {
        double max = Double.NaN;
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            double tmp = evaluator.evaluateDouble();
            if (!Double.isNaN(max) && !(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public double evaluateMax(IEvaluator evaluator, IFilter filter) throws IllegalArgumentException {
        double max = Double.NaN;
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            double tmp = evaluator.evaluateDouble();
            if (!Double.isNaN(max) && !(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public void project(IHistogram1D histogram, IEvaluator evaluator) {
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluator.evaluateDouble());
        }
    }

    public void project(IHistogram1D histogram, IEvaluator evaluator, IEvaluator weightEvaluator) {
        this.start();
        evaluator.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluator.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IHistogram1D histogram, IEvaluator evaluator, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        filter.initialize((ITuple)this);
        evaluator.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluator.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IHistogram1D histogram, IEvaluator evaluator, IFilter filter) {
        this.start();
        evaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluator.evaluateDouble());
        }
    }

    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IHistogram2D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IHistogram3D histogram, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            histogram.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud1D cloud, IEvaluator evaluator) {
        this.start();
        evaluator.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluator.evaluateDouble());
        }
    }

    public void project(ICloud1D cloud, IEvaluator evaluator, IFilter filter) {
        this.start();
        evaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluator.evaluateDouble());
        }
    }

    public void project(ICloud1D cloud, IEvaluator evaluator, IEvaluator weightEvaluator) {
        this.start();
        evaluator.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluator.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud1D cloud, IEvaluator evaluator, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        filter.initialize((ITuple)this);
        evaluator.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluator.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(ICloud2D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(ICloud3D cloud, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            cloud.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        while (this.next()) {
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble());
        }
    }

    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IProfile1D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        while (this.next()) {
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        while (this.next()) {
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble());
        }
    }

    public void project(IProfile2D profile, IEvaluator evaluatorX, IEvaluator evaluatorY, IEvaluator evaluatorZ, IFilter filter, IEvaluator weightEvaluator) {
        this.start();
        evaluatorX.initialize((ITuple)this);
        evaluatorY.initialize((ITuple)this);
        evaluatorZ.initialize((ITuple)this);
        weightEvaluator.initialize((ITuple)this);
        filter.initialize((ITuple)this);
        while (this.next()) {
            if (!filter.accept()) continue;
            profile.fill(evaluatorX.evaluateDouble(), evaluatorY.evaluateDouble(), evaluatorZ.evaluateDouble(), weightEvaluator.evaluateDouble());
        }
    }

    public static abstract class AbstractTupleColumnFactory {
        public static IBaseTupleColumn createColumn(ITuple tuple, int columnIndex) {
            Class type = tuple.columnType(columnIndex);
            if (type == Boolean.TYPE) {
                return new BooleanTupleColumn(tuple, columnIndex);
            }
            if (type == Float.TYPE) {
                return new FloatTupleColumn(tuple, columnIndex);
            }
            if (type == Integer.TYPE) {
                return new IntTupleColumn(tuple, columnIndex);
            }
            if (type == Double.TYPE) {
                return new DoubleTupleColumn(tuple, columnIndex);
            }
            if (type == Short.TYPE) {
                return new ShortTupleColumn(tuple, columnIndex);
            }
            if (type == Long.TYPE) {
                return new LongTupleColumn(tuple, columnIndex);
            }
            if (type == Character.TYPE) {
                return new CharTupleColumn(tuple, columnIndex);
            }
            if (type == Byte.TYPE) {
                return new ByteTupleColumn(tuple, columnIndex);
            }
            if (type == (class$java$lang$String == null ? (class$java$lang$String = AbstractTuple.class$("java.lang.String")) : class$java$lang$String)) {
                return new StringTupleColumn(tuple, columnIndex);
            }
            if (type == (class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = AbstractTuple.class$("hep.aida.ITuple")) : class$hep$aida$ITuple)) {
                return new ITupleTupleColumn(tuple, columnIndex);
            }
            return new ObjectTupleColumn(tuple, columnIndex);
        }

        public static class ObjectTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.Object {
            ObjectTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(Object value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public Object value() {
                return this.tuple.getObject(this.index);
            }

            public Object defaultValue() {
                return this.tuple.columnDefaultValue(this.index);
            }

            public Object fillableObject() {
                return this.defaultValue();
            }
        }

        public static class ITupleTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.ITuple {
            ITupleTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public Class type() {
                return class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = AbstractTuple.class$("hep.aida.ITuple")) : class$hep$aida$ITuple;
            }

            public void fill(ITuple value) throws IllegalArgumentException {
                this.tuple.fill(this.index, (Object)value);
            }

            public ITuple value() {
                return (ITuple)this.tuple.getObject(this.index);
            }

            public ITuple defaultValue() {
                return (ITuple)this.tuple.columnDefaultValue(this.index);
            }

            public ITuple fillableObject() {
                return this.tuple.findTuple(this.index);
            }
        }

        public static class StringTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.String {
            StringTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(String value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public String value() {
                return this.tuple.getString(this.index);
            }

            public String defaultValue() {
                return (String)this.tuple.columnDefaultValue(this.index);
            }

            public String fillableObject() {
                return this.defaultValue();
            }
        }

        public static class CharTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.C {
            CharTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(char value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public char value() {
                return this.tuple.getChar(this.index);
            }

            public char defaultValue() {
                return ((Character)this.tuple.columnDefaultValue(this.index)).charValue();
            }

            public char fillableObject() {
                return this.defaultValue();
            }
        }

        public static class LongTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.L {
            LongTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(long value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public long value() {
                return this.tuple.getLong(this.index);
            }

            public long defaultValue() {
                return (Long)this.tuple.columnDefaultValue(this.index);
            }

            public long fillableObject() {
                return this.defaultValue();
            }
        }

        public static class IntTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.I {
            IntTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(int value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public int value() {
                return this.tuple.getInt(this.index);
            }

            public int defaultValue() {
                return (Integer)this.tuple.columnDefaultValue(this.index);
            }

            public int fillableObject() {
                return this.defaultValue();
            }
        }

        public static class ShortTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.S {
            ShortTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(short value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public short value() {
                return this.tuple.getShort(this.index);
            }

            public short defaultValue() {
                return (Short)this.tuple.columnDefaultValue(this.index);
            }

            public short fillableObject() {
                return this.defaultValue();
            }
        }

        public static class ByteTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.B {
            ByteTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(byte value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public byte value() {
                return this.tuple.getByte(this.index);
            }

            public byte defaultValue() {
                return (Byte)this.tuple.columnDefaultValue(this.index);
            }

            public byte fillableObject() {
                return this.defaultValue();
            }
        }

        public static class DoubleTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.D {
            DoubleTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(double value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public double value() {
                return this.tuple.getDouble(this.index);
            }

            public double defaultValue() {
                return (Double)this.tuple.columnDefaultValue(this.index);
            }

            public double fillableObject() {
                return this.defaultValue();
            }
        }

        public static class FloatTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.F {
            FloatTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(float value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public float value() {
                return this.tuple.getFloat(this.index);
            }

            public float defaultValue() {
                return ((Float)this.tuple.columnDefaultValue(this.index)).floatValue();
            }

            public float fillableObject() {
                return this.defaultValue();
            }
        }

        public static class BooleanTupleColumn
        extends BaseTupleColumn
        implements ITupleColumn.Z {
            BooleanTupleColumn(ITuple tuple, int index) {
                super(tuple, index);
            }

            public void fill(boolean value) throws IllegalArgumentException {
                this.tuple.fill(this.index, value);
            }

            public boolean value() {
                return this.tuple.getBoolean(this.index);
            }

            public boolean defaultValue() {
                return (Boolean)this.tuple.columnDefaultValue(this.index);
            }

            public boolean fillableObject() {
                return this.defaultValue();
            }
        }

        public static class BaseTupleColumn
        implements IBaseTupleColumn,
        FTupleColumn {
            ITuple tuple;
            int index;

            BaseTupleColumn(ITuple tuple, int index) {
                this.tuple = tuple;
                this.index = index;
            }

            public String name() {
                return this.tuple.columnName(this.index);
            }

            public Class type() {
                return this.tuple.columnType(this.index);
            }

            public double minimum() {
                return this.tuple.columnMin(this.index);
            }

            public double maximum() {
                return this.tuple.columnMax(this.index);
            }

            public double mean() {
                return this.tuple.columnMean(this.index);
            }

            public double rms() {
                return this.tuple.columnRms(this.index);
            }

            public void defaultValue(Value value) {
                value.set(this.tuple.columnDefaultValue(this.index));
            }

            public boolean hasDefaultValue() {
                return true;
            }

            public void maxValue(Value value) {
                value.set(this.maximum());
            }

            public void meanValue(Value value) {
                value.set(this.mean());
            }

            public void minValue(Value value) {
                value.set(this.minimum());
            }

            public void rmsValue(Value value) {
                value.set(this.rms());
            }
        }
    }
}

