/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IFilter;
import hep.aida.ITuple;
import hep.aida.ref.tuple.JELExpression;
import hep.aida.ref.tuple.Tuple;

public class Filter
implements IFilter {
    private int rowToProcess;
    private int startingRow;
    private boolean useRows;
    private JELExpression jelExpression;
    private ITuple tuple;

    public Filter(String expression) {
        this.jelExpression = new JELExpression(expression);
        this.rowToProcess = -1;
        this.startingRow = -1;
        this.useRows = false;
    }

    public Filter(String expression, int rowToProcess) {
        this.jelExpression = new JELExpression(expression);
        if (rowToProcess < 0) {
            throw new IllegalArgumentException("Row parameter can not be negative: rowToProcess=" + rowToProcess);
        }
        this.rowToProcess = rowToProcess;
        this.startingRow = 0;
        this.useRows = false;
    }

    public Filter(String expression, int rowToProcess, int startingRow) {
        this.jelExpression = new JELExpression(expression);
        if (rowToProcess < 0 || startingRow < 0) {
            throw new IllegalArgumentException("Row parameters can not be negative: rowToProcess=" + rowToProcess + ", startingRow=" + startingRow);
        }
        this.rowToProcess = rowToProcess;
        this.startingRow = startingRow;
        this.useRows = false;
    }

    public String expression() {
        return this.jelExpression.expression();
    }

    public void initialize(ITuple tuple) {
        this.tuple = tuple;
        this.useRows = tuple instanceof Tuple;
        if (this.rowToProcess < 0 && this.startingRow < 0) {
            this.useRows = false;
        }
        this.jelExpression.compile(Boolean.TYPE, tuple);
    }

    public boolean accept() {
        if (this.useRows && this.startingRow > ((Tuple)this.tuple).getRow()) {
            return false;
        }
        if (this.useRows && this.startingRow + this.rowToProcess <= ((Tuple)this.tuple).getRow()) {
            return false;
        }
        return this.jelExpression.evaluateBoolean();
    }
}

